/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.rdx.mesh;

import com.badlogic.gdx.graphics.Color;
import java.util.function.Supplier;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.graphicsDescription.MeshDataBuilder;
import us.ihmc.graphicsDescription.MeshDataHolder;
import us.ihmc.rdx.mesh.RDXMutableMeshModel;

public class RDXMutableLineModel
extends RDXMutableMeshModel {
    public static final double EPSILON = 1.0E-4;
    private final Point3D start = new Point3D();
    private final Point3D end = new Point3D();
    private double lineWidth = Double.NaN;
    private Supplier<MeshDataHolder> meshDataSupplier;
    private final MeshDataBuilder meshDataBuilder = new MeshDataBuilder();

    public void update(Tuple3DReadOnly start, Tuple3DReadOnly end, double lineWidth, Color color) {
        if (this.meshDataSupplier == null) {
            this.meshDataSupplier = () -> {
                this.meshDataBuilder.clear();
                this.meshDataBuilder.addLine((Tuple3DReadOnly)this.start, (Tuple3DReadOnly)this.end, this.lineWidth);
                return this.meshDataBuilder.generateMeshDataHolder();
            };
        }
        boolean outOfDate = !this.start.geometricallyEquals((EuclidGeometry)start, 1.0E-4);
        outOfDate |= !this.end.geometricallyEquals((EuclidGeometry)end, 1.0E-4);
        outOfDate |= !EuclidCoreTools.epsilonEquals((double)this.lineWidth, (double)lineWidth, (double)1.0E-4);
        this.start.set(start);
        this.end.set(end);
        this.lineWidth = lineWidth;
        if (outOfDate |= this.isColorOutOfDate(color)) {
            this.updateMesh(this.meshDataSupplier.get());
        }
    }
}

