/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.rdx.mesh;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Mesh;
import com.badlogic.gdx.graphics.Texture;
import java.util.Arrays;
import java.util.List;
import us.ihmc.euclid.axisAngle.AxisAngle;
import us.ihmc.euclid.geometry.interfaces.ConvexPolygon2DReadOnly;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Point3D32;
import us.ihmc.euclid.tuple3D.Vector3D32;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.graphicsDescription.MeshDataGenerator;
import us.ihmc.graphicsDescription.MeshDataHolder;
import us.ihmc.graphicsDescription.TexCoord2f;
import us.ihmc.rdx.mesh.MeshDataGeneratorMissing;
import us.ihmc.rdx.mesh.RDXMeshBuilder;

public class RDXMultiColorMeshBuilder {
    private static final int DEFAULT_RES = 32;
    private static final float TwoPi = (float)Math.PI * 2;
    private static Texture paletteTexture;
    private int hueResolution = 256;
    private int saturationResolution = -1;
    private int brightnessResolution = -1;
    RDXMeshBuilder meshBuilder = new RDXMeshBuilder();

    public void addBox(double lx, double ly, double lz, Color color) {
        this.addMesh(MeshDataGenerator.Cube((double)lx, (double)ly, (double)lz, (boolean)true, null), color);
    }

    public void addBox(double lx, double ly, double lz, Tuple3DReadOnly offset, Color color) {
        this.addMesh(MeshDataGenerator.Cube((double)lx, (double)ly, (double)lz, (boolean)true, null), offset, color);
    }

    public void addBox(float lx, float ly, float lz, Color color) {
        this.addMesh(MeshDataGenerator.Cube((float)lx, (float)ly, (float)lz, (boolean)true, null), color);
    }

    public void addBox(float lx, float ly, float lz, Tuple3DReadOnly offset, Color color) {
        this.addMesh(MeshDataGenerator.Cube((float)lx, (float)ly, (float)lz, (boolean)true, null), offset, color);
    }

    public void addBox(float lx, float ly, float lz, Tuple3DReadOnly offset, Orientation3DReadOnly orientation, Color color) {
        this.addMesh(MeshDataGenerator.Cube((float)lx, (float)ly, (float)lz, (boolean)true, null), offset, orientation, color);
    }

    public void addCone(double height, double radius, Tuple3DReadOnly offset, Orientation3DReadOnly orientation, Color color) {
        this.addMesh(MeshDataGenerator.Cone((double)height, (double)radius, (int)32), offset, orientation, color);
    }

    public void addCone(double height, double radius, Tuple3DReadOnly offset, Color color) {
        this.addMesh(MeshDataGenerator.Cone((double)height, (double)radius, (int)32), offset, color);
    }

    public void addCube(double size, double xOffset, double yOffset, double zOffset, Color color) {
        this.addBox(size, size, size, (Tuple3DReadOnly)new Point3D(xOffset, yOffset, zOffset), color);
    }

    public void addCube(double size, Tuple3DReadOnly pointsOffset, Color color) {
        this.addBox(size, size, size, pointsOffset, color);
    }

    public void addCube(float size, Tuple3DReadOnly pointsOffset, Color color) {
        this.addBox(size, size, size, pointsOffset, color);
    }

    public void addCylinder(double height, double radius, Tuple3DReadOnly offset, Orientation3DReadOnly orientation, Color color) {
        this.addMesh(MeshDataGenerator.Cylinder((double)radius, (double)height, (int)32), offset, orientation, color);
    }

    public void addCylinder(double height, double radius, Tuple3DReadOnly offset, Color color) {
        this.addMesh(MeshDataGenerator.Cylinder((double)radius, (double)height, (int)32), offset, color);
    }

    public void addHollowCylinder(double height, double outerRadius, double innerRadius, Tuple3DReadOnly offset, Orientation3DReadOnly orientation, Color color) {
        this.addMesh(RDXMultiColorMeshBuilder.HollowCylinder(outerRadius, innerRadius, height, 32), offset, orientation, color);
    }

    public void addHollowCylinder(double height, double outerRadius, double innerRadius, Tuple3DReadOnly offset, Color color) {
        this.addMesh(RDXMultiColorMeshBuilder.HollowCylinder(outerRadius, innerRadius, height, 32), offset, color);
    }

    public static MeshDataHolder HollowCylinder(double outerRadius, double innerRadius, double height, int N) {
        return RDXMultiColorMeshBuilder.HollowCylinder((float)outerRadius, (float)innerRadius, (float)height, N);
    }

    public static MeshDataHolder HollowCylinder(float outerRadius, float innerRadius, float height, int N) {
        int i;
        float vertexY;
        float vertexX;
        float sinAngle;
        float cosAngle;
        double angle;
        int i2;
        Point3D32[] points = new Point3D32[8 * N];
        Vector3D32[] normals = new Vector3D32[8 * N];
        TexCoord2f[] textPoints = new TexCoord2f[8 * N];
        for (i2 = 0; i2 < N; ++i2) {
            angle = (float)i2 * ((float)Math.PI * 2) / (float)N;
            cosAngle = (float)Math.cos(angle);
            sinAngle = (float)Math.sin(angle);
            vertexX = outerRadius * cosAngle;
            vertexY = outerRadius * sinAngle;
            points[i2] = new Point3D32(vertexX, vertexY, 0.0f);
            normals[i2] = new Vector3D32(0.0f, 0.0f, -1.0f);
            textPoints[i2] = new TexCoord2f(0.5f * cosAngle + 0.5f, 0.5f * sinAngle + 0.5f);
            points[i2 + N] = new Point3D32(vertexX, vertexY, height);
            normals[i2 + N] = new Vector3D32(0.0f, 0.0f, 1.0f);
            textPoints[i2 + N] = new TexCoord2f(0.5f * cosAngle + 0.5f, 0.5f * sinAngle + 0.5f);
            points[i2 + 2 * N] = new Point3D32(vertexX, vertexY, 0.0f);
            normals[i2 + 2 * N] = new Vector3D32(cosAngle, sinAngle, 0.0f);
            textPoints[i2 + 2 * N] = new TexCoord2f(0.5f * cosAngle + 0.5f, 0.5f * sinAngle + 0.5f);
            points[i2 + 3 * N] = new Point3D32(vertexX, vertexY, height);
            normals[i2 + 3 * N] = new Vector3D32(cosAngle, sinAngle, 0.0f);
            textPoints[i2 + 3 * N] = new TexCoord2f(0.5f * cosAngle + 0.5f, 0.5f * sinAngle + 0.5f);
        }
        for (i2 = 0; i2 < N; ++i2) {
            angle = (float)i2 * ((float)Math.PI * 2) / (float)N;
            cosAngle = (float)Math.cos(angle);
            sinAngle = (float)Math.sin(angle);
            vertexX = innerRadius * cosAngle;
            vertexY = innerRadius * sinAngle;
            points[i2 + 4 * N] = new Point3D32(vertexX, vertexY, 0.0f);
            normals[i2 + 4 * N] = new Vector3D32(0.0f, 0.0f, -1.0f);
            textPoints[i2 + 4 * N] = new TexCoord2f(0.5f * cosAngle + 0.5f, 0.5f * sinAngle + 0.5f);
            points[i2 + 5 * N] = new Point3D32(vertexX, vertexY, height);
            normals[i2 + 5 * N] = new Vector3D32(0.0f, 0.0f, 1.0f);
            textPoints[i2 + 5 * N] = new TexCoord2f(0.5f * cosAngle + 0.5f, 0.5f * sinAngle + 0.5f);
            points[i2 + 6 * N] = new Point3D32(vertexX, vertexY, 0.0f);
            normals[i2 + 6 * N] = new Vector3D32(-cosAngle, -sinAngle, 0.0f);
            textPoints[i2 + 6 * N] = new TexCoord2f(0.5f * cosAngle + 0.5f, 0.5f * sinAngle + 0.5f);
            points[i2 + 7 * N] = new Point3D32(vertexX, vertexY, height);
            normals[i2 + 7 * N] = new Vector3D32(-cosAngle, -sinAngle, 0.0f);
            textPoints[i2 + 7 * N] = new TexCoord2f(0.5f * cosAngle + 0.5f, 0.5f * sinAngle + 0.5f);
        }
        int numberOfTriangles = 4 * N;
        int[] triangleIndices = new int[6 * numberOfTriangles];
        int index = 0;
        for (i = 0; i < N; ++i) {
            triangleIndices[index++] = i;
            triangleIndices[index++] = i + 4 * N;
            triangleIndices[index++] = (i + 1) % N;
            triangleIndices[index++] = i + 4 * N;
            triangleIndices[index++] = (i + 1) % N + 4 * N;
            triangleIndices[index++] = (i + 1) % N;
        }
        for (i = 0; i < N; ++i) {
            triangleIndices[index++] = i + N;
            triangleIndices[index++] = (i + 1) % N + N;
            triangleIndices[index++] = i + 5 * N;
            triangleIndices[index++] = i + 5 * N;
            triangleIndices[index++] = (i + 1) % N + N;
            triangleIndices[index++] = (i + 1) % N + 5 * N;
        }
        for (i = 0; i < N; ++i) {
            triangleIndices[index++] = i + 2 * N;
            triangleIndices[index++] = (i + 1) % N + 2 * N;
            triangleIndices[index++] = i + 3 * N;
            triangleIndices[index++] = (i + 1) % N + 2 * N;
            triangleIndices[index++] = (i + 1) % N + 3 * N;
            triangleIndices[index++] = i + 3 * N;
        }
        for (i = 0; i < N; ++i) {
            triangleIndices[index++] = i + 6 * N;
            triangleIndices[index++] = i + 7 * N;
            triangleIndices[index++] = (i + 1) % N + 6 * N;
            triangleIndices[index++] = (i + 1) % N + 6 * N;
            triangleIndices[index++] = i + 7 * N;
            triangleIndices[index++] = (i + 1) % N + 7 * N;
        }
        return new MeshDataHolder(points, textPoints, triangleIndices, normals);
    }

    public void addLine(double x0, double y0, double z0, double xf, double yf, double zf, double lineWidth, Color color) {
        this.addMesh(MeshDataGenerator.Line((double)x0, (double)y0, (double)z0, (double)xf, (double)yf, (double)zf, (double)lineWidth), color);
    }

    public void addLine(double x0, double y0, double z0, double xf, double yf, double zf, double lineWidth, Color startColor, Color endColor) {
        this.addLine((float)x0, (float)y0, (float)z0, (float)xf, (float)yf, (float)zf, (float)lineWidth, startColor, endColor);
    }

    public void addLine(float x0, float y0, float z0, float xf, float yf, float zf, float lineWidth, Color color) {
        this.addMesh(MeshDataGenerator.Line((float)x0, (float)y0, (float)z0, (float)xf, (float)yf, (float)zf, (float)lineWidth), color);
    }

    public void addLine(float x0, float y0, float z0, float xf, float yf, float zf, float lineWidth, Color startColor, Color endColor) {
        MeshDataHolder lineMeshData = MeshDataGenerator.Line((float)x0, (float)y0, (float)z0, (float)xf, (float)yf, (float)zf, (float)lineWidth);
        Point3D32[] vertices = lineMeshData.getVertices();
        TexCoord2f[] texturePoints = lineMeshData.getTexturePoints();
        Point3D32 start = new Point3D32(x0, y0, z0);
        Point3D32 end = new Point3D32(xf, yf, zf);
        for (int i = 0; i < vertices.length; ++i) {
            if (vertices[i].distanceSquared((Point3DReadOnly)start) < vertices[i].distanceSquared((Point3DReadOnly)end)) {
                texturePoints[i].set(RDXMultiColorMeshBuilder.getTextureLocation(startColor));
                continue;
            }
            texturePoints[i].set(RDXMultiColorMeshBuilder.getTextureLocation(endColor));
        }
        this.meshBuilder.addMesh(lineMeshData);
    }

    public void addLine(Tuple3DReadOnly start, Tuple3DReadOnly end, double lineWidth, Color color) {
        this.addLine(start.getX(), start.getY(), start.getZ(), end.getX(), end.getY(), end.getZ(), lineWidth, color);
    }

    public void addLine(Tuple3DReadOnly start, Tuple3DReadOnly end, double lineWidth, Color startColor, Color endColor) {
        this.addLine(start.getX(), start.getY(), start.getZ(), end.getX(), end.getY(), end.getZ(), lineWidth, startColor, endColor);
    }

    public void addLine(Tuple3DReadOnly start, Tuple3DReadOnly end, float lineWidth, Color color) {
        this.addLine(start.getX(), start.getY(), start.getZ(), end.getX(), end.getY(), end.getZ(), (double)lineWidth, color);
    }

    public void addLine(Tuple3DReadOnly start, Tuple3DReadOnly end, float lineWidth, Color startColor, Color endColor) {
        this.addLine(start.getX(), start.getY(), start.getZ(), end.getX(), end.getY(), end.getZ(), (double)lineWidth, startColor, endColor);
    }

    public void addCapsule(double height, double xRadius, double yRadius, double zRadius, int latitudeN, int longitudeN, Color color) {
        this.addCapsule((float)height, (float)xRadius, (float)yRadius, (float)zRadius, latitudeN, longitudeN, color);
    }

    public void addCapsule(float height, float xRadius, float yRadius, float zRadius, int latitudeN, int longitudeN, Color color) {
        this.addMesh(MeshDataGenerator.Capsule((float)height, (float)xRadius, (float)yRadius, (float)zRadius, (int)latitudeN, (int)longitudeN), color);
    }

    public void addMesh(MeshDataHolder meshDataHolder, Color color) {
        this.meshBuilder.addMesh(this.createMeshDataWithColor(meshDataHolder, color));
    }

    public void addMesh(MeshDataHolder meshDataHolder, Tuple3DReadOnly offset, Orientation3DReadOnly orientation, Color color) {
        this.meshBuilder.addMesh(this.createMeshDataWithColor(meshDataHolder, color), offset, orientation);
    }

    public void addMesh(MeshDataHolder meshDataHolder, Tuple3DReadOnly offset, Color color) {
        this.meshBuilder.addMesh(this.createMeshDataWithColor(meshDataHolder, color), offset);
    }

    public void addMultiLine(List<? extends Point3DReadOnly> points, double lineWidth, Color color, boolean close) {
        if (points.size() < 2) {
            return;
        }
        for (int i = 1; i < points.size(); ++i) {
            Point3DReadOnly start = points.get(i - 1);
            Point3DReadOnly end = points.get(i);
            this.addLine((Tuple3DReadOnly)start, (Tuple3DReadOnly)end, lineWidth, color);
        }
        if (close) {
            Point3DReadOnly start = points.get(points.size() - 1);
            Point3DReadOnly end = points.get(0);
            this.addLine((Tuple3DReadOnly)start, (Tuple3DReadOnly)end, lineWidth, color);
        }
    }

    public void addMultiLineBox(Point3DReadOnly[] eightVertices, double lineWidth, Color color) {
        if (eightVertices.length != 8) {
            throw new RuntimeException("There should be 8 vertices in this array");
        }
        this.addLine((Tuple3DReadOnly)eightVertices[0], (Tuple3DReadOnly)eightVertices[1], lineWidth, color);
        this.addLine((Tuple3DReadOnly)eightVertices[1], (Tuple3DReadOnly)eightVertices[3], lineWidth, color);
        this.addLine((Tuple3DReadOnly)eightVertices[3], (Tuple3DReadOnly)eightVertices[2], lineWidth, color);
        this.addLine((Tuple3DReadOnly)eightVertices[2], (Tuple3DReadOnly)eightVertices[0], lineWidth, color);
        this.addLine((Tuple3DReadOnly)eightVertices[0], (Tuple3DReadOnly)eightVertices[4], lineWidth, color);
        this.addLine((Tuple3DReadOnly)eightVertices[4], (Tuple3DReadOnly)eightVertices[5], lineWidth, color);
        this.addLine((Tuple3DReadOnly)eightVertices[5], (Tuple3DReadOnly)eightVertices[1], lineWidth, color);
        this.addLine((Tuple3DReadOnly)eightVertices[1], (Tuple3DReadOnly)eightVertices[5], lineWidth, color);
        this.addLine((Tuple3DReadOnly)eightVertices[5], (Tuple3DReadOnly)eightVertices[7], lineWidth, color);
        this.addLine((Tuple3DReadOnly)eightVertices[7], (Tuple3DReadOnly)eightVertices[3], lineWidth, color);
        this.addLine((Tuple3DReadOnly)eightVertices[3], (Tuple3DReadOnly)eightVertices[7], lineWidth, color);
        this.addLine((Tuple3DReadOnly)eightVertices[7], (Tuple3DReadOnly)eightVertices[6], lineWidth, color);
        this.addLine((Tuple3DReadOnly)eightVertices[6], (Tuple3DReadOnly)eightVertices[2], lineWidth, color);
        this.addLine((Tuple3DReadOnly)eightVertices[2], (Tuple3DReadOnly)eightVertices[6], lineWidth, color);
        this.addLine((Tuple3DReadOnly)eightVertices[6], (Tuple3DReadOnly)eightVertices[4], lineWidth, color);
    }

    public void addMultiLine(Point3DReadOnly[] points, double lineWidth, Color color, boolean close) {
        if (points.length < 2) {
            return;
        }
        for (int i = 1; i < points.length; ++i) {
            Point3DReadOnly start = points[i - 1];
            Point3DReadOnly end = points[i];
            this.addLine((Tuple3DReadOnly)start, (Tuple3DReadOnly)end, lineWidth, color);
        }
        if (close) {
            Point3DReadOnly start = points[points.length - 1];
            Point3DReadOnly end = points[0];
            this.addLine((Tuple3DReadOnly)start, (Tuple3DReadOnly)end, lineWidth, color);
        }
    }

    public void addMultiLine(RigidBodyTransformReadOnly transformToWorld, List<? extends Point2DReadOnly> points, double lineWidth, Color color, boolean close) {
        if (points.size() < 2) {
            return;
        }
        Point3D start = new Point3D();
        Point3D end = new Point3D();
        for (int i = 1; i < points.size(); ++i) {
            Point2DReadOnly start2d = points.get(i - 1);
            Point2DReadOnly end2d = points.get(i);
            start.set(start2d.getX(), start2d.getY(), 0.0);
            end.set(end2d.getX(), end2d.getY(), 0.0);
            transformToWorld.transform((Point3DBasics)start);
            transformToWorld.transform((Point3DBasics)end);
            this.addLine((Tuple3DReadOnly)start, (Tuple3DReadOnly)end, lineWidth, color);
        }
        if (close) {
            Point2DReadOnly start2d = points.get(points.size() - 1);
            Point2DReadOnly end2d = points.get(0);
            start.set(start2d.getX(), start2d.getY(), 0.0);
            end.set(end2d.getX(), end2d.getY(), 0.0);
            transformToWorld.transform((Point3DBasics)start);
            transformToWorld.transform((Point3DBasics)end);
            this.addLine((Tuple3DReadOnly)start, (Tuple3DReadOnly)end, lineWidth, color);
        }
    }

    public void addMultiLine(RigidBodyTransformReadOnly transformToWorld, Point2DReadOnly[] points, double lineWidth, Color color, boolean close) {
        this.addMultiLine(transformToWorld, Arrays.asList(points), lineWidth, color, close);
    }

    public void addPolygon(RigidBodyTransformReadOnly transformToWorld, ConvexPolygon2DReadOnly polygon, Color color) {
        this.addMesh(MeshDataGenerator.Polygon((RigidBodyTransformReadOnly)transformToWorld, (ConvexPolygon2DReadOnly)polygon), color);
    }

    public void addPolygon(List<? extends Point3DReadOnly> polygon, Color color) {
        this.addMesh(MeshDataGenerator.Polygon(polygon), color);
    }

    public void addPolygon(RigidBodyTransformReadOnly transformToWorld, List<? extends Point2DReadOnly> polygon, Color color) {
        this.addMesh(MeshDataGenerator.Polygon((RigidBodyTransformReadOnly)transformToWorld, polygon), color);
    }

    public void addSphere(double radius, Tuple3DReadOnly offset, Color color) {
        this.addMesh(MeshDataGenerator.Sphere((double)radius, (int)32, (int)32), offset, color);
    }

    public void addSphere(float radius, Color color) {
        this.addMesh(MeshDataGenerator.Sphere((float)radius, (int)32, (int)32), color);
    }

    public void addSphere(float radius, Tuple3DReadOnly offset, Color color) {
        this.addMesh(MeshDataGenerator.Sphere((float)radius, (int)32, (int)32), offset, color);
    }

    public void addEllipsoid(double xRadius, double yRadius, double zRadius, Tuple3DReadOnly offset, Color color) {
        this.addMesh(MeshDataGenerator.Ellipsoid((double)xRadius, (double)yRadius, (double)zRadius, (int)32, (int)32), offset, color);
    }

    public void addHemiEllipsoid(double xRadius, double yRadius, double zRadius, Tuple3DReadOnly offset, Color color) {
        this.addMesh(MeshDataGenerator.HemiEllipsoid((double)xRadius, (double)yRadius, (double)zRadius, (int)32, (int)32), offset, color);
    }

    public void addTetrahedron(double edgeLength, Tuple3DReadOnly offset, Color color) {
        this.addMesh(MeshDataGenerator.Tetrahedron((double)edgeLength), offset, color);
    }

    public void addTetrahedron(float edgeLength, Tuple3DReadOnly offset, Color color) {
        this.addMesh(MeshDataGenerator.Tetrahedron((float)edgeLength), offset, color);
    }

    public void addWedge(double lx, double ly, double lz, Color color) {
        this.addMesh(MeshDataGenerator.Wedge((double)lx, (double)ly, (double)lz), color);
    }

    public void addIsoscelesTriangularPrism(double triangleWidth, double triangleHeight, double prismThickness, Tuple3DReadOnly offset, Color color) {
        this.addMesh(RDXMultiColorMeshBuilder.IsoscelesTriangularPrism(triangleWidth, triangleHeight, prismThickness), offset, color);
    }

    public void addIsoscelesTriangularPrism(double triangleWidth, double triangleHeight, double prismThickness, Tuple3DReadOnly offset, Orientation3DReadOnly orientation, Color color) {
        this.addMesh(RDXMultiColorMeshBuilder.IsoscelesTriangularPrism(triangleWidth, triangleHeight, prismThickness), offset, orientation, color);
    }

    public static MeshDataHolder IsoscelesTriangularPrism(double triangleWidth, double triangleHeight, double prismThickness) {
        return RDXMultiColorMeshBuilder.IsoscelesTriangularPrism((float)triangleWidth, (float)triangleHeight, (float)prismThickness);
    }

    public static MeshDataHolder IsoscelesTriangularPrism(float triangleWidth, float triangleHeight, float prismThickness) {
        Point3D32[] points = new Point3D32[18];
        Vector3D32[] normals = new Vector3D32[18];
        TexCoord2f[] textPoints = new TexCoord2f[18];
        points[0] = new Point3D32(-triangleWidth / 2.0f, -prismThickness / 2.0f, 0.0f);
        normals[0] = new Vector3D32(0.0f, 0.0f, -1.0f);
        textPoints[0] = new TexCoord2f(0.0f, 0.0f);
        points[1] = new Point3D32(triangleWidth / 2.0f, -prismThickness / 2.0f, 0.0f);
        normals[1] = new Vector3D32(0.0f, 0.0f, -1.0f);
        textPoints[1] = new TexCoord2f(1.0f, 0.0f);
        points[2] = new Point3D32(triangleWidth / 2.0f, prismThickness / 2.0f, 0.0f);
        normals[2] = new Vector3D32(0.0f, 0.0f, -1.0f);
        textPoints[2] = new TexCoord2f(1.0f, 1.0f);
        points[3] = new Point3D32(-triangleWidth / 2.0f, prismThickness / 2.0f, 0.0f);
        normals[3] = new Vector3D32(0.0f, 0.0f, -1.0f);
        textPoints[3] = new TexCoord2f(0.0f, 1.0f);
        points[4] = new Point3D32(0.0f, -prismThickness / 2.0f, triangleHeight);
        normals[4] = new Vector3D32(1.0f, 0.0f, 0.0f);
        textPoints[4] = new TexCoord2f(0.0f, 1.0f);
        points[5] = new Point3D32(0.0f, prismThickness / 2.0f, triangleHeight);
        normals[5] = new Vector3D32(1.0f, 0.0f, 0.0f);
        textPoints[5] = new TexCoord2f(1.0f, 1.0f);
        points[6] = new Point3D32((Tuple3DReadOnly)points[2]);
        normals[6] = new Vector3D32(1.0f, 0.0f, 0.0f);
        textPoints[6] = new TexCoord2f(textPoints[2]);
        points[7] = new Point3D32((Tuple3DReadOnly)points[1]);
        normals[7] = new Vector3D32(1.0f, 0.0f, 0.0f);
        textPoints[7] = new TexCoord2f(textPoints[1]);
        float wedgeAngle = (float)Math.atan2(triangleHeight, (double)triangleWidth / 2.0);
        points[8] = new Point3D32((Tuple3DReadOnly)points[0]);
        normals[8] = new Vector3D32(-((float)Math.sin(wedgeAngle)), (float)Math.cos(wedgeAngle), 0.0f);
        textPoints[8] = new TexCoord2f(textPoints[0]);
        points[9] = new Point3D32((Tuple3DReadOnly)points[4]);
        normals[9] = new Vector3D32(-((float)Math.sin(wedgeAngle)), (float)Math.cos(wedgeAngle), 0.0f);
        textPoints[9] = new TexCoord2f(textPoints[4]);
        points[10] = new Point3D32((Tuple3DReadOnly)points[5]);
        normals[10] = new Vector3D32(-((float)Math.sin(wedgeAngle)), (float)Math.cos(wedgeAngle), 0.0f);
        textPoints[10] = new TexCoord2f(textPoints[5]);
        points[11] = new Point3D32((Tuple3DReadOnly)points[3]);
        normals[11] = new Vector3D32(-((float)Math.sin(wedgeAngle)), (float)Math.cos(wedgeAngle), 0.0f);
        textPoints[11] = new TexCoord2f(textPoints[3]);
        points[12] = new Point3D32((Tuple3DReadOnly)points[0]);
        normals[12] = new Vector3D32(0.0f, -1.0f, 0.0f);
        textPoints[12] = new TexCoord2f(textPoints[0]);
        points[13] = new Point3D32((Tuple3DReadOnly)points[1]);
        normals[13] = new Vector3D32(0.0f, -1.0f, 0.0f);
        textPoints[13] = new TexCoord2f(textPoints[1]);
        points[14] = new Point3D32((Tuple3DReadOnly)points[4]);
        normals[14] = new Vector3D32(0.0f, -1.0f, 0.0f);
        textPoints[14] = new TexCoord2f(textPoints[4]);
        points[15] = new Point3D32((Tuple3DReadOnly)points[2]);
        normals[15] = new Vector3D32(0.0f, 1.0f, 0.0f);
        textPoints[15] = new TexCoord2f(textPoints[2]);
        points[16] = new Point3D32((Tuple3DReadOnly)points[3]);
        normals[16] = new Vector3D32(0.0f, 1.0f, 0.0f);
        textPoints[16] = new TexCoord2f(textPoints[3]);
        points[17] = new Point3D32((Tuple3DReadOnly)points[5]);
        normals[17] = new Vector3D32(0.0f, 1.0f, 0.0f);
        textPoints[17] = new TexCoord2f(textPoints[5]);
        int numberOfTriangles = 8;
        int[] triangleIndices = new int[3 * numberOfTriangles];
        int index = 0;
        triangleIndices[index++] = 0;
        triangleIndices[index++] = 2;
        triangleIndices[index++] = 1;
        triangleIndices[index++] = 0;
        triangleIndices[index++] = 3;
        triangleIndices[index++] = 2;
        triangleIndices[index++] = 7;
        triangleIndices[index++] = 5;
        triangleIndices[index++] = 4;
        triangleIndices[index++] = 5;
        triangleIndices[index++] = 7;
        triangleIndices[index++] = 6;
        triangleIndices[index++] = 8;
        triangleIndices[index++] = 9;
        triangleIndices[index++] = 10;
        triangleIndices[index++] = 8;
        triangleIndices[index++] = 10;
        triangleIndices[index++] = 11;
        triangleIndices[index++] = 12;
        triangleIndices[index++] = 13;
        triangleIndices[index++] = 14;
        triangleIndices[index++] = 15;
        triangleIndices[index++] = 16;
        triangleIndices[index++] = 17;
        return new MeshDataHolder(points, textPoints, triangleIndices, normals);
    }

    public void addArcTorus(double startAngle, double endAngle, double majorRadius, double minorRadius, Color color) {
        this.addMesh(MeshDataGenerator.ArcTorus((double)startAngle, (double)endAngle, (double)majorRadius, (double)minorRadius, (int)25), color);
    }

    public void addArcTorus(double startAngle, double endAngle, double majorRadius, double minorRadius, int resolution, Color color) {
        this.addMesh(MeshDataGenerator.ArcTorus((double)startAngle, (double)endAngle, (double)majorRadius, (double)minorRadius, (int)resolution), color);
    }

    public void addArrow(double arrowBodyLength, Color color) {
        this.addMesh(MeshDataGeneratorMissing.Arrow(arrowBodyLength), color);
    }

    public void addMesh(MeshDataHolder meshDataHolder, Tuple3DReadOnly offset, AxisAngle orientation, Color color) {
        this.meshBuilder.addMesh(this.createMeshDataWithColor(meshDataHolder, color), offset, (Orientation3DReadOnly)orientation);
    }

    private MeshDataHolder createMeshDataWithColor(MeshDataHolder input, Color color) {
        if (input == null) {
            return null;
        }
        Point3D32[] vertices = input.getVertices();
        int[] triangleIndices = input.getTriangleIndices();
        Vector3D32[] vertexNormals = input.getVertexNormals();
        TexCoord2f[] inputTexturePoints = input.getTexturePoints();
        TexCoord2f[] outputTexturePoints = new TexCoord2f[inputTexturePoints.length];
        float[] textureLocation = RDXMultiColorMeshBuilder.getTextureLocation(color);
        for (int i = 0; i < inputTexturePoints.length; ++i) {
            outputTexturePoints[i] = new TexCoord2f(textureLocation);
        }
        return new MeshDataHolder(vertices, outputTexturePoints, triangleIndices, vertexNormals);
    }

    public static float[] getTextureLocation(Color color) {
        float y;
        float x;
        float[] hsv = new float[3];
        color.toHsv(hsv);
        float hue = hsv[0];
        float saturation = hsv[1];
        float value = hsv[2];
        if ((double)saturation < 0.1) {
            x = value;
            y = 0.98f;
        } else {
            float percentHeightIsHues = 0.84210527f;
            x = hue / 360.0f;
            y = percentHeightIsHues - percentHeightIsHues * value / 2.0f;
        }
        return new float[]{x, y};
    }

    public static String getPalletImagePath() {
        return "RGB_24bits_hue_value_palette.png";
    }

    public static Texture loadPaletteTexture() {
        if (paletteTexture == null) {
            paletteTexture = new Texture(Gdx.files.classpath(RDXMultiColorMeshBuilder.getPalletImagePath()));
        }
        return paletteTexture;
    }

    public Mesh generateMesh() {
        return this.meshBuilder.generateMesh();
    }

    public MeshDataHolder generateMeshDataHolder() {
        return this.meshBuilder.generateMeshDataHolder();
    }

    public void clear() {
        this.meshBuilder.clear();
    }
}

