/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.rdx.input;

import com.badlogic.gdx.math.Vector3;
import imgui.internal.ImGui;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import us.ihmc.euclid.Axis3D;
import us.ihmc.euclid.geometry.Line3D;
import us.ihmc.euclid.geometry.interfaces.Line3DReadOnly;
import us.ihmc.euclid.geometry.tools.EuclidGeometryTools;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.rdx.imgui.ImGuiTools;
import us.ihmc.rdx.input.ImGui3DViewPickResult;
import us.ihmc.rdx.input.ImGuiMouseDragData;
import us.ihmc.rdx.tools.LibGDXTools;
import us.ihmc.rdx.ui.RDX3DPanel;

public class ImGui3DViewInput {
    private final RDX3DPanel panel;
    private final ImGuiMouseDragData mouseDragDataLeft = new ImGuiMouseDragData(0);
    private final ImGuiMouseDragData mouseDragDataRight = new ImGuiMouseDragData(1);
    private final ImGuiMouseDragData mouseDragDataMiddle = new ImGuiMouseDragData(2);
    private final ImGuiMouseDragData[] mouseDragData = new ImGuiMouseDragData[]{this.mouseDragDataLeft, this.mouseDragDataRight, this.mouseDragDataMiddle};
    private float mousePosX = 0.0f;
    private float mousePosY = 0.0f;
    private boolean isWindowHovered;
    private float mouseWheelDelta;
    private final Vector3 gdxOrigin = new Vector3();
    private final Vector3 gdxDirection = new Vector3();
    private final Line3D pickRayInWorld = new Line3D();
    private boolean computedPickRay = false;
    private boolean initialized = false;
    private final ArrayList<ImGui3DViewPickResult> pickResults = new ArrayList();
    private ImGui3DViewPickResult closestPick = null;
    private final FramePoint3D tempCameraPose = new FramePoint3D();
    private final FramePoint3D pickPoint = new FramePoint3D();
    private double lastZCollision;

    public ImGui3DViewInput(RDX3DPanel panel) {
        this.panel = panel;
    }

    public void compute() {
        if (!this.initialized) {
            this.initialized = true;
        }
        this.computedPickRay = false;
        this.isWindowHovered = ImGui.isWindowHovered();
        this.mousePosX = (int)ImGui.getMousePosX() - (int)ImGui.getWindowPosX();
        this.mousePosY = (int)ImGui.getMousePosY() - (int)ImGui.getWindowPosY() - (int)ImGuiTools.TAB_BAR_HEIGHT;
        this.mouseWheelDelta = -ImGui.getIO().getMouseWheel();
        for (ImGuiMouseDragData mouseDragDatum : this.mouseDragData) {
            mouseDragDatum.update();
        }
        this.pickResults.clear();
    }

    public Line3DReadOnly getPickRayInWorld() {
        if (!this.computedPickRay) {
            this.computedPickRay = true;
            float viewportWidth = this.panel.getViewportSizeX();
            float viewportHeight = this.panel.getViewportSizeY();
            float viewportX = 2.0f * this.getMousePosX() / viewportWidth - 1.0f;
            float viewportY = 2.0f * (viewportHeight - this.getMousePosY()) / viewportHeight - 1.0f;
            this.gdxOrigin.set(viewportX, viewportY, -1.0f);
            this.gdxOrigin.prj(this.panel.getCamera3D().invProjectionView);
            this.gdxDirection.set(viewportX, viewportY, 1.0f);
            this.gdxDirection.prj(this.panel.getCamera3D().invProjectionView);
            this.gdxDirection.sub(this.gdxOrigin).nor();
            LibGDXTools.toEuclid(this.gdxOrigin, this.pickRayInWorld.getPoint());
            LibGDXTools.toEuclid(this.gdxDirection, (Vector3DBasics)this.pickRayInWorld.getDirection());
        }
        return this.pickRayInWorld;
    }

    public Point3DReadOnly getPickPointInWorld() {
        return this.getPickPointInWorld(Double.NaN);
    }

    public Point3DReadOnly getPickPointInWorld(double fallbackXYPlaneIntersectionHeight) {
        ByteBuffer depthBuffer = this.panel.getNormalizedDeviceCoordinateDepthDirectByteBuffer();
        boolean mouseInBounds = true;
        mouseInBounds &= this.mousePosX >= 0.0f;
        mouseInBounds &= this.mousePosY >= 0.0f;
        mouseInBounds &= this.mousePosX < this.panel.getViewportSizeX();
        if (mouseInBounds &= this.mousePosY < this.panel.getViewportSizeY()) {
            boolean fallbackToXYPlaneIntersection = true;
            if (depthBuffer != null) {
                int aliasedMouseX;
                int columnAdjustment;
                int antiAliasing;
                int aliasedMouseY;
                int mousePosXInt = (int)this.mousePosX;
                int mousePosYInt = (int)this.mousePosY;
                int aliasedRenderedAreaWidth = (int)this.panel.getRenderSizeX();
                int aliasedRenderedAreaHeight = (int)this.panel.getRenderSizeY();
                int aliasedFlippedMouseY = aliasedRenderedAreaHeight - (aliasedMouseY = mousePosYInt * (antiAliasing = this.panel.getAntiAliasing()));
                int rowAdjustment = aliasedFlippedMouseY * aliasedRenderedAreaWidth * 4;
                float normalizedDeviceCoordinateZ = 2.0f * depthBuffer.getFloat(rowAdjustment + (columnAdjustment = (aliasedMouseX = mousePosXInt * antiAliasing) * 4)) - 1.0f;
                if (normalizedDeviceCoordinateZ < 1.0f) {
                    fallbackToXYPlaneIntersection = false;
                    float cameraNear = this.panel.getCamera3D().near;
                    float cameraFar = this.panel.getCamera3D().far;
                    float twoXCameraFarNear = 2.0f * cameraNear * cameraFar;
                    float farPlusNear = cameraFar + cameraNear;
                    float farMinusNear = cameraFar - cameraNear;
                    float eyeDepth = twoXCameraFarNear / (farPlusNear - normalizedDeviceCoordinateZ * farMinusNear);
                    float principalOffsetXPixels = (float)aliasedRenderedAreaWidth / 2.0f;
                    float principalOffsetYPixels = (float)aliasedRenderedAreaHeight / 2.0f;
                    float fieldOfViewY = this.panel.getCamera3D().getVerticalFieldOfView();
                    float focalLengthPixels = (float)((double)aliasedRenderedAreaHeight / 2.0 / Math.tan(Math.toRadians((double)fieldOfViewY / 2.0)));
                    float zUp3DX = eyeDepth;
                    float zUp3DY = -((float)aliasedMouseX - principalOffsetXPixels) / focalLengthPixels * eyeDepth;
                    float zUp3DZ = -((float)aliasedMouseY - principalOffsetYPixels) / focalLengthPixels * eyeDepth;
                    this.tempCameraPose.setToZero(this.panel.getCamera3D().getCameraFrame());
                    this.tempCameraPose.changeFrame(ReferenceFrame.getWorldFrame());
                    this.pickPoint.setIncludingFrame(this.panel.getCamera3D().getCameraFrame(), (double)zUp3DX, (double)zUp3DY, (double)zUp3DZ);
                    this.pickPoint.changeFrame(ReferenceFrame.getWorldFrame());
                    this.lastZCollision = this.pickPoint.getZ();
                }
            }
            if (fallbackToXYPlaneIntersection) {
                double xyZHeight = Double.isNaN(fallbackXYPlaneIntersectionHeight) ? this.lastZCollision : fallbackXYPlaneIntersectionHeight;
                this.pickPoint.setIncludingFrame(ReferenceFrame.getWorldFrame(), (Tuple3DReadOnly)EuclidCoreTools.origin3D);
                this.pickPoint.setZ(xyZHeight);
                this.getPickRayInWorld();
                EuclidGeometryTools.intersectionBetweenLine3DAndPlane3D((Point3DReadOnly)this.pickPoint, (Vector3DReadOnly)Axis3D.Z, (Point3DReadOnly)this.pickRayInWorld.getPoint(), (Vector3DReadOnly)this.pickRayInWorld.getDirection(), (Point3DBasics)this.pickPoint);
            }
        }
        return this.pickPoint;
    }

    public Point3DReadOnly getGroundPickPointInWorld(double fallbackXYPlaneIntersectionHeight) {
        double xyZHeight = Double.isNaN(fallbackXYPlaneIntersectionHeight) ? this.lastZCollision : fallbackXYPlaneIntersectionHeight;
        this.pickPoint.setIncludingFrame(ReferenceFrame.getWorldFrame(), (Tuple3DReadOnly)EuclidCoreTools.origin3D);
        this.pickPoint.setZ(xyZHeight);
        this.getPickRayInWorld();
        EuclidGeometryTools.intersectionBetweenLine3DAndPlane3D((Point3DReadOnly)this.pickPoint, (Vector3DReadOnly)Axis3D.Z, (Point3DReadOnly)this.pickRayInWorld.getPoint(), (Vector3DReadOnly)this.pickRayInWorld.getDirection(), (Point3DBasics)this.pickPoint);
        return this.pickPoint;
    }

    public void addPickResult(ImGui3DViewPickResult pickResult) {
        this.pickResults.add(pickResult);
    }

    public void calculateClosestPick() {
        this.closestPick = null;
        for (ImGui3DViewPickResult pickResult : this.pickResults) {
            if (this.closestPick == null) {
                this.closestPick = pickResult;
                continue;
            }
            if (!(pickResult.getDistanceToCamera() < this.closestPick.getDistanceToCamera())) continue;
            this.closestPick = pickResult;
        }
    }

    public boolean mouseReleasedWithoutDrag(int button) {
        return ImGui.getMouseDragDeltaX((int)button) == 0.0f && ImGui.getMouseDragDeltaY((int)button) == 0.0f && ImGui.isMouseReleased((int)button);
    }

    public boolean isWindowHovered() {
        return this.isWindowHovered;
    }

    public ImGuiMouseDragData getMouseDragData(int imGuiMouseButton) {
        return this.mouseDragData[imGuiMouseButton];
    }

    public float getMousePosX() {
        return this.mousePosX;
    }

    public float getMousePosY() {
        return this.mousePosY;
    }

    public float getMouseWheelDelta() {
        return this.mouseWheelDelta;
    }

    public ImGui3DViewPickResult getClosestPick() {
        return this.closestPick;
    }
}

