/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.rdx.imgui;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import gnu.trove.map.hash.TIntObjectHashMap;
import imgui.ImGui;
import imgui.internal.ImGuiDockNode;
import imgui.type.ImBoolean;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.annotation.Nullable;
import us.ihmc.log.LogTools;
import us.ihmc.rdx.imgui.RDXDockspacePanel;
import us.ihmc.rdx.imgui.RDXPanelSizeHandler;

public class RDXPanel
extends RDXPanelSizeHandler {
    private final String panelName;
    private Runnable render;
    private final ImBoolean isShowing;
    private final boolean hasMenuBar;
    private final TreeSet<RDXPanel> children = new TreeSet<RDXPanel>(Comparator.comparing(RDXPanel::getPanelName));
    private final ConcurrentLinkedQueue<RDXPanel> removalQueue = new ConcurrentLinkedQueue();
    private final ConcurrentLinkedQueue<RDXPanel> additionQueue = new ConcurrentLinkedQueue();
    @Nullable
    private RDXDockspacePanel parentDockspacePanel = null;
    private boolean isOnMainViewport = false;

    public RDXPanel(String panelName) {
        this(panelName, null, false);
    }

    public RDXPanel(String panelName, Runnable render) {
        this(panelName, render, false);
    }

    public RDXPanel(String panelName, Runnable render, boolean isShowing) {
        this(panelName, render, isShowing, false);
    }

    public RDXPanel(String panelName, Runnable render, boolean isShowing, boolean hasMenuBar) {
        this.panelName = panelName;
        this.render = render;
        this.isShowing = new ImBoolean(isShowing);
        this.hasMenuBar = hasMenuBar;
    }

    void renderMenuItem() {
        this.renderMenuItem("");
    }

    void renderMenuItem(String indent) {
        ImGui.menuItem((String)(indent + this.panelName), (String)"", (ImBoolean)this.isShowing);
        for (RDXPanel child : this.children) {
            child.renderMenuItem(indent + "\t");
        }
    }

    void renderPanelAndChildren(TIntObjectHashMap<RDXDockspacePanel> dockIDMap, boolean lockPanelsWithinWindows) {
        while (!this.removalQueue.isEmpty()) {
            this.children.remove(this.removalQueue.poll());
        }
        while (!this.additionQueue.isEmpty()) {
            this.children.add(this.additionQueue.poll());
        }
        if (this.parentDockspacePanel != null) {
            this.isShowing.set(this.parentDockspacePanel.getIsShowing());
        }
        if (this.isShowing.get() && this.render != null) {
            this.handleSizeBeforeBegin();
            if (lockPanelsWithinWindows) {
                if (this.isOnMainViewport) {
                    ImGui.setNextWindowViewport((int)ImGui.getMainViewport().getID());
                } else if (this.parentDockspacePanel != null) {
                    ImGui.setNextWindowViewport((int)this.parentDockspacePanel.getWindowViewportID());
                }
            }
            int windowFlags = 0;
            if (this.hasMenuBar) {
                windowFlags |= 0x400;
            }
            ImGui.begin((String)this.panelName, (ImBoolean)this.isShowing, (int)windowFlags);
            this.handleSizeAfterBegin();
            int windowDockID = ImGui.getWindowDockID();
            this.findParentDockspacePanel(windowDockID, dockIDMap);
            this.render.run();
            ImGui.end();
        }
        for (RDXPanel child : this.children) {
            child.renderPanelAndChildren(dockIDMap, lockPanelsWithinWindows);
        }
    }

    private void findParentDockspacePanel(int nodeID, TIntObjectHashMap<RDXDockspacePanel> dockIDMap) {
        ImGuiDockNode dockNode = imgui.internal.ImGui.dockBuilderGetNode((int)nodeID);
        if (dockNode.ptr == 0L) {
            this.parentDockspacePanel = null;
            this.isOnMainViewport = true;
        } else if (dockNode.isDockSpace()) {
            this.parentDockspacePanel = (RDXDockspacePanel)dockIDMap.get(dockNode.getID());
            this.isOnMainViewport = this.parentDockspacePanel == null;
        } else if (dockNode.getParentNode().ptr == 0L) {
            LogTools.error((String)"Not sure why this would happen yet but pretty sure it did once.");
        } else {
            this.findParentDockspacePanel(dockNode.getParentNode().getID(), dockIDMap);
        }
    }

    public void addChild(RDXPanel child) {
        this.children.add(child);
    }

    public void queueRemoveChild(RDXPanel panel) {
        this.removalQueue.add(panel);
    }

    public void queueAddChild(RDXPanel panel) {
        this.additionQueue.add(panel);
    }

    void load(Map.Entry<String, JsonNode> panelEntry) {
        if (this.panelName.equals(panelEntry.getKey())) {
            this.isShowing.set(panelEntry.getValue().asBoolean());
        }
        for (RDXPanel child : this.children) {
            child.load(panelEntry);
        }
    }

    void save(ObjectNode anchorJSON) {
        anchorJSON.put(this.panelName, this.isShowing.get());
        for (RDXPanel child : this.children) {
            child.save(anchorJSON);
        }
    }

    public void setRenderMethod(Runnable render) {
        this.render = render;
    }

    public ImBoolean getIsShowing() {
        return this.isShowing;
    }

    public String getPanelName() {
        return this.panelName;
    }

    public TreeSet<RDXPanel> getChildren() {
        return this.children;
    }
}

