/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.rdx.imgui;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Mesh;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g3d.Attribute;
import com.badlogic.gdx.graphics.g3d.Material;
import com.badlogic.gdx.graphics.g3d.Model;
import com.badlogic.gdx.graphics.g3d.Renderable;
import com.badlogic.gdx.graphics.g3d.attributes.BlendingAttribute;
import com.badlogic.gdx.graphics.g3d.model.MeshPart;
import com.badlogic.gdx.graphics.g3d.utils.MeshBuilder;
import com.badlogic.gdx.graphics.g3d.utils.ModelBuilder;
import com.badlogic.gdx.graphics.glutils.FrameBuffer;
import com.badlogic.gdx.graphics.glutils.GLFrameBuffer;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Pool;
import imgui.ImFont;
import imgui.ImGui;
import imgui.ImGuiIO;
import imgui.ImGuiPlatformIO;
import imgui.gl3.ImGuiImplGl3;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import net.mgsx.gltf.scene3d.attributes.PBRColorAttribute;
import net.mgsx.gltf.scene3d.attributes.PBRTextureAttribute;
import org.lwjgl.opengl.GL41;
import us.ihmc.commons.MathTools;
import us.ihmc.euclid.Axis3D;
import us.ihmc.euclid.geometry.Plane3D;
import us.ihmc.euclid.geometry.interfaces.Line3DReadOnly;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.tools.ReferenceFrameTools;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.transform.interfaces.Transform;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.UnitVector3DReadOnly;
import us.ihmc.rdx.imgui.ImGuiTools;
import us.ihmc.rdx.tools.LibGDXTools;
import us.ihmc.rdx.tools.RDXModelInstance;
import us.ihmc.rdx.vr.RDXVRContext;
import us.ihmc.rdx.vr.RDXVRPickResult;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.robotics.robotSide.SideDependentList;

public class RDX3DSituatedImGuiPanel {
    private final String name;
    private final Runnable renderImGuiWidgets;
    private RDXModelInstance modelInstance = null;
    private ImGuiImplGl3 imGuiGl3;
    private long imGuiContext;
    private float pixelsWidth;
    private float pixelsHeight;
    private float panelWidthInMeters;
    private float panelHeightInMeters;
    private float halfPanelWidthInMeters;
    private float halfPanelHeightInMeters;
    private float metersToPixels;
    private FrameBuffer frameBuffer;
    private boolean useTransparentBackground = false;
    private int backgroundColor;
    private float mousePosX = -20.0f;
    private float mousePosY = -20.0f;
    private boolean leftMouseDown = false;
    private final AtomicLong INDEX = new AtomicLong(0L);
    private final RigidBodyTransform transform = new RigidBodyTransform();
    private final RigidBodyTransform graphicsXRightYDownToCenterXThroughZUpTransform = new RigidBodyTransform();
    private final ReferenceFrame centerXThroughZUpFrame = ReferenceFrameTools.constructFrameWithChangingTransformToParent((String)("centerXThroughZUpFrame" + this.INDEX.getAndIncrement()), (ReferenceFrame)ReferenceFrame.getWorldFrame(), (RigidBodyTransformReadOnly)this.transform);
    private final ReferenceFrame graphicsXRightYDownFrame = ReferenceFrameTools.constructFrameWithChangingTransformToParent((String)("graphicsXRightYDownFrame" + this.INDEX.getAndIncrement()), (ReferenceFrame)this.centerXThroughZUpFrame, (RigidBodyTransformReadOnly)this.graphicsXRightYDownToCenterXThroughZUpTransform);
    private final Plane3D plane = new Plane3D();
    private final FramePoint3D pickIntersection = new FramePoint3D();
    private final SideDependentList<RDXVRPickResult> pickResult = new SideDependentList(RDXVRPickResult::new);

    public RDX3DSituatedImGuiPanel(String name, Runnable renderImGuiWidgets) {
        this.name = name;
        this.renderImGuiWidgets = renderImGuiWidgets;
        for (RobotSide side : RobotSide.values) {
            ((RDXVRPickResult)this.pickResult.get((Enum)side)).setPickedObjectID(this, name + " ImGui Panel");
        }
    }

    public void create(ImGuiImplGl3 imGuiGl3, double panelWidthInMeters, double panelHeightInMeters, int pixelsPerCentimeter) {
        this.imGuiGl3 = imGuiGl3;
        this.panelWidthInMeters = (float)panelWidthInMeters;
        this.panelHeightInMeters = (float)panelHeightInMeters;
        this.halfPanelWidthInMeters = this.panelWidthInMeters / 2.0f;
        this.halfPanelHeightInMeters = this.panelHeightInMeters / 2.0f;
        this.metersToPixels = pixelsPerCentimeter * 100;
        this.pixelsWidth = Math.round(panelWidthInMeters * (double)this.metersToPixels);
        this.pixelsHeight = Math.round(panelHeightInMeters * (double)this.metersToPixels);
        this.imGuiContext = ImGuiTools.createContext(ImGuiTools.getFontAtlas());
        ImGuiTools.setCurrentContext(this.imGuiContext);
        ImGuiIO io = ImGui.getIO();
        io.setIniFilename(null);
        io.setMouseDrawCursor(true);
        ImGuiTools.initializeColorStyle();
        this.buildModel();
        this.graphicsXRightYDownToCenterXThroughZUpTransform.appendYawRotation(-Math.toRadians(90.0));
        this.graphicsXRightYDownToCenterXThroughZUpTransform.appendPitchRotation(Math.toRadians(0.0));
        this.graphicsXRightYDownToCenterXThroughZUpTransform.appendRollRotation(-Math.toRadians(90.0));
        this.graphicsXRightYDownToCenterXThroughZUpTransform.appendTranslation((double)(-this.halfPanelWidthInMeters), (double)(-this.halfPanelHeightInMeters), 0.0);
        this.graphicsXRightYDownFrame.update();
        this.plane.getNormal().set((UnitVector3DReadOnly)Axis3D.X);
    }

    private void buildModel() {
        ModelBuilder modelBuilder = new ModelBuilder();
        modelBuilder.begin();
        MeshBuilder meshBuilder = new MeshBuilder();
        meshBuilder.begin(27L, 4);
        Vector3 topLeftPosition = new Vector3(0.0f, this.halfPanelWidthInMeters, this.halfPanelHeightInMeters);
        Vector3 bottomLeftPosition = new Vector3(0.0f, this.halfPanelWidthInMeters, -this.halfPanelHeightInMeters);
        Vector3 bottomRightPosition = new Vector3(0.0f, -this.halfPanelWidthInMeters, -this.halfPanelHeightInMeters);
        Vector3 topRightPosition = new Vector3(0.0f, -this.halfPanelWidthInMeters, this.halfPanelHeightInMeters);
        Vector3 topLeftNormal = new Vector3(0.0f, 0.0f, 1.0f);
        Vector3 bottomLeftNormal = new Vector3(0.0f, 0.0f, 1.0f);
        Vector3 bottomRightNormal = new Vector3(0.0f, 0.0f, 1.0f);
        Vector3 topRightNormal = new Vector3(0.0f, 0.0f, 1.0f);
        Vector2 topLeftUV = new Vector2(0.0f, 1.0f);
        Vector2 bottomLeftUV = new Vector2(0.0f, 0.0f);
        Vector2 bottomRightUV = new Vector2(1.0f, 0.0f);
        Vector2 topRightUV = new Vector2(1.0f, 1.0f);
        meshBuilder.vertex(topLeftPosition, topLeftNormal, Color.WHITE, topLeftUV);
        meshBuilder.vertex(bottomLeftPosition, bottomLeftNormal, Color.WHITE, bottomLeftUV);
        meshBuilder.vertex(bottomRightPosition, bottomRightNormal, Color.WHITE, bottomRightUV);
        meshBuilder.vertex(topRightPosition, topRightNormal, Color.WHITE, topRightUV);
        meshBuilder.triangle((short)3, (short)0, (short)1);
        meshBuilder.triangle((short)1, (short)2, (short)3);
        Mesh mesh = meshBuilder.end();
        MeshPart meshPart = new MeshPart("xyz", mesh, 0, mesh.getNumIndices(), 4);
        Material material = new Material();
        GLFrameBuffer.FrameBufferBuilder frameBufferBuilder = new GLFrameBuffer.FrameBufferBuilder((int)this.pixelsWidth, (int)this.pixelsHeight);
        frameBufferBuilder.addBasicColorTextureAttachment(Pixmap.Format.RGBA8888);
        this.frameBuffer = frameBufferBuilder.build();
        Texture colorBufferTexture = (Texture)this.frameBuffer.getColorBufferTexture();
        material.set((Attribute)PBRTextureAttribute.createBaseColorTexture((Texture)colorBufferTexture));
        material.set((Attribute)PBRColorAttribute.createBaseColorFactor((Color)Color.WHITE));
        modelBuilder.part(meshPart, material);
        Model model = modelBuilder.end();
        this.modelInstance = new RDXModelInstance(model);
    }

    public void setMouseState(float mousePosX, float mousePosY, boolean leftMouseDown) {
        this.mousePosX = mousePosX;
        this.mousePosY = mousePosY;
        this.leftMouseDown = leftMouseDown;
    }

    public void update() {
        ImGuiTools.setCurrentContext(this.imGuiContext);
        ImGuiIO io = ImGui.getIO();
        io.setDisplaySize(this.pixelsWidth, this.pixelsHeight);
        io.setDisplayFramebufferScale(1.0f, 1.0f);
        io.setMousePos(this.mousePosX, this.mousePosY);
        io.setMouseDown(0, this.leftMouseDown);
        ImGuiPlatformIO platformIO = ImGui.getPlatformIO();
        platformIO.resizeMonitors(0);
        platformIO.pushMonitors(0.0f, 0.0f, this.pixelsWidth, this.pixelsHeight, 0.0f, 0.0f, this.pixelsWidth, this.pixelsHeight, 1.0f);
        float deltaTime = Gdx.app.getGraphics().getDeltaTime();
        io.setDeltaTime(deltaTime > 0.0f ? deltaTime : 0.016666668f);
        ImGui.newFrame();
        ImGui.pushFont((ImFont)ImGuiTools.getSmallFont());
        ImGui.setNextWindowPos((float)0.0f, (float)0.0f);
        ImGui.setNextWindowSize((float)this.pixelsWidth, (float)this.pixelsHeight);
        int windowFlags = 0;
        if (this.useTransparentBackground) {
            ImGui.pushStyleColor((int)2, (int)this.backgroundColor);
        }
        if (ImGui.begin((String)this.name, (int)windowFlags)) {
            this.renderImGuiWidgets.run();
            ImGui.end();
        }
        if (this.useTransparentBackground) {
            ImGui.popStyleColor();
        }
        ImGui.popFont();
        ImGui.render();
        this.frameBuffer.begin();
        GL41.glClearColor((float)0.3f, (float)0.3f, (float)0.3f, (float)0.0f);
        GL41.glClear((int)16384);
        this.imGuiGl3.renderDrawData(ImGui.getDrawData());
        this.frameBuffer.end();
    }

    public void calculateVRPick(RDXVRContext vrContext) {
        vrContext.getController(RobotSide.RIGHT).runIfConnected(controller -> {
            if (controller.getPickRay().getDirection().dot((Tuple3DReadOnly)this.plane.getNormal()) > 0.0) {
                this.pickIntersection.setToZero(ReferenceFrame.getWorldFrame());
                this.plane.intersectionWith((Line3DReadOnly)controller.getPickRay(), (Point3DBasics)this.pickIntersection);
                double distance = controller.getPickRay().getPoint().distance((FramePoint3DReadOnly)this.pickIntersection);
                this.pickIntersection.changeFrame(this.graphicsXRightYDownFrame);
                float scaledX = Math.round((float)this.pickIntersection.getX() * this.metersToPixels);
                float scaledY = Math.round((float)this.pickIntersection.getY() * this.metersToPixels);
                boolean xInBounds = MathTools.intervalContains((double)scaledX, (double)0.0, (double)this.pixelsWidth, (boolean)true, (boolean)false);
                boolean yInBounds = MathTools.intervalContains((double)scaledY, (double)0.0, (double)this.pixelsHeight, (boolean)true, (boolean)false);
                if (xInBounds && yInBounds) {
                    this.mousePosX = scaledX;
                    this.mousePosY = scaledY;
                    ((RDXVRPickResult)this.pickResult.get((Enum)RobotSide.RIGHT)).setPointingAtCollision(distance);
                    controller.addPickResult((RDXVRPickResult)this.pickResult.get((Enum)RobotSide.RIGHT));
                }
            }
        });
    }

    public void processVRInput(RDXVRContext vrContext) {
        vrContext.getController(RobotSide.RIGHT).runIfConnected(controller -> {
            if (controller.getSelectedPick() == this.pickResult.get((Enum)RobotSide.RIGHT)) {
                this.leftMouseDown = controller.getClickTriggerActionData().bState();
            } else {
                this.mousePosX = -20.0f;
                this.mousePosY = -20.0f;
                this.leftMouseDown = false;
            }
        });
    }

    public void setBackgroundTransparency(Color backgroundColor) {
        this.useTransparentBackground = true;
        this.backgroundColor = backgroundColor.toIntBits();
        for (Material material : this.modelInstance.materials) {
            material.set((Attribute)new BlendingAttribute(true, 770, 771, 1.0f));
        }
    }

    public void getRenderables(Array<Renderable> renderables, Pool<Renderable> pool) {
        this.modelInstance.getRenderables(renderables, pool);
    }

    public void dispose() {
        this.frameBuffer.dispose();
    }

    public void updateDesiredPose(Consumer<RigidBodyTransform> transformUpdater) {
        this.updateCurrentPose(transformUpdater);
    }

    private void updateCurrentPose(Consumer<RigidBodyTransform> transformUpdater) {
        this.transform.setToZero();
        transformUpdater.accept(this.transform);
        this.modelInstance.setTransformToWorldFrame(this.transform);
        this.plane.setToZero();
        this.plane.getNormal().set((UnitVector3DReadOnly)Axis3D.X);
        this.plane.applyTransform((Transform)this.transform);
        LibGDXTools.toLibGDX(this.transform, this.modelInstance.transform);
        this.centerXThroughZUpFrame.update();
    }

    public void setTransformToReferenceFrame(ReferenceFrame referenceFrame) {
        this.modelInstance.setTransformToReferenceFrame(referenceFrame);
    }

    public RDXModelInstance getModelInstance() {
        return this.modelInstance;
    }

    public final String getPanelName() {
        return this.name;
    }
}

