/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.rdx.imgui;

import imgui.internal.ImGui;
import imgui.type.ImInt;
import java.util.function.IntConsumer;
import java.util.function.IntSupplier;
import us.ihmc.rdx.imgui.ImGuiUniqueLabelMap;

public class ImPlotPlotPanelLayout {
    private final ImGuiUniqueLabelMap labels = new ImGuiUniqueLabelMap(this.getClass());
    private final ImInt numberOfColumns = new ImInt(1);
    private final ImInt plotHeight = new ImInt(60);
    private float plotWidth;
    private IntConsumer plotRenderer;
    private IntSupplier sizeSupplier;

    public void setPlotRenderer(IntConsumer plotRenderer, IntSupplier sizeSupplier) {
        this.plotRenderer = plotRenderer;
        this.sizeSupplier = sizeSupplier;
    }

    public void renderLayoutMenu() {
        if (ImGui.beginMenu((String)this.labels.get("Layout"))) {
            ImGui.pushItemWidth((float)100.0f);
            if (ImGui.inputInt((String)this.labels.get("Number of columns"), (ImInt)this.numberOfColumns) && this.numberOfColumns.get() < 1) {
                this.numberOfColumns.set(1);
            }
            if (ImGui.inputInt((String)this.labels.get("Plot height"), (ImInt)this.plotHeight) && this.plotHeight.get() < 10) {
                this.plotHeight.set(10);
            }
            ImGui.popItemWidth();
            ImGui.endMenu();
        }
    }

    public void renderPlots() {
        int numberOfColumnsLocal = this.numberOfColumns.get();
        this.plotWidth = ImGui.getColumnWidth() / (float)numberOfColumnsLocal;
        for (int i = 0; i < this.sizeSupplier.getAsInt(); ++i) {
            this.plotRenderer.accept(i);
            if (i % numberOfColumnsLocal == numberOfColumnsLocal - 1) continue;
            ImGui.sameLine();
        }
    }

    public int getNumberOfColumns() {
        return this.numberOfColumns.get();
    }

    public int getPlotHeight() {
        return this.plotHeight.get();
    }

    public float getPlotWidth() {
        return this.plotWidth;
    }
}

