/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.rdx.imgui;

import imgui.extension.implot.ImPlot;
import java.text.DecimalFormat;
import us.ihmc.rdx.imgui.ImPlotPlotLineDoubleSwapBuffer;
import us.ihmc.rdx.imgui.ImPlotWallTimeScrollingPlotLine;

public class ImPlotDoublePlotLine
extends ImPlotWallTimeScrollingPlotLine {
    private final DecimalFormat decimalFormatter;
    private final ImPlotPlotLineDoubleSwapBuffer doubleSwapBuffer;

    public ImPlotDoublePlotLine(String variableName) {
        this(variableName, 100, 3.0, new DecimalFormat("0.00000"));
    }

    public ImPlotDoublePlotLine(String variableName, int bufferSize, double history, DecimalFormat decimalFormatter) {
        super(variableName, "NaN", bufferSize, history);
        this.decimalFormatter = decimalFormatter;
        this.doubleSwapBuffer = new ImPlotPlotLineDoubleSwapBuffer();
        this.setSwapBuffer(this.doubleSwapBuffer);
    }

    public void addValue(double value) {
        this.doubleSwapBuffer.addValue(value);
        super.addValue(this.decimalFormatter.format(value));
    }

    @Override
    public String getValueString(int bufferIndex) {
        return this.decimalFormatter.format(this.doubleSwapBuffer.getValue(bufferIndex));
    }

    public void setLimitYMin(double minLimitY) {
        double limitY = minLimitY;
        for (int i = 0; i < this.getBufferSize(); ++i) {
            if (Double.isNaN(this.doubleSwapBuffer.getValue(i))) continue;
            limitY = Math.max(this.doubleSwapBuffer.getValue(i), limitY);
        }
        ImPlot.setNextPlotLimitsY((double)0.0, (double)limitY, (int)1);
    }
}

