/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.rdx.imgui;

import com.badlogic.gdx.graphics.Color;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import imgui.ImFont;
import imgui.ImFontAtlas;
import imgui.ImFontConfig;
import imgui.ImFontGlyphRangesBuilder;
import imgui.ImGui;
import imgui.ImGuiIO;
import imgui.ImVec2;
import imgui.internal.ImGuiContext;
import imgui.type.ImBoolean;
import imgui.type.ImDouble;
import imgui.type.ImFloat;
import imgui.type.ImInt;
import imgui.type.ImLong;
import imgui.type.ImString;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.SystemUtils;
import org.lwjgl.opengl.GL41;
import us.ihmc.commons.MathTools;
import us.ihmc.euclid.geometry.BoundingBox2D;
import us.ihmc.rdx.imgui.ImGuiPosition;
import us.ihmc.rdx.imgui.ImGuiSize;
import us.ihmc.tools.string.StringTools;

public class ImGuiTools {
    private static final AtomicInteger GLOBAL_WIDGET_INDEX = new AtomicInteger();
    public static float TAB_BAR_HEIGHT = 20.0f;
    public static final int GDX_TO_IMGUI_KEY_CODE_OFFSET = 36;
    public static final float FLOAT_MIN = -1.7014117E38f;
    public static final float FLOAT_MAX = 1.7014117E38f;
    public static final float REASONABLE_HEIGHT_FOR_A_SCROLL_AREA = 150.0f;
    public static final int MAX_STRING_SIZE_FOR_PATH = 1024;
    private static String FONT_DIRECTORY;
    public static int SMALLEST_FONT_SIZE;
    public static int DEFAULT_FONT_SIZE;
    public static int LARGEST_FONT_SIZE;
    public static int CURRENT_FONT_SIZE;
    private static Path SEGOE_UI_PATH;
    private static Path LUCIDA_CONSOLE_PATH;
    public static boolean SEGOE_EXISTS;
    public static boolean LUCIDA_EXISTS;
    public static final double DEJAVU_TO_SEGOE_SCALE = 1.2;
    public static final double SMALL_TO_MEDIUM_SCALE = 1.25;
    public static final double SMALL_TO_LARGE_SCALE = 2.4;
    private static final TIntObjectMap<ImFont> consoleFont;
    private static final TIntObjectMap<ImFont> smallFont;
    private static final TIntObjectMap<ImFont> smallBoldFont;
    private static final TIntObjectMap<ImFont> mediumFont;
    private static final TIntObjectMap<ImFont> bigFont;
    private static boolean userKeysHaveBeenMapped;
    private static int spaceKey;
    private static int deleteKey;
    private static int escapeKey;
    private static int enterKey;
    private static int keyPadEnterKey;
    private static int upArrowKey;
    private static int downArrowKey;
    private static int leftArrowKey;
    private static int rightArrowKey;
    private static ImFontAtlas fontAtlas;
    public static int BLACK;
    public static int WHITE;
    public static int GRAY;
    public static int RED;
    public static int CYAN;
    public static int PURPLE;
    public static int YELLOW;
    public static int GREEN;
    public static int DARK_RED;
    public static int DARK_PURPLE;
    public static int DARK_GREEN;
    public static int DARK_ORANGE;
    public static int LIGHT_GRAY;
    public static int LIGHT_BLUE;
    private static final ImVec2 calcTextSize;
    private static boolean printedConsoleFontError;

    public static long createContext() {
        return ImGui.createContext().ptr;
    }

    public static long createContext(ImFontAtlas fontAtlas) {
        return ImGui.createContext((ImFontAtlas)fontAtlas).ptr;
    }

    public static long getCurrentContext() {
        return ImGui.getCurrentContext().ptr;
    }

    public static void setCurrentContext(long context) {
        ImGuiContext contextHolder = ImGui.getCurrentContext();
        contextHolder.ptr = context;
        ImGui.setCurrentContext((ImGuiContext)contextHolder);
    }

    public static void parsePrimaryWindowSizeFromSettingsINI(String settingsINIAsString, ImGuiSize sizeToPack) {
        settingsINIAsString = StringTools.filterOutCRLFLineEndings((String)settingsINIAsString);
        int indexOfDockingSection = settingsINIAsString.indexOf("[Docking]");
        int indexOfDockspace = settingsINIAsString.indexOf("DockSpace", indexOfDockingSection);
        int indexOfSize = settingsINIAsString.indexOf("Size", indexOfDockspace);
        int indexOfWidth = indexOfSize + 5;
        int indexOfComma = settingsINIAsString.indexOf(",", indexOfWidth);
        int width = Integer.parseInt(settingsINIAsString.substring(indexOfWidth, indexOfComma));
        int indexOfHeight = indexOfComma + 1;
        int indexOfSpace = settingsINIAsString.indexOf(" ", indexOfComma);
        int height = Integer.parseInt(settingsINIAsString.substring(indexOfHeight, indexOfSpace));
        sizeToPack.setWidth(width);
        sizeToPack.setHeight(height);
    }

    public static void parsePrimaryWindowPositionFromSettingsINI(String settingsINIAsString, ImGuiPosition positionToPack) {
        settingsINIAsString = StringTools.filterOutCRLFLineEndings((String)settingsINIAsString);
        int indexOfDockingSection = settingsINIAsString.indexOf("[Docking]");
        int indexOfDockspace = settingsINIAsString.indexOf("DockSpace", indexOfDockingSection);
        int indexOfPosition = settingsINIAsString.indexOf("Pos", indexOfDockspace);
        int indexOfX = indexOfPosition + 4;
        int indexOfComma = settingsINIAsString.indexOf(",", indexOfX);
        int x = Integer.parseInt(settingsINIAsString.substring(indexOfX, indexOfComma));
        int indexOfY = indexOfComma + 1;
        int indexOfSpace = settingsINIAsString.indexOf(" ", indexOfComma);
        int y = Integer.parseInt(settingsINIAsString.substring(indexOfY, indexOfSpace));
        positionToPack.setX(x);
        positionToPack.setY(y);
    }

    public static void initializeColorStyle() {
        if (!Boolean.parseBoolean(System.getProperty("imgui.dark"))) {
            ImGui.styleColorsLight();
        }
    }

    public static int greenRedGradientColor(double value, double valueAtGreen, double valueAtRed) {
        double valueRange = valueAtGreen - valueAtRed;
        double greenStrength = MathTools.clamp((double)((value - valueAtRed) / valueRange), (double)0.0, (double)1.0);
        double redStrength = 1.0 - greenStrength;
        return new Color((float)redStrength, (float)greenStrength, 0.0f, 1.0f).toIntBits();
    }

    public static int nextWidgetIndex() {
        return GLOBAL_WIDGET_INDEX.getAndIncrement();
    }

    public static void glClearDarkGray() {
        GL41.glClearColor((float)0.3f, (float)0.3f, (float)0.3f, (float)1.0f);
        GL41.glClear((int)16384);
    }

    public static boolean volatileInputInt(String label, ImInt imInt) {
        return ImGuiTools.volatileInputInt(label, imInt, 1);
    }

    public static boolean volatileInputInt(String label, ImInt imInt, int step) {
        int inputTextFlags = 0;
        return ImGui.inputInt((String)label, (ImInt)imInt, (int)step, (int)100, (int)(inputTextFlags += 32));
    }

    public static boolean volatileInputLong(String label, ImLong imLong) {
        return ImGuiTools.volatileInputLong(label, imLong, 1L);
    }

    public static boolean volatileInputLong(String label, ImLong imLong, long step) {
        int inputTextFlags = 0;
        return ImGui.inputScalar((String)label, (int)5, (ImLong)imLong, (long)step, (long)100L, (String)"%d", (int)(inputTextFlags += 32));
    }

    public static boolean volatileInputFloat(String label, ImFloat imFloat) {
        int inputTextFlags = 0;
        return ImGui.inputFloat((String)label, (ImFloat)imFloat, (float)0.0f, (float)0.0f, (String)"%.3f", (int)(inputTextFlags += 32));
    }

    public static boolean volatileInputFloat(String label, ImFloat imFloat, float step) {
        int inputTextFlags = 0;
        return ImGui.inputFloat((String)label, (ImFloat)imFloat, (float)step, (float)0.0f, (String)"%.3f", (int)(inputTextFlags += 32));
    }

    public static boolean volatileInputDouble(String label, ImDouble imDouble) {
        return ImGuiTools.volatileInputDouble(label, imDouble, 0.0, 0.0);
    }

    public static boolean volatileInputDouble(String label, ImDouble imDouble, double step, double stepFast) {
        return ImGuiTools.volatileInputDouble(label, imDouble, step, stepFast, "%.6f");
    }

    public static boolean volatileInputDouble(String label, ImDouble imDouble, double step, double stepFast, String format) {
        int inputTextFlags = 0;
        return ImGui.inputDouble((String)label, (ImDouble)imDouble, (double)step, (double)stepFast, (String)format, (int)(inputTextFlags += 32));
    }

    public static boolean sliderDouble(String label, ImDouble imDouble, double minValue, double maxValue) {
        return ImGui.sliderScalar((String)label, (int)9, (ImDouble)imDouble, (double)minValue, (double)maxValue);
    }

    public static boolean sliderDouble(String label, ImDouble imDouble, double minValue, double maxValue, String format) {
        return ImGui.sliderScalar((String)label, (int)9, (ImDouble)imDouble, (double)minValue, (double)maxValue, (String)format);
    }

    public static boolean sliderDouble(String label, ImDouble imDouble, double minValue, double maxValue, String format, int imGuiSliderFlags) {
        return ImGui.sliderScalar((String)label, (int)9, (ImDouble)imDouble, (double)minValue, (double)maxValue, (String)format, (int)imGuiSliderFlags);
    }

    public static boolean sliderInt(String label, ImInt imInt, int minValue, int maxValue) {
        return ImGui.sliderScalar((String)label, (int)5, (ImInt)imInt, (int)minValue, (int)maxValue);
    }

    public static boolean sliderInt(String label, ImInt imInt, int minValue, int maxValue, String format) {
        return ImGui.sliderScalar((String)label, (int)5, (ImInt)imInt, (int)minValue, (int)maxValue, (String)format);
    }

    public static boolean sliderInt(String label, ImInt imInt, int minValue, int maxValue, String format, int imGuiSliderFlags) {
        return ImGui.sliderScalar((String)label, (int)5, (ImInt)imInt, (int)minValue, (int)maxValue, (String)format, (int)imGuiSliderFlags);
    }

    public static boolean smallCheckbox(String label, ImBoolean checked) {
        float backupFramePaddingX = ImGui.getStyle().getFramePaddingX();
        float backupFramePaddingY = ImGui.getStyle().getFramePaddingY();
        ImGui.getStyle().setFramePadding(backupFramePaddingX, 0.0f);
        boolean pressed = ImGui.checkbox((String)label, (ImBoolean)checked);
        ImGui.getStyle().setFramePadding(backupFramePaddingX, backupFramePaddingY);
        return pressed;
    }

    public static boolean smallCheckbox(String label, boolean checked) {
        float backupFramePaddingX = ImGui.getStyle().getFramePaddingX();
        float backupFramePaddingY = ImGui.getStyle().getFramePaddingY();
        ImGui.getStyle().setFramePadding(backupFramePaddingX, 0.0f);
        boolean pressed = ImGui.checkbox((String)label, (boolean)checked);
        ImGui.getStyle().setFramePadding(backupFramePaddingX, backupFramePaddingY);
        return pressed;
    }

    public static boolean inputText(String label, ImString text) {
        ImGui.inputText((String)label, (ImString)text);
        return ImGui.isItemFocused() && (ImGui.isKeyReleased((int)ImGuiTools.getEnterKey()) || ImGui.isKeyReleased((int)ImGuiTools.getKeyPadEnterKey()));
    }

    public static boolean inputTextMultiline(String widgetName, ImString imString) {
        float height = ImGuiTools.calcTextSizeY("A") * (float)Math.max(imString.get().lines().count() + 1L, 2L);
        return ImGui.inputTextMultiline((String)widgetName, (ImString)imString, (float)ImGui.getColumnWidth(), (float)height);
    }

    public static String inputTextMultiline(String widgetName, String text, ImString imString) {
        imString.set(text);
        float height = ImGuiTools.calcTextSizeY("A") * (float)Math.max(text.lines().count() + 1L, 2L);
        if (ImGui.inputTextMultiline((String)widgetName, (ImString)imString, (float)ImGui.getColumnWidth(), (float)height)) {
            return imString.get();
        }
        return null;
    }

    public static void textColored(Color color, String text) {
        ImGui.textColored((float)color.r, (float)color.g, (float)color.b, (float)color.a, (String)text);
    }

    public static void textBold(String text) {
        ImGui.pushFont((ImFont)ImGuiTools.getSmallBoldFont());
        ImGui.text((String)text);
        ImGui.popFont();
    }

    public static void previousWidgetTooltip(String tooltipText) {
        if (ImGui.isItemHovered()) {
            ImGui.setTooltip((String)tooltipText);
        }
    }

    public static void markedProgressBar(float barHeight, float barWidth, int color, double percent, double markPercent, String text) {
        float markPosition = (float)((double)barWidth * markPercent);
        float cursorScreenPosX = ImGui.getCursorScreenPosX();
        float cursorScreenPosY = ImGui.getCursorScreenPosY();
        float verticalExtents = 3.0f;
        float notchWidth = 2.0f;
        ImGui.getWindowDrawList().addRectFilled(cursorScreenPosX + markPosition, cursorScreenPosY - verticalExtents, cursorScreenPosX + markPosition + notchWidth, cursorScreenPosY + barHeight + verticalExtents, BLACK);
        ImGui.pushStyleColor((int)42, (int)color);
        ImGui.progressBar((float)((float)percent), (float)barWidth, (float)barHeight, (String)text);
        ImGui.popStyleColor();
    }

    public static void renderSliderOrProgressNotch(float x, int color) {
        ImGuiTools.renderSliderOrProgressNotch(x, color, 3.0f, 2.0f);
    }

    public static void renderSliderOrProgressNotch(float x, int color, float verticalExtents, float notchWidth) {
        float cursorScreenPosX = ImGui.getCursorScreenPosX();
        float cursorScreenPosY = ImGui.getCursorScreenPosY();
        ImGui.getWindowDrawList().addRectFilled(cursorScreenPosX + x, ImGui.getCursorScreenPosY() - verticalExtents, cursorScreenPosX + x + notchWidth, cursorScreenPosY + ImGui.getFrameHeight() + verticalExtents, color);
    }

    public static boolean isItemHovered(float itemWidth, float lineHeight) {
        float mousePosXInDesktopFrame = ImGui.getMousePosX();
        float mousePosYInDesktopFrame = ImGui.getMousePosY();
        float mousePosXInWidgetFrame = mousePosXInDesktopFrame - ImGui.getWindowPosX() + ImGui.getScrollX();
        float mousePosYInWidgetFrame = mousePosYInDesktopFrame - ImGui.getWindowPosY() + ImGui.getScrollY();
        boolean isHovered = mousePosXInWidgetFrame >= ImGui.getCursorPosX();
        isHovered &= mousePosXInWidgetFrame <= ImGui.getCursorPosX() + itemWidth + ImGui.getStyle().getFramePaddingX();
        isHovered &= mousePosYInWidgetFrame >= ImGui.getCursorPosY();
        isHovered &= mousePosYInWidgetFrame <= ImGui.getCursorPosY() + lineHeight;
        return isHovered &= ImGui.isWindowHovered();
    }

    public static boolean textWithUnderlineOnHover(String text) {
        ImGui.calcTextSize((ImVec2)calcTextSize, (String)text);
        float cursorPosXInDesktopFrame = ImGui.getCursorScreenPosX();
        float cursorPosYInDesktopFrame = ImGui.getCursorScreenPosY();
        ImGui.text((String)text);
        boolean isHovered = ImGui.isItemHovered();
        if (isHovered) {
            ImGui.getWindowDrawList().addRectFilled(cursorPosXInDesktopFrame, cursorPosYInDesktopFrame + ImGuiTools.calcTextSize.y, cursorPosXInDesktopFrame + ImGuiTools.calcTextSize.x, cursorPosYInDesktopFrame + ImGuiTools.calcTextSize.y + 1.0f, ImGui.getColorU32((int)0));
        }
        return isHovered;
    }

    public static void separatorText(String text, ImFont font) {
        ImGui.pushFont((ImFont)font);
        ImGuiTools.separatorText(text);
        ImGui.popFont();
    }

    public static void separatorText(String text) {
        float cursorScreenPosX = ImGui.getCursorScreenPosX();
        float cursorScreenPosY = ImGui.getCursorScreenPosY();
        int fontSize = ImGui.getFontSize();
        float itemSpacingX = ImGui.getStyle().getItemSpacingX();
        float lineThickness = (float)fontSize * 0.2f;
        float lineY = ImGui.getTextLineHeight() / 2.0f + lineThickness / 2.0f;
        float initialLineWidth = (float)fontSize * 1.5f;
        int separatorColor = ImGui.getColorU32((int)27);
        ImGui.getWindowDrawList().addLine(cursorScreenPosX, cursorScreenPosY + lineY, cursorScreenPosX + initialLineWidth, cursorScreenPosY + lineY, separatorColor, lineThickness);
        ImGui.setCursorPosX((float)(ImGui.getCursorPosX() + initialLineWidth + itemSpacingX));
        ImGui.text((String)text);
        ImGui.sameLine();
        float startX = ImGui.getCursorPosX() - itemSpacingX;
        float endX = ImGui.getContentRegionMaxX();
        float secondLineWidth = endX - startX;
        ImGui.getWindowDrawList().addLine(cursorScreenPosX + startX, cursorScreenPosY + lineY, cursorScreenPosX + endX, cursorScreenPosY + lineY, separatorColor, lineThickness);
        ImGui.setCursorPosX((float)(ImGui.getCursorPosX() + secondLineWidth));
        ImGui.newLine();
    }

    public static void rightAlignText(String text) {
        float windowWidth = ImGui.getWindowContentRegionMaxX();
        float textWidth = ImGuiTools.calcTextSizeX(text);
        float cursorPosX = ImGui.getCursorPosX();
        ImGui.setCursorPosX((float)(windowWidth - textWidth));
        ImGui.text((String)text);
        ImGui.setCursorPosY((float)cursorPosX);
    }

    public static float calcTextSizeX(String text) {
        ImGui.calcTextSize((ImVec2)calcTextSize, (String)text);
        return ImGuiTools.calcTextSize.x;
    }

    public static float calcTextSizeY(String text) {
        ImGui.calcTextSize((ImVec2)calcTextSize, (String)text);
        return ImGuiTools.calcTextSize.y;
    }

    public static float calcButtonWidth(String buttonText) {
        return ImGuiTools.calcTextSizeX(buttonText) + ImGui.getStyle().getFrameBorderSize() * 2.0f + ImGui.getStyle().getItemInnerSpacingX() * 2.0f;
    }

    public static ImVec2 calcRenderSize(Runnable renderMethod) {
        ImGui.pushStyleVar((int)0, (float)0.0f);
        ImGui.beginDisabled();
        ImVec2 start = ImGui.getCursorPos();
        ImGui.pushID((String)"calcRenderSize");
        renderMethod.run();
        ImGui.popID();
        ImVec2 end = ImGui.getCursorPos();
        ImGui.endDisabled();
        ImGui.popStyleVar();
        ImGui.setCursorPos((float)start.x, (float)start.y);
        return new ImVec2(end.x - start.x, end.y - start.y);
    }

    public static String uniqueLabel(String label) {
        return label + "###GlobalWidgetIndex:" + ImGuiTools.nextWidgetIndex() + ":" + label;
    }

    public static String uniqueLabel(String id, String label) {
        return label + "###" + id + ":" + label;
    }

    public static String uniqueLabel(Object thisObject, String label) {
        return label + "###" + thisObject.getClass().getName() + ":" + label;
    }

    public static void setupFonts(ImGuiIO io) {
        FONT_DIRECTORY = SystemUtils.IS_OS_WINDOWS ? System.getenv("WINDIR") + "/Fonts" : "/usr/share/fonts/TTF/";
        ImFontGlyphRangesBuilder glyphRangesBuilder = new ImFontGlyphRangesBuilder();
        glyphRangesBuilder.addRanges(ImGui.getIO().getFonts().getGlyphRangesDefault());
        glyphRangesBuilder.addRanges(new short[]{9472, 9599, 0});
        glyphRangesBuilder.addRanges(new short[]{9600, 9631, 0});
        glyphRangesBuilder.addRanges(new short[]{9632, 9727, 0});
        short[] glyphRanges = glyphRangesBuilder.buildRanges();
        SEGOE_UI_PATH = Paths.get(FONT_DIRECTORY, "segoeui.ttf");
        LUCIDA_CONSOLE_PATH = Paths.get(FONT_DIRECTORY, "lucon.ttf");
        SEGOE_EXISTS = Files.exists(SEGOE_UI_PATH, new LinkOption[0]);
        LUCIDA_EXISTS = Files.exists(LUCIDA_CONSOLE_PATH, new LinkOption[0]);
        if (!SEGOE_EXISTS) {
            ImGui.getStyle().setFramePadding(ImGui.getStyle().getFramePaddingX(), 4.5f);
        }
        for (int i = SMALLEST_FONT_SIZE; i < LARGEST_FONT_SIZE + 1; ++i) {
            int smallSize = (int)Math.round(SEGOE_EXISTS ? 1.2 * (double)i : (double)i);
            int mediumSize = (int)Math.round(SEGOE_EXISTS ? 1.5 * (double)i : 1.25 * (double)i);
            int largeSize = (int)Math.round(SEGOE_EXISTS ? 2.88 * (double)i : 2.4 * (double)i);
            smallFont.put(i, (Object)ImGuiTools.loadFont(io, smallSize, 0, true, glyphRanges));
            smallBoldFont.put(i, (Object)ImGuiTools.loadFont(io, smallSize, 32, true, glyphRanges));
            consoleFont.put(i, (Object)ImGuiTools.loadFont(io, i - 1, 0, false, glyphRanges));
            mediumFont.put(i, (Object)ImGuiTools.loadFont(io, mediumSize, 0, true, glyphRanges));
            bigFont.put(i, (Object)ImGuiTools.loadFont(io, largeSize, 0, true, glyphRanges));
        }
        fontAtlas = ImGui.getIO().getFonts();
        fontAtlas.build();
    }

    private static ImFont loadFont(ImGuiIO io, int size, int addedFlags, boolean isSans, short[] glyphRanges) {
        ImFont font;
        ImFontConfig fontConfig = new ImFontConfig();
        int fontsFlags = 0;
        fontConfig.setFontBuilderFlags((fontsFlags += 8) + addedFlags);
        if (isSans && SEGOE_EXISTS) {
            fontConfig.setName("segoeui.ttf, %dpx".formatted(size));
            font = io.getFonts().addFontFromFileTTF(SEGOE_UI_PATH.toAbsolutePath().toString(), (float)size, fontConfig);
        } else if (isSans) {
            fontConfig.setName("DejaVuSans.ttf, %dpx".formatted(size));
            font = io.getFonts().addFontFromMemoryTTF(ImGuiTools.loadFromResources("dejaVu/DejaVuSans.ttf"), (float)size, fontConfig);
        } else if (LUCIDA_EXISTS) {
            fontConfig.setName("lucon.ttf, %dpx".formatted(size));
            font = io.getFonts().addFontFromFileTTF(LUCIDA_CONSOLE_PATH.toAbsolutePath().toString(), (float)size, fontConfig, glyphRanges);
        } else {
            fontConfig.setName("dejaVu/DejaVuSansMono.ttf, %dpx".formatted(size));
            font = io.getFonts().addFontFromMemoryTTF(ImGuiTools.loadFromResources("dejaVu/DejaVuSansMono.ttf"), (float)size, fontConfig, glyphRanges);
        }
        fontConfig.destroy();
        return font;
    }

    public static ImFont getBigFont() {
        return (ImFont)bigFont.get(CURRENT_FONT_SIZE);
    }

    public static ImFont getMediumFont() {
        return (ImFont)mediumFont.get(CURRENT_FONT_SIZE);
    }

    public static ImFont getSmallFont() {
        return (ImFont)smallFont.get(CURRENT_FONT_SIZE);
    }

    public static ImFont getSmallBoldFont() {
        return (ImFont)smallBoldFont.get(CURRENT_FONT_SIZE);
    }

    public static ImFont getConsoleFont() {
        return ImGuiTools.getSmallFont();
    }

    public static ImFontAtlas getFontAtlas() {
        return fontAtlas;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static byte[] loadFromResources(String fileName) {
        try (InputStream is = Objects.requireNonNull(ImGuiTools.class.getClassLoader().getResourceAsStream(fileName));){
            byte[] byArray;
            try (ByteArrayOutputStream buffer = new ByteArrayOutputStream();){
                int nRead;
                byte[] data = new byte[16384];
                while ((nRead = is.read(data, 0, data.length)) != -1) {
                    buffer.write(data, 0, nRead);
                }
                byArray = buffer.toByteArray();
            }
            return byArray;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static BoundingBox2D windowBoundingBox() {
        BoundingBox2D box = new BoundingBox2D();
        int posX = (int)ImGui.getWindowPosX();
        int posY = (int)ImGui.getWindowPosY();
        box.setMin((double)posX, (double)posY);
        box.setMax((double)((float)posX + ImGui.getWindowSizeX()), (double)(posY + (int)ImGui.getWindowSizeX()));
        return box;
    }

    public static float getUsableWindowWidth() {
        return ImGui.getWindowWidth() - 32.0f;
    }

    private static void initializeUserMappedKeys() {
        spaceKey = ImGui.getKeyIndex((int)12);
        deleteKey = ImGui.getKeyIndex((int)10);
        escapeKey = ImGui.getKeyIndex((int)14);
        enterKey = ImGui.getKeyIndex((int)13);
        keyPadEnterKey = ImGui.getKeyIndex((int)15);
        upArrowKey = ImGui.getKeyIndex((int)3);
        downArrowKey = ImGui.getKeyIndex((int)4);
        leftArrowKey = ImGui.getKeyIndex((int)1);
        rightArrowKey = ImGui.getKeyIndex((int)2);
        userKeysHaveBeenMapped = true;
    }

    public static int getSpaceKey() {
        if (!userKeysHaveBeenMapped) {
            ImGuiTools.initializeUserMappedKeys();
        }
        return spaceKey;
    }

    public static int getDeleteKey() {
        if (!userKeysHaveBeenMapped) {
            ImGuiTools.initializeUserMappedKeys();
        }
        return deleteKey;
    }

    public static int getEscapeKey() {
        if (!userKeysHaveBeenMapped) {
            ImGuiTools.initializeUserMappedKeys();
        }
        return escapeKey;
    }

    public static int getEnterKey() {
        if (!userKeysHaveBeenMapped) {
            ImGuiTools.initializeUserMappedKeys();
        }
        return enterKey;
    }

    public static int getKeyPadEnterKey() {
        if (!userKeysHaveBeenMapped) {
            ImGuiTools.initializeUserMappedKeys();
        }
        return keyPadEnterKey;
    }

    public static int getUpArrowKey() {
        if (!userKeysHaveBeenMapped) {
            ImGuiTools.initializeUserMappedKeys();
        }
        return upArrowKey;
    }

    public static int getDownArrowKey() {
        if (!userKeysHaveBeenMapped) {
            ImGuiTools.initializeUserMappedKeys();
        }
        return downArrowKey;
    }

    public static int getLeftArrowKey() {
        if (!userKeysHaveBeenMapped) {
            ImGuiTools.initializeUserMappedKeys();
        }
        return leftArrowKey;
    }

    public static int getRightArrowKey() {
        if (!userKeysHaveBeenMapped) {
            ImGuiTools.initializeUserMappedKeys();
        }
        return rightArrowKey;
    }

    static {
        SMALLEST_FONT_SIZE = 9;
        DEFAULT_FONT_SIZE = 13;
        LARGEST_FONT_SIZE = 26;
        CURRENT_FONT_SIZE = DEFAULT_FONT_SIZE;
        consoleFont = new TIntObjectHashMap();
        smallFont = new TIntObjectHashMap();
        smallBoldFont = new TIntObjectHashMap();
        mediumFont = new TIntObjectHashMap();
        bigFont = new TIntObjectHashMap();
        userKeysHaveBeenMapped = false;
        BLACK = Color.BLACK.toIntBits();
        WHITE = Color.WHITE.toIntBits();
        GRAY = Color.GRAY.toIntBits();
        RED = Color.RED.toIntBits();
        CYAN = Color.CYAN.toIntBits();
        PURPLE = new Color(1.0f, 0.0f, 1.0f, 1.0f).toIntBits();
        YELLOW = Color.YELLOW.toIntBits();
        GREEN = Color.GREEN.toIntBits();
        DARK_RED = new Color(0.7f, 0.0f, 0.0f, 1.0f).toIntBits();
        DARK_PURPLE = new Color(0.7f, 0.0f, 0.7f, 1.0f).toIntBits();
        DARK_GREEN = new Color(0.0f, 0.7f, 0.0f, 1.0f).toIntBits();
        DARK_ORANGE = new Color(1.0f, 0.55f, 0.0f, 1.0f).toIntBits();
        LIGHT_GRAY = Color.LIGHT_GRAY.toIntBits();
        LIGHT_BLUE = new Color(0.4f, 0.4f, 0.8f, 1.0f).toIntBits();
        calcTextSize = new ImVec2();
        printedConsoleFontError = false;
    }
}

