/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.rdx.imgui;

import imgui.ImGui;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.commons.lang3.ArrayUtils;
import us.ihmc.rdx.imgui.ImGuiTools;
import us.ihmc.rdx.imgui.ImGuiUniqueLabelMap;
import us.ihmc.robotics.referenceFrames.ReferenceFrameLibrary;

public class ImGuiReferenceFrameLibraryCombo {
    private final ImGuiUniqueLabelMap labels = new ImGuiUniqueLabelMap(this.getClass());
    private final String comboName;
    private final ReferenceFrameLibrary referenceFrameLibrary;
    private final Supplier<String> currentFrameNameGetter;
    private final Consumer<String> currentFrameNameSetter;
    private final SortedSet<String> referenceFrameLibraryNames = new TreeSet<String>();
    private final SortedSet<String> selectableReferenceFrameNames = new TreeSet<String>();
    private int selectedFrameIndex = -1;
    private transient String[] selectableReferenceFrameNameArray = new String[0];

    public ImGuiReferenceFrameLibraryCombo(String comboName, ReferenceFrameLibrary referenceFrameLibrary, Supplier<String> currentFrameNameGetter, Consumer<String> currentFrameNameSetter) {
        this.comboName = comboName;
        this.referenceFrameLibrary = referenceFrameLibrary;
        this.currentFrameNameGetter = currentFrameNameGetter;
        this.currentFrameNameSetter = currentFrameNameSetter;
    }

    public void render() {
        this.referenceFrameLibraryNames.clear();
        this.referenceFrameLibrary.getAllFrameNames(this.referenceFrameLibraryNames::add);
        this.selectableReferenceFrameNames.add(this.currentFrameNameGetter.get());
        this.selectableReferenceFrameNames.addAll(this.referenceFrameLibraryNames);
        this.selectableReferenceFrameNameArray = this.selectableReferenceFrameNames.toArray(this.selectableReferenceFrameNameArray);
        this.selectedFrameIndex = ArrayUtils.indexOf((Object[])this.selectableReferenceFrameNameArray, (Object)this.currentFrameNameGetter.get());
        String selectedFrameName = this.selectableReferenceFrameNameArray[this.selectedFrameIndex];
        boolean libraryContainsSelectedFrame = this.referenceFrameLibraryNames.contains(selectedFrameName);
        boolean needToPopStyle = false;
        if (!libraryContainsSelectedFrame) {
            needToPopStyle = true;
            ImGui.pushStyleColor((int)0, (int)ImGuiTools.RED);
        }
        if (ImGui.beginCombo((String)this.labels.get(this.comboName), (String)selectedFrameName)) {
            if (needToPopStyle) {
                needToPopStyle = false;
                ImGui.popStyleColor();
            }
            for (int i = 0; i < this.selectableReferenceFrameNameArray.length; ++i) {
                String referenceFrameName = this.selectableReferenceFrameNameArray[i];
                boolean libraryContainsFrame = this.referenceFrameLibraryNames.contains(referenceFrameName);
                if (!libraryContainsFrame) {
                    ImGui.pushStyleColor((int)0, (int)ImGuiTools.RED);
                }
                if (ImGui.selectable((String)referenceFrameName, (this.selectedFrameIndex == i ? 1 : 0) != 0)) {
                    this.selectedFrameIndex = i;
                    this.currentFrameNameSetter.accept(referenceFrameName);
                }
                if (libraryContainsFrame) continue;
                ImGui.popStyleColor();
            }
            ImGui.endCombo();
        }
        if (needToPopStyle) {
            ImGui.popStyleColor();
        }
    }
}

