/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.rdx.imgui;

import imgui.ImGui;
import us.ihmc.euclid.tuple2D.Point2D32;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.rdx.imgui.ImGuiTools;

public class ImGuiHollowArrowRenderer {
    private final Point2D32 center = new Point2D32();
    private final Point2D32 arrowheadTip = new Point2D32();
    private final Point2D32 arrowheadTop = new Point2D32();
    private final Point2D32 arrowheadBottom = new Point2D32();
    private final Point2D32 baseTopLeft = new Point2D32();
    private final Point2D32 baseTopRight = new Point2D32();
    private final Point2D32 baseBottomLeft = new Point2D32();
    private final Point2D32 baseBottomRight = new Point2D32();
    private float cursorXDesktopFrame;
    private float cursorYDesktopFrame;
    private int lineColor;
    private int backgroundColor;
    private boolean isHovered = false;

    public boolean render(boolean useColor, int color, float lineHeight) {
        this.lineColor = ImGui.getColorU32((int)0);
        float fontSize = ImGui.getFontSize();
        float scale = 0.7f;
        scale *= fontSize;
        this.center.set((double)(0.7f * fontSize), (double)(0.5f * fontSize));
        if (lineHeight == ImGui.getFrameHeight()) {
            this.center.addY((double)ImGui.getStyle().getFramePaddingY());
        }
        float zero = 0.0f;
        float arrowheadHalfheight = 0.4f;
        float arrowheadHalfwidth = 0.6f;
        float baseWidth = 0.9f;
        float baseHeight = 0.35f;
        this.arrowheadTop.set((double)zero, (double)(-arrowheadHalfheight));
        this.arrowheadTip.set((double)arrowheadHalfwidth, (double)zero);
        this.arrowheadBottom.set((double)zero, (double)arrowheadHalfheight);
        this.baseTopLeft.set((double)(-baseWidth), (double)(-baseHeight / 2.0f));
        this.baseTopRight.set((double)zero, (double)(-baseHeight / 2.0f));
        this.baseBottomLeft.set((double)(-baseWidth), (double)(baseHeight / 2.0f));
        this.baseBottomRight.set((double)zero, (double)(baseHeight / 2.0f));
        this.arrowheadTop.scaleAdd((double)scale, (Tuple2DReadOnly)this.center);
        this.arrowheadTip.scaleAdd((double)scale, (Tuple2DReadOnly)this.center);
        this.arrowheadBottom.scaleAdd((double)scale, (Tuple2DReadOnly)this.center);
        this.baseTopLeft.scaleAdd((double)scale, (Tuple2DReadOnly)this.center);
        this.baseTopRight.scaleAdd((double)scale, (Tuple2DReadOnly)this.center);
        this.baseBottomLeft.scaleAdd((double)scale, (Tuple2DReadOnly)this.center);
        this.baseBottomRight.scaleAdd((double)scale, (Tuple2DReadOnly)this.center);
        float itemWidth = this.arrowheadTip.getX32() - this.baseTopLeft.getX32();
        this.isHovered = ImGuiTools.isItemHovered(itemWidth, lineHeight);
        this.cursorXDesktopFrame = ImGui.getWindowPosX() + ImGui.getCursorPosX() - ImGui.getScrollX();
        this.cursorYDesktopFrame = ImGui.getWindowPosY() + ImGui.getCursorPosY() - ImGui.getScrollY();
        if (useColor || this.isHovered) {
            this.backgroundColor = this.isHovered ? ImGui.getColorU32((int)22) : color;
            ImGui.getWindowDrawList().addTriangleFilled(this.cursorXDesktopFrame + this.arrowheadTop.getX32(), this.cursorYDesktopFrame + this.arrowheadTop.getY32(), this.cursorXDesktopFrame + this.arrowheadTip.getX32(), this.cursorYDesktopFrame + this.arrowheadTip.getY32(), this.cursorXDesktopFrame + this.arrowheadBottom.getX32(), this.cursorYDesktopFrame + this.arrowheadBottom.getY32(), this.backgroundColor);
            ImGui.getWindowDrawList().addRectFilled(this.cursorXDesktopFrame + this.baseTopLeft.getX32(), this.cursorYDesktopFrame + this.baseTopLeft.getY32(), this.cursorXDesktopFrame + this.baseBottomRight.getX32() + 1.0f, this.cursorYDesktopFrame + this.baseBottomRight.getY32() + 1.0f, this.backgroundColor);
        }
        this.drawLine(this.arrowheadTop, this.arrowheadTip);
        this.drawLine(this.arrowheadTip, this.arrowheadBottom);
        this.drawLine(this.arrowheadTop, this.baseTopRight);
        this.drawLine(this.arrowheadBottom, this.baseBottomRight);
        this.drawLine(this.baseTopRight, this.baseTopLeft);
        this.drawLine(this.baseTopLeft, this.baseBottomLeft);
        this.drawLine(this.baseBottomLeft, this.baseBottomRight);
        ImGui.setCursorPosX((float)(ImGui.getCursorPosX() + itemWidth));
        ImGui.newLine();
        return this.isHovered && ImGui.isMouseClicked((int)0);
    }

    private void drawLine(Point2D32 from, Point2D32 to) {
        ImGui.getWindowDrawList().addLine(this.cursorXDesktopFrame + from.getX32(), this.cursorYDesktopFrame + from.getY32(), this.cursorXDesktopFrame + to.getX32(), this.cursorYDesktopFrame + to.getY32(), this.lineColor);
    }

    public boolean getIsHovered() {
        return this.isHovered;
    }
}

