/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.rdx.imgui;

import imgui.ImGui;
import us.ihmc.tools.Timer;

public class ImGuiFlashingText {
    private double period = 1.0;
    private final Timer timer = new Timer();
    private boolean flashState = false;
    private final int flashColor;

    public ImGuiFlashingText(int flashColor) {
        this.flashColor = flashColor;
    }

    public void renderText(String text, boolean flashing) {
        this.update();
        if (flashing && this.flashState) {
            ImGui.pushStyleColor((int)0, (int)this.flashColor);
        }
        ImGui.text((String)text);
        if (flashing && this.flashState) {
            ImGui.popStyleColor();
        }
    }

    public int getTextColor(boolean flashing) {
        this.update();
        return flashing && this.flashState ? this.flashColor : ImGui.getColorU32((int)0);
    }

    private void update() {
        if (!this.timer.isRunning(this.period)) {
            this.timer.reset();
            this.flashState = !this.flashState;
        }
    }

    public void setPeriod(double period) {
        this.period = period;
    }
}

