/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.rdx.imgui;

import imgui.ImGui;
import us.ihmc.euclid.tuple2D.Point2D32;
import us.ihmc.rdx.imgui.ImGuiTools;

public class ImGuiExpandCollapseRenderer {
    private final Point2D32 boxTopLeft = new Point2D32();
    private final Point2D32 boxTopRight = new Point2D32();
    private final Point2D32 boxBottomLeft = new Point2D32();
    private final Point2D32 boxBottomRight = new Point2D32();
    private final Point2D32 minusLeft = new Point2D32();
    private final Point2D32 minusRight = new Point2D32();
    private final Point2D32 plusTop = new Point2D32();
    private final Point2D32 plusBottom = new Point2D32();
    private float cursorXDesktopFrame;
    private float cursorYDesktopFrame;
    private int lineColor;
    private int backgroundColor;
    private boolean isHovered = false;

    public boolean render(boolean expanded) {
        return this.render(expanded, false);
    }

    public boolean render(boolean expanded, boolean expandCollapseAll) {
        return this.render(expanded, expandCollapseAll, ImGui.getFontSize());
    }

    public boolean render(boolean expanded, boolean expandCollapseAll, float lineHeight) {
        float itemSize = (float)ImGui.getFontSize() * 0.8f;
        int boxSize = (int)Math.floor(itemSize);
        if (boxSize % 2 == 0) {
            ++boxSize;
        }
        float boxSizePixels = boxSize;
        float pixelsToCenter = (int)Math.floor((double)boxSize / 2.0);
        int minusWidth = (int)Math.floor((double)boxSizePixels * 0.6);
        if (minusWidth % 2 == 0) {
            ++minusWidth;
        }
        float minusWidthPixels = minusWidth;
        float pixelsToMinus = (boxSizePixels - minusWidthPixels) / 2.0f;
        float zero = 0.0f;
        this.boxTopLeft.set((double)zero, (double)zero);
        this.boxTopRight.set((double)boxSizePixels, (double)zero);
        this.boxBottomLeft.set((double)zero, (double)boxSizePixels);
        this.boxBottomRight.set((double)boxSizePixels, (double)boxSizePixels);
        this.minusLeft.set((double)pixelsToMinus, (double)pixelsToCenter);
        this.minusRight.set((double)(pixelsToMinus + minusWidthPixels), (double)(pixelsToCenter + 1.0f));
        this.plusTop.set((double)pixelsToCenter, (double)pixelsToMinus);
        this.plusBottom.set((double)(pixelsToCenter + 1.0f), (double)(pixelsToMinus + minusWidthPixels));
        float centering = (float)Math.floor((lineHeight - itemSize) / 2.0f);
        this.shiftAll(centering, centering);
        float itemWidth = this.boxTopRight.getX32() - this.boxTopLeft.getX32();
        this.isHovered = ImGuiTools.isItemHovered(itemWidth, lineHeight);
        this.backgroundColor = this.isHovered ? ImGui.getColorU32((int)22) : ImGui.getColorU32((int)21);
        this.cursorXDesktopFrame = ImGui.getWindowPosX() + ImGui.getCursorPosX() - ImGui.getScrollX();
        this.cursorYDesktopFrame = ImGui.getWindowPosY() + ImGui.getCursorPosY() - ImGui.getScrollY();
        if (expandCollapseAll) {
            ImGui.getWindowDrawList().addRectFilled(this.cursorXDesktopFrame + this.boxTopLeft.getX32(), this.cursorYDesktopFrame + this.boxTopLeft.getY32(), this.cursorXDesktopFrame + this.boxBottomRight.getX32(), this.cursorYDesktopFrame + this.boxBottomRight.getY32(), this.backgroundColor);
            this.lineColor = ImGui.getColorU32((int)5);
            ImGui.getWindowDrawList().addRect(this.cursorXDesktopFrame + this.boxTopLeft.getX32(), this.cursorYDesktopFrame + this.boxTopLeft.getY32(), this.cursorXDesktopFrame + this.boxBottomRight.getX32(), this.cursorYDesktopFrame + this.boxBottomRight.getY32(), this.lineColor);
            this.shiftAll(2.0f, 2.0f);
        }
        ImGui.getWindowDrawList().addRectFilled(this.cursorXDesktopFrame + this.boxTopLeft.getX32(), this.cursorYDesktopFrame + this.boxTopLeft.getY32(), this.cursorXDesktopFrame + this.boxBottomRight.getX32(), this.cursorYDesktopFrame + this.boxBottomRight.getY32(), this.backgroundColor);
        this.lineColor = ImGui.getColorU32((int)5);
        ImGui.getWindowDrawList().addRect(this.cursorXDesktopFrame + this.boxTopLeft.getX32(), this.cursorYDesktopFrame + this.boxTopLeft.getY32(), this.cursorXDesktopFrame + this.boxBottomRight.getX32(), this.cursorYDesktopFrame + this.boxBottomRight.getY32(), this.lineColor);
        this.lineColor = ImGui.getColorU32((int)0);
        this.drawLine(this.minusLeft, this.minusRight);
        if (!expanded) {
            this.drawLine(this.plusTop, this.plusBottom);
        }
        ImGui.setCursorPosX((float)(ImGui.getCursorPosX() + itemWidth));
        ImGui.newLine();
        return this.isHovered && ImGui.isMouseClicked((int)0);
    }

    private void shiftAll(float x, float y) {
        this.boxTopLeft.add((double)x, (double)y);
        this.boxTopRight.add((double)x, (double)y);
        this.boxBottomLeft.add((double)x, (double)y);
        this.boxBottomRight.add((double)x, (double)y);
        this.minusLeft.add((double)x, (double)y);
        this.minusRight.add((double)x, (double)y);
        this.plusTop.add((double)x, (double)y);
        this.plusBottom.add((double)x, (double)y);
    }

    private void drawLine(Point2D32 from, Point2D32 to) {
        ImGui.getWindowDrawList().addRectFilled(this.cursorXDesktopFrame + from.getX32(), this.cursorYDesktopFrame + from.getY32(), this.cursorXDesktopFrame + to.getX32(), this.cursorYDesktopFrame + to.getY32(), this.lineColor);
    }

    public boolean getIsHovered() {
        return this.isHovered;
    }

    public static float getPlaceholderWidth() {
        int boxSize = (int)Math.floor((float)ImGui.getFontSize() * 0.8f);
        if (boxSize % 2 == 0) {
            ++boxSize;
        }
        return (float)boxSize + ImGui.getStyle().getItemSpacingX();
    }
}

