/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.rdx.imgui;

import imgui.ImGui;
import imgui.type.ImString;
import java.nio.file.FileVisitResult;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Comparator;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.Consumer;
import java.util.function.Function;
import us.ihmc.commons.nio.BasicPathVisitor;
import us.ihmc.commons.nio.PathTools;
import us.ihmc.rdx.imgui.ImGuiTools;
import us.ihmc.rdx.imgui.ImGuiUniqueLabelMap;

public class ImGuiDirectory {
    private final ImGuiUniqueLabelMap labels = new ImGuiUniqueLabelMap(this.getClass());
    private final ImString directory = new ImString(1024);
    private final Comparator<Path> naturalOrderComparator = Comparator.comparing(path -> path.getFileName().toString());
    private final SortedSet<Path> sortedPaths = new TreeSet<Path>(this.naturalOrderComparator.reversed());
    private final SortedSet<String> sortedPathNames = new TreeSet<String>();
    private boolean indexedDirectoryOnce = false;
    private Function<String, Boolean> radioButtonSelectionCriteria;
    private final Function<PathEntry, Boolean> pathFilter;
    private final Consumer<String> pathSelectedAction;
    private transient String[] selectablePathNameArray = new String[0];
    private int selectedIndex = 0;

    public ImGuiDirectory(String initialDirectory, Function<String, Boolean> radioButtonSelectionCriteria, Function<PathEntry, Boolean> pathFilter, Consumer<String> pathSelectedAction) {
        this.pathFilter = pathFilter;
        this.directory.set(initialDirectory);
        this.radioButtonSelectionCriteria = radioButtonSelectionCriteria;
        this.pathSelectedAction = pathSelectedAction;
    }

    public ImGuiDirectory(String initialDirectory, Function<PathEntry, Boolean> pathFilter, Consumer<String> pathSelectedAction) {
        this.pathFilter = pathFilter;
        this.directory.set(initialDirectory);
        this.pathSelectedAction = pathSelectedAction;
    }

    public void renderImGuiWidgets() {
        ImGuiTools.inputText(this.labels.get("Directory"), this.directory);
        boolean reindexClicked = ImGui.button((String)this.labels.get("Reindex directory"));
        if (!this.indexedDirectoryOnce || reindexClicked) {
            this.indexedDirectoryOnce = true;
            this.reindexDirectory();
        }
        ImGui.sameLine();
        ImGui.text((String)"Available paths:");
        ImGui.beginChild((String)this.labels.get("Scroll area"), (float)ImGui.getColumnWidth(), (float)150.0f);
        for (Path sortedPath : this.sortedPaths) {
            String pathName = sortedPath.getFileName().toString();
            if (!ImGui.radioButton((String)this.labels.get(pathName), (boolean)this.radioButtonSelectionCriteria.apply(pathName))) continue;
            this.pathSelectedAction.accept(pathName);
        }
        ImGui.endChild();
    }

    public void renderImGuiWidgetsAsDropDownMenu() {
        if (!this.indexedDirectoryOnce) {
            this.indexedDirectoryOnce = true;
            this.reindexDirectory();
        }
        if (!this.sortedPathNames.isEmpty()) {
            this.selectablePathNameArray = this.sortedPathNames.toArray(this.selectablePathNameArray);
            if (ImGui.beginCombo((String)this.labels.get("Select item"), (String)this.selectablePathNameArray[this.selectedIndex])) {
                for (int i = 0; i < this.selectablePathNameArray.length; ++i) {
                    String pathName = this.selectablePathNameArray[i];
                    if (!ImGui.selectable((String)pathName, (this.selectedIndex == i ? 1 : 0) != 0)) continue;
                    this.selectedIndex = i;
                    this.pathSelectedAction.accept(pathName);
                }
                ImGui.endCombo();
            } else if (this.selectedIndex == 0) {
                String pathName = this.selectablePathNameArray[0];
                this.pathSelectedAction.accept(pathName);
            }
        }
    }

    public void reindexDirectory() {
        this.sortedPaths.clear();
        this.sortedPathNames.clear();
        PathTools.walkFlat((Path)Paths.get(this.directory.get(), new String[0]), (path, type) -> {
            if (this.pathFilter.apply(new PathEntry(path, type)).booleanValue()) {
                this.sortedPaths.add(path);
                this.sortedPathNames.add(path.getFileName().toString());
            }
            return FileVisitResult.CONTINUE;
        });
    }

    public String getDirectoryName() {
        return this.directory.get();
    }

    public boolean isEmpty() {
        if (!this.indexedDirectoryOnce) {
            this.indexedDirectoryOnce = true;
            this.reindexDirectory();
        }
        return this.sortedPaths.isEmpty();
    }

    public record PathEntry(Path path, BasicPathVisitor.PathType type) {
    }
}

