/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.rdx.imgui;

import com.google.common.io.ByteStreams;
import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.InputStream;
import java.io.PrintStream;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Hashtable;
import java.util.Objects;
import javax.imageio.ImageIO;
import org.apache.commons.lang3.SystemUtils;
import org.lwjgl.glfw.Callbacks;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWErrorCallback;
import org.lwjgl.glfw.GLFWImage;
import org.lwjgl.glfw.GLFWVidMode;
import org.lwjgl.opengl.GL;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.Struct;
import us.ihmc.commons.UnitConversions;
import us.ihmc.commons.exception.DefaultExceptionHandler;
import us.ihmc.commons.exception.ExceptionHandler;
import us.ihmc.commons.exception.ExceptionTools;
import us.ihmc.commons.thread.Throttler;
import us.ihmc.tools.io.resources.ResourceTools;
import us.ihmc.tools.processManagement.UnsignedByteTools;

public class GlfwWindowForImGui {
    private final String windowTitle;
    private final int[] windowWidthArray = new int[]{800};
    private final int[] windowHeightArray = new int[]{600};
    private long windowHandle = 0L;
    private final Throttler frameRateLimiter = new Throttler();
    private double minFramePeriod = UnitConversions.hertzToSeconds((double)240.0);

    public GlfwWindowForImGui(String windowTitle) {
        this.windowTitle = windowTitle;
    }

    public void create() {
        GLFWErrorCallback.createPrint((PrintStream)System.err).set();
        if (!GLFW.glfwInit()) {
            throw new IllegalStateException("Unable to initialize GLFW");
        }
        long monitor = 0L;
        long share = 0L;
        this.windowHandle = GLFW.glfwCreateWindow((int)this.windowWidthArray[0], (int)this.windowHeightArray[0], (CharSequence)this.windowTitle, (long)monitor, (long)share);
        if (this.windowHandle == 0L) {
            throw new RuntimeException("Failed to create the GLFW window");
        }
        try (MemoryStack stack = MemoryStack.stackPush();){
            IntBuffer pWidth = stack.mallocInt(1);
            IntBuffer pHeight = stack.mallocInt(1);
            GLFW.glfwGetWindowSize((long)this.windowHandle, (IntBuffer)pWidth, (IntBuffer)pHeight);
            GLFWVidMode vidmode = Objects.requireNonNull(GLFW.glfwGetVideoMode((long)GLFW.glfwGetPrimaryMonitor()));
            GLFW.glfwSetWindowPos((long)this.windowHandle, (int)((vidmode.width() - pWidth.get(0)) / 2), (int)((vidmode.height() - pHeight.get(0)) / 2));
        }
        GLFW.glfwMakeContextCurrent((long)this.windowHandle);
        this.setVSyncEnabled(true);
        GLFW.glfwShowWindow((long)this.windowHandle);
        GL.createCapabilities();
    }

    public void launch(Runnable render) {
        while (!GLFW.glfwWindowShouldClose((long)this.windowHandle)) {
            render.run();
            this.frameRateLimiter.waitAndRun(this.minFramePeriod);
            GLFW.glfwSwapBuffers((long)this.windowHandle);
            GLFW.glfwPollEvents();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setIcon(String ... imagePaths) {
        if (SystemUtils.IS_OS_MAC) {
            return;
        }
        GLFWImage.Buffer glfwImageBuffer = GLFWImage.malloc((int)imagePaths.length);
        for (String imagePath : imagePaths) {
            InputStream imageInputStream = ResourceTools.openStreamSystem((Path)Paths.get(imagePath, new String[0]));
            BufferedImage bufferedImage = (BufferedImage)ExceptionTools.handle(() -> ImageIO.read(imageInputStream), (ExceptionHandler)DefaultExceptionHandler.MESSAGE_AND_STACKTRACE);
            int width = bufferedImage.getWidth();
            int height = bufferedImage.getHeight();
            int[] pixels = new int[width * height];
            bufferedImage.getRGB(0, 0, width, height, pixels, 0, width);
            byte[] manAssArr = new byte[width * height * 4];
            int byteArrIndex = 0;
            for (int i = 0; i < pixels.length; ++i) {
                manAssArr[byteArrIndex] = UnsignedByteTools.fromInt((int)(pixels[i] & 0xFF));
                manAssArr[++byteArrIndex] = UnsignedByteTools.fromInt((int)((pixels[i] & 0xFF00) >>> 8));
                manAssArr[++byteArrIndex] = UnsignedByteTools.fromInt((int)((pixels[i] & 0xFF0000) >>> 16));
                manAssArr[++byteArrIndex] = UnsignedByteTools.fromInt((int)((pixels[i] & 0xFF000000) >>> 24));
                ++byteArrIndex;
            }
            boolean hasAlpha = true;
            boolean isAlphaPremultiplied = false;
            ComponentColorModel colorModel = new ComponentColorModel(ColorSpace.getInstance(1000), hasAlpha, isAlphaPremultiplied, 3, 0);
            int scanlineStride = width * 4;
            int pixelStride = 4;
            int[] bandOffsets = new int[]{0, 1, 2, 3};
            Point location = null;
            WritableRaster raster = Raster.createInterleavedRaster(0, width, height, scanlineStride, pixelStride, bandOffsets, location);
            Hashtable<?, ?> properties = null;
            BufferedImage imageToo = new BufferedImage(colorModel, raster, colorModel.isAlphaPremultiplied(), properties);
            byte[] rgbaTwo = ((DataBufferByte)raster.getDataBuffer()).getData();
            Graphics2D g = imageToo.createGraphics();
            try {
                g.setComposite(AlphaComposite.Src);
                g.drawImage((Image)bufferedImage, 0, 0, null);
            }
            finally {
                g.dispose();
            }
            InputStream imageInputStream2 = ResourceTools.openStreamSystem((Path)Paths.get(imagePath, new String[0]));
            byte[] byteArray = (byte[])ExceptionTools.handle(() -> ByteStreams.toByteArray((InputStream)imageInputStream2), (ExceptionHandler)DefaultExceptionHandler.MESSAGE_AND_STACKTRACE);
            ByteBuffer byteBuffer = ByteBuffer.allocateDirect(rgbaTwo.length);
            byteBuffer.put(rgbaTwo);
            ByteBuffer byteBuffer2 = ByteBuffer.allocateDirect(width * height * 4);
            byteBuffer2.put(manAssArr);
            GLFWImage icon = GLFWImage.malloc();
            icon.set(width, height, byteBuffer2);
            glfwImageBuffer.put((Struct)icon);
            icon.free();
        }
        glfwImageBuffer.position(0);
        GLFW.glfwSetWindowIcon((long)this.windowHandle, (GLFWImage.Buffer)glfwImageBuffer);
        glfwImageBuffer.free();
    }

    public void dispose() {
        Callbacks.glfwFreeCallbacks((long)this.windowHandle);
        GLFW.glfwDestroyWindow((long)this.windowHandle);
        GLFW.glfwTerminate();
        Objects.requireNonNull(GLFW.glfwSetErrorCallback(null)).free();
    }

    public void setVSyncEnabled(boolean vSyncEnabled) {
        GLFW.glfwSwapInterval((int)(vSyncEnabled ? 1 : 0));
    }

    public void setMaxFrameRate(double maxFrameRate) {
        this.minFramePeriod = UnitConversions.hertzToSeconds((double)maxFrameRate);
    }

    public long getWindowHandle() {
        return this.windowHandle;
    }

    public void setWindowSize(int width, int height) {
        this.windowWidthArray[0] = width;
        this.windowHeightArray[0] = height;
        if (this.windowHandle != 0L) {
            GLFW.glfwSetWindowSize((long)this.windowHandle, (int)width, (int)height);
        }
    }

    public int getWindowWidth() {
        if (this.windowHandle != 0L) {
            GLFW.glfwGetWindowSize((long)this.windowHandle, (int[])this.windowWidthArray, (int[])this.windowHeightArray);
        }
        return this.windowWidthArray[0];
    }

    public int getWindowHeight() {
        if (this.windowHandle != 0L) {
            GLFW.glfwGetWindowSize((long)this.windowHandle, (int[])this.windowWidthArray, (int[])this.windowHeightArray);
        }
        return this.windowHeightArray[0];
    }

    public String getWindowTitle() {
        return this.windowTitle;
    }
}

