/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.rdx;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import us.ihmc.log.LogTools;
import us.ihmc.rdx.imgui.ImGuiTools;
import us.ihmc.tools.IHMCCommonPaths;

public class RDXSettings {
    private static int deleteRetries;
    private static final Path RDX_SETTINGS_PATH;
    private boolean plotFrameRate = false;
    private boolean vsync = false;
    private boolean lockPanelsWithinWindows = true;
    private int foregroundFPSLimit = 240;
    private int libGDXLogLevel = 2;
    private int fontSize = ImGuiTools.DEFAULT_FONT_SIZE;
    private String themeName = "LIGHT";
    private float view3DBackgroundShade = 0.5019608f;

    public boolean plotFrameRateEnabled() {
        return this.plotFrameRate;
    }

    public void setPlotFrameRate(boolean plotFrameRate) {
        this.plotFrameRate = plotFrameRate;
        this.saveAsync();
    }

    public boolean vsyncEnabled() {
        return this.vsync;
    }

    public void setVsync(boolean vsync) {
        this.vsync = vsync;
        this.saveAsync();
    }

    public boolean getlockPanelsWithinWindows() {
        return this.lockPanelsWithinWindows;
    }

    public void setlockPanelsWithinWindows(boolean lockPanelsWithinWindows) {
        this.lockPanelsWithinWindows = lockPanelsWithinWindows;
        this.saveAsync();
    }

    public int getForegroundFPSLimit() {
        return this.foregroundFPSLimit;
    }

    public void setForegroundFPSLimit(int foregroundFPSLimit) {
        this.foregroundFPSLimit = foregroundFPSLimit;
        this.saveAsync();
    }

    public int getLibGDXLogLevel() {
        return this.libGDXLogLevel;
    }

    public void setLibGDXLogLevel(int libGDXLogLevel) {
        this.libGDXLogLevel = libGDXLogLevel;
        this.saveAsync();
    }

    public int getFontSize() {
        return this.fontSize;
    }

    public void setFontSize(int fontSize) {
        this.fontSize = fontSize;
        this.saveAsync();
    }

    public String getThemeName() {
        return this.themeName;
    }

    public void setThemeName(String themeName) {
        this.themeName = themeName;
        this.saveAsync();
    }

    public float getView3DBackgroundShade() {
        return this.view3DBackgroundShade;
    }

    public void setView3DBackgroundShade(float view3DBackgroundShade) {
        this.view3DBackgroundShade = view3DBackgroundShade;
        this.saveAsync();
    }

    public void save() throws IOException {
        File file = RDX_SETTINGS_PATH.toFile();
        file.getParentFile().mkdirs();
        if (!file.exists()) {
            file.createNewFile();
        }
        Properties properties = new Properties();
        properties.setProperty("plotFrameRate", String.valueOf(this.plotFrameRate));
        properties.setProperty("vsync", String.valueOf(this.vsync));
        properties.setProperty("lockPanelsWithinWindows", String.valueOf(this.lockPanelsWithinWindows));
        properties.setProperty("foregroundFPSLimit", String.valueOf(this.foregroundFPSLimit));
        properties.setProperty("libgdxLogLevel", String.valueOf(this.libGDXLogLevel));
        properties.setProperty("fontSize", String.valueOf(this.fontSize));
        properties.setProperty("themeName", String.valueOf(this.themeName));
        properties.setProperty("view3DBackgroundShade", String.valueOf(this.view3DBackgroundShade));
        try (FileOutputStream output = new FileOutputStream(file);){
            properties.store(output, null);
        }
    }

    public void saveAsync() {
        CompletableFuture.runAsync(() -> {
            try {
                this.save();
            }
            catch (IOException e) {
                LogTools.info((Object)e);
            }
        });
    }

    public void load() throws IOException {
        File file = RDX_SETTINGS_PATH.toFile();
        if (!file.exists()) {
            this.save();
        }
        Properties properties = new Properties();
        try (FileInputStream input = new FileInputStream(file);){
            properties.load(input);
        }
        try {
            this.plotFrameRate = Boolean.parseBoolean(properties.getProperty("plotFrameRate"));
            this.vsync = Boolean.parseBoolean(properties.getProperty("vsync"));
            this.lockPanelsWithinWindows = Boolean.parseBoolean(properties.getProperty("lockPanelsWithinWindows", "true"));
            this.foregroundFPSLimit = Integer.parseInt(properties.getProperty("foregroundFPSLimit"));
            this.libGDXLogLevel = Integer.parseInt(properties.getProperty("libgdxLogLevel"));
            this.fontSize = Integer.parseInt(properties.getProperty("fontSize"));
            this.themeName = properties.getProperty("themeName");
            this.view3DBackgroundShade = Float.parseFloat(properties.getProperty("view3DBackgroundShade"));
        }
        catch (Exception e) {
            if (deleteRetries++ > 20) {
                return;
            }
            file.delete();
            this.save();
        }
    }

    private static void deleteOldThemeFile() {
        File oldThemeFile = new File(IHMCCommonPaths.DOT_IHMC_DIRECTORY.toFile(), "themePreference.ini");
        if (oldThemeFile.exists()) {
            LogTools.info((String)("Deleting old theme file: " + oldThemeFile.getAbsolutePath()));
            oldThemeFile.delete();
        }
    }

    static {
        RDXSettings.deleteOldThemeFile();
        deleteRetries = 0;
        RDX_SETTINGS_PATH = IHMCCommonPaths.DOT_IHMC_DIRECTORY.resolve("RDXSettings.ini");
    }
}

