/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.rdx;

import com.badlogic.gdx.graphics.VertexAttribute;
import com.badlogic.gdx.graphics.VertexAttributes;
import java.nio.FloatBuffer;
import java.util.List;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.rdx.AbstractRDXPointCloudRenderer;
import us.ihmc.rdx.shader.RDXShader;

public class RDXPointCloudRenderer
extends AbstractRDXPointCloudRenderer {
    private final VertexAttributes vertexAttributes = new VertexAttributes(new VertexAttribute[]{VertexAttribute.Position()});

    public void updateMesh(List<? extends Point3DReadOnly> points) {
        FloatBuffer verticesBuffer = this.renderable.meshPart.mesh.getVerticesBuffer(true);
        int pointCloudSize = points.size();
        if (this.renderable.meshPart.size != pointCloudSize) {
            this.renderable.meshPart.size = pointCloudSize;
            verticesBuffer.limit(this.floatsPerVertex * pointCloudSize);
        }
        ((IntStream)IntStream.range(0, points.size()).parallel().unordered()).forEach(i -> {
            int offset = i * this.floatsPerVertex;
            verticesBuffer.put(offset, ((Point3DReadOnly)points.get(i)).getX32());
            verticesBuffer.put(offset + 1, ((Point3DReadOnly)points.get(i)).getY32());
            verticesBuffer.put(offset + 2, ((Point3DReadOnly)points.get(i)).getZ32());
        });
    }

    public void updateMesh(Point3DReadOnly[] points) {
        FloatBuffer verticesBuffer = this.renderable.meshPart.mesh.getVerticesBuffer(true);
        int pointCloudSize = points.length;
        if (this.renderable.meshPart.size != pointCloudSize) {
            this.renderable.meshPart.size = pointCloudSize;
            verticesBuffer.limit(this.floatsPerVertex * pointCloudSize);
        }
        ((IntStream)IntStream.range(0, points.length).parallel().unordered()).forEach(i -> {
            int offset = i * this.floatsPerVertex;
            verticesBuffer.put(offset, points[i].getX32());
            verticesBuffer.put(offset + 1, points[i].getY32());
            verticesBuffer.put(offset + 2, points[i].getZ32());
        });
    }

    @Override
    public AbstractRDXPointCloudRenderer.ColoringMethod[] getAvailableColoringMethods() {
        return new AbstractRDXPointCloudRenderer.ColoringMethod[]{AbstractRDXPointCloudRenderer.ColoringMethod.DEFAULT, AbstractRDXPointCloudRenderer.ColoringMethod.GRADIENT_WORLD_Z};
    }

    @Override
    @Nullable
    protected String[] getFragmentShaderFlags() {
        return null;
    }

    @Override
    @Nullable
    protected String[] getVertexShaderFlags() {
        return null;
    }

    @Override
    protected VertexAttributes getVertexAttributes() {
        return this.vertexAttributes;
    }

    @Override
    protected void registerUniforms(RDXShader rdxShader) {
        this.registerGeneralUniforms(rdxShader);
    }
}

