/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.rdx;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Mesh;
import com.badlogic.gdx.graphics.VertexAttributes;
import com.badlogic.gdx.graphics.g3d.Attribute;
import com.badlogic.gdx.graphics.g3d.Material;
import com.badlogic.gdx.graphics.g3d.Renderable;
import com.badlogic.gdx.graphics.g3d.RenderableProvider;
import com.badlogic.gdx.graphics.g3d.shaders.DefaultShader;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Pool;
import javax.annotation.Nullable;
import net.mgsx.gltf.scene3d.attributes.PBRColorAttribute;
import org.lwjgl.opengl.GL41;
import us.ihmc.rdx.shader.RDXShader;
import us.ihmc.rdx.shader.RDXUniform;

public abstract class AbstractRDXPointCloudRenderer
implements RenderableProvider {
    protected Renderable renderable;
    protected int floatsPerVertex = 0;
    private float pointScale = 0.003f;
    private final Color defaultPointColor = new Color(Color.WHITE);
    private ColoringMethod coloringMethod = ColoringMethod.DEFAULT;

    public void create(int maxPoints) {
        GL41.glEnable((int)34370);
        this.renderable = new Renderable();
        this.renderable.meshPart.primitiveType = 0;
        this.renderable.meshPart.offset = 0;
        this.renderable.material = new Material(new Attribute[]{PBRColorAttribute.createBaseColorFactor((Color)Color.WHITE)});
        VertexAttributes vertexAttributes = this.getVertexAttributes();
        this.floatsPerVertex = vertexAttributes.vertexSize / 4;
        boolean isStatic = false;
        int maxIndices = 0;
        this.renderable.meshPart.mesh = new Mesh(isStatic, maxPoints, maxIndices, vertexAttributes);
        RDXShader shader = new RDXShader(this.getClass());
        shader.create(this.getVertexShaderFlags(), this.getFragmentShaderFlags());
        this.registerUniforms(shader);
        shader.init(this.renderable);
        this.renderable.shader = shader.getBaseShader();
    }

    public void getRenderables(Array<Renderable> renderables, Pool<Renderable> pool) {
        if (this.renderable != null) {
            renderables.add((Object)this.renderable);
        }
    }

    public void dispose() {
        if (this.renderable.meshPart.mesh != null) {
            this.renderable.meshPart.mesh.dispose();
        }
    }

    public void setPointScale(float scale) {
        this.pointScale = scale;
    }

    public void setDefaultPointColor(float r, float g, float b, float a) {
        this.defaultPointColor.set(r, g, b, a);
    }

    public void setDefaultPointColor(Color color) {
        this.defaultPointColor.set(color);
    }

    public void setColoringMethod(ColoringMethod method) {
        this.coloringMethod = method;
    }

    public abstract ColoringMethod[] getAvailableColoringMethods();

    @Nullable
    protected abstract String[] getFragmentShaderFlags();

    @Nullable
    protected abstract String[] getVertexShaderFlags();

    protected abstract VertexAttributes getVertexAttributes();

    protected abstract void registerUniforms(RDXShader var1);

    protected void registerGeneralUniforms(RDXShader rdxShader) {
        rdxShader.getBaseShader().register(DefaultShader.Inputs.viewTrans, DefaultShader.Setters.viewTrans);
        rdxShader.getBaseShader().register(DefaultShader.Inputs.projTrans, DefaultShader.Setters.projTrans);
        RDXUniform screenWidthUniform = RDXUniform.createGlobalUniform("u_screenWidth", (shader, inputID, renderable, combinedAttributes) -> shader.set(inputID, shader.camera.viewportWidth));
        rdxShader.registerUniform(screenWidthUniform);
        RDXUniform pointScaleUniform = RDXUniform.createGlobalUniform("u_pointScale", (shader, inputID, renderable, combinedAttributes) -> shader.set(inputID, this.pointScale));
        rdxShader.registerUniform(pointScaleUniform);
        RDXUniform defaultPointColorUniform = RDXUniform.createGlobalUniform("u_defaultPointColor", (shader, inputID, renderable, combinedAttributes) -> shader.set(inputID, this.defaultPointColor));
        rdxShader.registerUniform(defaultPointColorUniform);
        RDXUniform coloringMethodUniform = RDXUniform.createGlobalUniform("u_coloringMethod", (shader, inputID, renderable, combinedAttributes) -> shader.set(inputID, this.coloringMethod.ordinal()));
        rdxShader.registerUniform(coloringMethodUniform);
    }

    public static enum ColoringMethod {
        DEFAULT,
        GRADIENT_WORLD_Z,
        GRADIENT_SENSOR_X,
        COLOR_IMAGE;

    }
}

