/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.tests.g3d.shadows.utils;

import com.badlogic.gdx.graphics.g3d.environment.BaseLight;
import com.badlogic.gdx.tests.g3d.shadows.utils.ShadowMapAllocator;
import com.badlogic.gdx.utils.GdxRuntimeException;

public class FixedShadowMapAllocator
implements ShadowMapAllocator {
    public static final int QUALITY_MIN = 1024;
    public static final int QUALITY_MED = 2048;
    public static final int QUALITY_MAX = 4096;
    public static final int QUANTITY_MAP_MIN = 4;
    public static final int QUANTITY_MAP_MED = 16;
    public static final int QUANTITY_MAP_MAX = 32;
    protected final int size;
    protected final int mapQuantity;
    protected int currentMap;
    protected ShadowMapAllocator.ShadowMapRegion result = new ShadowMapAllocator.ShadowMapRegion();
    protected boolean allocating = false;

    public FixedShadowMapAllocator(int size, int nbMap) {
        this.size = size;
        this.mapQuantity = nbMap;
    }

    @Override
    public int getWidth() {
        return this.size;
    }

    @Override
    public int getHeight() {
        return this.size;
    }

    public int getMapQuantity() {
        return this.mapQuantity;
    }

    @Override
    public void begin() {
        if (this.allocating) {
            throw new GdxRuntimeException("Allocator must end before begin");
        }
        this.allocating = true;
        this.currentMap = 0;
    }

    @Override
    public void end() {
        if (!this.allocating) {
            throw new GdxRuntimeException("Allocator must begin before end");
        }
        this.allocating = false;
    }

    @Override
    public ShadowMapAllocator.ShadowMapRegion nextResult(BaseLight light) {
        if (!this.allocating) {
            throw new GdxRuntimeException("Allocator must begin before call");
        }
        int nbOnLine = (int)Math.round(Math.sqrt(this.mapQuantity));
        int i = this.currentMap % nbOnLine;
        int j = this.currentMap / nbOnLine;
        int sizeMap = this.size / nbOnLine;
        this.result.x = i * sizeMap;
        this.result.y = j * sizeMap;
        this.result.width = sizeMap;
        this.result.height = sizeMap;
        if (this.result.x >= this.size || this.result.y >= this.size) {
            return null;
        }
        ++this.currentMap;
        return this.result;
    }
}

