/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.rdx.vr;

import com.badlogic.gdx.graphics.g3d.Model;
import com.badlogic.gdx.graphics.g3d.ModelInstance;
import com.badlogic.gdx.utils.BufferUtils;
import java.nio.IntBuffer;
import org.lwjgl.openvr.HmdMatrix34;
import org.lwjgl.openvr.TrackedDevicePose;
import org.lwjgl.openvr.VRSystem;
import us.ihmc.euclid.exceptions.NotARotationMatrixException;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.tools.ReferenceFrameTools;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.log.LogTools;
import us.ihmc.rdx.tools.LibGDXTools;
import us.ihmc.rdx.tools.RDXModelLoader;
import us.ihmc.rdx.vr.RDXVRModelLoader;

public abstract class RDXVRTrackedDevice {
    private int deviceIndex;
    private boolean isConnected;
    private final IntBuffer errorCode = BufferUtils.newIntBuffer((int)1);
    private final RigidBodyTransform deviceToPlayAreaTransform = new RigidBodyTransform();
    private final ReferenceFrame deviceYUpZBackFrame;
    private final RigidBodyTransform tempOpenVRToWorldTransform = new RigidBodyTransform();
    private ModelInstance modelInstance = null;

    public RDXVRTrackedDevice(ReferenceFrame vrPlayAreaYUpZBackFrame) {
        this.deviceYUpZBackFrame = ReferenceFrameTools.constructFrameWithChangingTransformToParent((String)("device" + this.deviceIndex + "YUpZBackFrame"), (ReferenceFrame)vrPlayAreaYUpZBackFrame, (RigidBodyTransformReadOnly)this.deviceToPlayAreaTransform);
    }

    protected void update(TrackedDevicePose.Buffer trackedDevicePoses) {
        if (this.isConnected) {
            HmdMatrix34 openVRRigidBodyTransform = ((TrackedDevicePose)trackedDevicePoses.get(this.deviceIndex)).mDeviceToAbsoluteTracking();
            LibGDXTools.toEuclidUnsafe(openVRRigidBodyTransform, this.deviceToPlayAreaTransform);
            boolean matrixInvalid = this.deviceToPlayAreaTransform.containsNaN();
            if (!matrixInvalid) {
                try {
                    this.deviceToPlayAreaTransform.getRotation().normalize();
                }
                catch (NotARotationMatrixException notARotationMatrixException) {
                    matrixInvalid = true;
                    LogTools.error((String)(this.deviceToPlayAreaTransform.getRotation().containsNaN() ? "Not a rotation matrix: Normalization failed. Result contains NaN." : notARotationMatrixException.getMessage()));
                }
            }
            if (matrixInvalid) {
                this.isConnected = false;
            } else {
                this.deviceYUpZBackFrame.update();
                if (this.modelInstance == null) {
                    String renderModelName = VRSystem.VRSystem_GetStringTrackedDeviceProperty((int)this.deviceIndex, (int)1003, (IntBuffer)this.errorCode);
                    Model model = new Model();
                    if (renderModelName.contains("controller")) {
                        if (renderModelName.contains("focus3")) {
                            Object modelFile = "vr/controllers/vive_focus3/";
                            if (renderModelName.contains("left")) {
                                modelFile = (String)modelFile + "Focus3_controller_left.g3dj";
                            } else if (renderModelName.contains("right")) {
                                modelFile = (String)modelFile + "Focus3_controller_right.g3dj";
                            }
                            model = RDXModelLoader.load((String)modelFile);
                        } else if (renderModelName.contains("index")) {
                            Object modelFile = "vr/controllers/index/";
                            if (renderModelName.contains("left")) {
                                modelFile = (String)modelFile + "valve_controller_knu_1_0_left.g3dj";
                            } else if (renderModelName.contains("right")) {
                                modelFile = (String)modelFile + "valve_controller_knu_1_0_right.g3dj";
                            }
                            model = RDXModelLoader.load((String)modelFile);
                        }
                    } else {
                        model = RDXVRModelLoader.loadRenderModel(renderModelName);
                    }
                    this.modelInstance = model != null ? new ModelInstance(model) : null;
                }
                this.deviceYUpZBackFrame.getTransformToDesiredFrame(this.tempOpenVRToWorldTransform, ReferenceFrame.getWorldFrame());
                LibGDXTools.toLibGDX(this.tempOpenVRToWorldTransform, this.modelInstance.transform);
            }
        }
    }

    public ReferenceFrame getDeviceYUpZBackFrame() {
        return this.deviceYUpZBackFrame;
    }

    protected void setDeviceIndex(int deviceIndex) {
        this.deviceIndex = deviceIndex;
    }

    protected void setConnected(boolean isConnected) {
        this.isConnected = isConnected;
    }

    public ModelInstance getModelInstance() {
        return this.modelInstance;
    }

    public boolean isConnected() {
        return this.isConnected;
    }

    public int getDeviceIndex() {
        return this.deviceIndex;
    }
}

