/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.rdx.vr;

import com.badlogic.gdx.graphics.g3d.Renderable;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Pool;
import imgui.internal.ImGui;
import imgui.type.ImBoolean;
import us.ihmc.commons.exception.DefaultExceptionHandler;
import us.ihmc.commons.exception.ExceptionHandler;
import us.ihmc.commons.thread.Notification;
import us.ihmc.commons.thread.ThreadTools;
import us.ihmc.commons.time.Stopwatch;
import us.ihmc.log.LogTools;
import us.ihmc.rdx.imgui.ImGuiPlot;
import us.ihmc.rdx.imgui.ImGuiUniqueLabelMap;
import us.ihmc.rdx.input.ImGui3DViewInput;
import us.ihmc.rdx.sceneManager.RDX3DScene;
import us.ihmc.rdx.ui.RDXBaseUI;
import us.ihmc.rdx.ui.gizmo.RDXPose3DGizmo;
import us.ihmc.rdx.vr.RDXVRContext;
import us.ihmc.rdx.vr.RDXVRController;
import us.ihmc.rdx.vr.RDXVRTeleporter;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.tools.thread.MissingThreadTools;
import us.ihmc.tools.time.FrequencyCalculator;

public class RDXVRManager {
    private final RDXVRContext context = new RDXVRContext();
    private Notification contextCreatedNotification;
    private boolean contextInitialized = false;
    private boolean initializing = false;
    private boolean skipHeadset = false;
    private final Object syncObject = new Object();
    private final ImBoolean showScenePoseGizmo = new ImBoolean(false);
    private RDXPose3DGizmo scenePoseGizmo;
    private final ImGuiUniqueLabelMap labels = new ImGuiUniqueLabelMap(this.getClass());
    private final ImBoolean vrEnabled = new ImBoolean(false);
    private final Notification posesReady = new Notification();
    private volatile boolean waitingOnPoses = false;
    private ImGuiPlot vrFPSPlot = new ImGuiPlot(this.labels.get("VR FPS Hz"), 1000, 300, 50);
    private FrequencyCalculator vrFPSCalculator = new FrequencyCalculator();
    private ImGuiPlot waitGetPosesPlot = new ImGuiPlot(this.labels.get("Wait Get Poses Hz"), 1000, 300, 50);
    private ImGuiPlot waitGetToRenderDelayPlot = new ImGuiPlot(this.labels.get("WaitGetToRender Delay"), 1000, 300, 50);
    private final Stopwatch waitGetToRenderStopwatch = new Stopwatch();
    private volatile double waitGetToRenderDuration = Double.NaN;
    private FrequencyCalculator waitGetPosesFrequencyCalculator = new FrequencyCalculator();
    private ImGuiPlot pollEventsPlot = new ImGuiPlot(this.labels.get("Poll Events Hz"), 1000, 300, 50);
    private FrequencyCalculator pollEventsFrequencyCalculator = new FrequencyCalculator();
    private ImGuiPlot contextInitializedPlot = new ImGuiPlot(this.labels.get("contextInitialized"), 1000, 300, 50);
    private ImGuiPlot initSystemCountPlot = new ImGuiPlot(this.labels.get("initSystemCount"), 1000, 300, 50);
    private volatile int initSystemCount = 0;
    private ImGuiPlot setupEyesCountPlot = new ImGuiPlot(this.labels.get("setupEyesCount"), 1000, 300, 50);
    private volatile int setupEyesCount = 0;
    private final Notification waitOnPosesNotification = new Notification();
    private volatile boolean waitGetPosesThreadRunning = false;
    private final RDXVRTeleporter teleporter = new RDXVRTeleporter();

    public void create() {
        this.teleporter.create(this.context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pollEventsAndRender(RDXBaseUI baseUI, RDX3DScene scene) {
        boolean posesReady = this.pollEvents(baseUI);
        if (posesReady && this.isVRReady()) {
            this.skipHeadset = true;
            this.vrFPSCalculator.ping();
            this.waitGetToRenderDuration = this.waitGetToRenderStopwatch.totalElapsed();
            Object object = this.syncObject;
            synchronized (object) {
                this.context.renderEyes(scene);
            }
            this.skipHeadset = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean pollEvents(RDXBaseUI baseUI) {
        boolean posesReadyThisFrame = false;
        if (this.vrEnabled.get()) {
            Object object;
            if (!this.initializing && this.contextCreatedNotification == null) {
                this.initializing = true;
                this.contextCreatedNotification = new Notification();
                MissingThreadTools.startAsDaemon((String)(this.getClass().getSimpleName() + "-initSystem"), (ExceptionHandler)DefaultExceptionHandler.MESSAGE_AND_STACKTRACE, () -> {
                    ++this.initSystemCount;
                    Object object = this.syncObject;
                    synchronized (object) {
                        this.context.initSystem();
                    }
                    this.contextCreatedNotification.set();
                });
            }
            if (this.contextCreatedNotification != null && this.contextCreatedNotification.poll()) {
                this.initializing = false;
                ++this.setupEyesCount;
                object = this.syncObject;
                synchronized (object) {
                    this.context.setupEyes();
                }
                if (!Boolean.parseBoolean(System.getProperty("rdx.free.spin"))) {
                    baseUI.setForegroundFPSLimit(350);
                }
                baseUI.setVsync(false);
                this.scenePoseGizmo = new RDXPose3DGizmo(this.context.getTeleportFrameIHMCZUp(), this.context.getTeleportIHMCZUpToIHMCZUpWorld());
                this.scenePoseGizmo.create(baseUI.getPrimary3DPanel());
                this.contextInitialized = true;
                this.waitGetPosesThreadRunning = true;
                ThreadTools.startAsDaemon(this::waitOnPoses, (String)(this.getClass().getSimpleName() + "WaitOnPosesThread"));
            }
            if (this.contextInitialized) {
                posesReadyThisFrame = this.posesReady.poll();
                if (!posesReadyThisFrame && !this.waitingOnPoses) {
                    this.waitingOnPoses = true;
                    this.waitOnPosesNotification.set();
                } else {
                    this.waitingOnPoses = false;
                }
                if (posesReadyThisFrame) {
                    this.pollEventsFrequencyCalculator.ping();
                    object = this.syncObject;
                    synchronized (object) {
                        this.context.pollEvents();
                    }
                }
            }
        } else if (this.contextCreatedNotification != null && this.contextInitialized) {
            this.dispose();
        }
        return posesReadyThisFrame;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitOnPoses() {
        while (this.waitGetPosesThreadRunning) {
            this.waitOnPosesNotification.blockingPoll();
            if (!this.waitGetPosesThreadRunning) continue;
            this.waitGetPosesFrequencyCalculator.ping();
            Object object = this.syncObject;
            synchronized (object) {
                this.context.waitGetPoses();
            }
            this.waitGetToRenderStopwatch.reset();
            this.posesReady.set();
        }
    }

    public void renderImGuiEnableWidget() {
        if (ImGui.checkbox((String)this.labels.get("VR Enabled"), (ImBoolean)this.vrEnabled)) {
            if (this.vrEnabled.get()) {
                LogTools.info((String)"Enabling VR");
            } else {
                LogTools.info((String)"Disabling VR");
            }
        }
        if (ImGui.isItemHovered()) {
            float right = ImGui.getWindowPosX() + ImGui.getWindowSizeX();
            float y = ImGui.getItemRectMaxY();
            ImGui.setNextWindowPos((float)(right - 600.0f), (float)y);
            ImGui.setTooltip((String)"It is recommended to start SteamVR and power on the VR controllers before clicking this button.");
        }
    }

    public void renderImGuiDebugWidgets() {
        ImGui.checkbox((String)this.labels.get("Show scene pose gizmo"), (ImBoolean)this.showScenePoseGizmo);
        this.contextInitializedPlot.render(this.contextInitialized ? 1.0 : 0.0);
        this.initSystemCountPlot.render(this.initSystemCount);
        this.setupEyesCountPlot.render(this.setupEyesCount);
        this.waitGetPosesPlot.render(this.waitGetPosesFrequencyCalculator.getFrequency());
        this.pollEventsPlot.render(this.pollEventsFrequencyCalculator.getFrequency());
        this.vrFPSPlot.render(this.vrFPSCalculator.getFrequency());
        this.waitGetToRenderDelayPlot.render(this.waitGetToRenderDuration);
    }

    public void renderImGuiTunerWidgets() {
        for (RobotSide side : RobotSide.values) {
            RDXVRController controller = this.context.getController(side);
            ImGui.text((String)(side.getPascalCaseName() + " controller selection point:"));
            controller.renderImGuiTunerWidgets();
        }
    }

    public void dispose() {
        this.waitGetPosesThreadRunning = false;
        this.waitOnPosesNotification.set();
        if (this.contextCreatedNotification != null && this.contextInitialized) {
            this.contextCreatedNotification = null;
            this.contextInitialized = false;
            this.context.dispose();
        }
    }

    public boolean isVRReady() {
        return this.vrEnabled.get() && this.contextInitialized && this.context.getHeadset().isConnected();
    }

    public void calculate3DViewPick(ImGui3DViewInput input) {
        if (this.isVRReady() && this.showScenePoseGizmo.get()) {
            this.scenePoseGizmo.calculate3DViewPick(input);
        }
    }

    public void process3DViewInput(ImGui3DViewInput input) {
        if (this.isVRReady() && this.showScenePoseGizmo.get()) {
            this.scenePoseGizmo.process3DViewInput(input);
            this.context.teleport(teleportIHMCZUpToIHMCZUpWorldConsumer -> teleportIHMCZUpToIHMCZUpWorldConsumer.set(this.scenePoseGizmo.getTransformToParent()));
        }
    }

    public void getVirtualRenderables(Array<Renderable> renderables, Pool<Renderable> pool) {
        if (this.vrEnabled.get() && this.contextInitialized) {
            this.teleporter.getRenderables(renderables, pool);
            if (!this.skipHeadset) {
                this.context.getHeadsetRenderable(renderables, pool);
            }
            this.context.getControllerRenderables(renderables, pool);
            this.context.getTrackerRenderables(renderables, pool);
            if (this.showScenePoseGizmo.get()) {
                this.scenePoseGizmo.getRenderables(renderables, pool);
            }
        }
    }

    public RDXVRContext getContext() {
        return this.context;
    }

    public ImBoolean getVREnabled() {
        return this.vrEnabled;
    }

    public RDXVRTeleporter getTeleporter() {
        return this.teleporter;
    }
}

