/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.rdx.vr;

import java.util.function.BooleanSupplier;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.FramePose3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.rdx.vr.RDXVRPickPlaneYawCalculator;
import us.ihmc.robotics.referenceFrames.MutableReferenceFrame;

public class RDXVRDragData {
    public static final double DRAG_TRANSLATION_TOLERANCE = 0.02;
    public static final double DRAG_ROTATION_TOLERANCE = Math.toRadians(3.0);
    private final BooleanSupplier isButtonDown;
    private boolean dragging = false;
    private boolean dragJustStarted = false;
    private Object objectBeingDragged = null;
    private final ReferenceFrame controllerPickFrame;
    private final MutableReferenceFrame dragReferenceFrame;
    private final RDXVRPickPlaneYawCalculator pickPlaneYawCalculator = new RDXVRPickPlaneYawCalculator();
    private final MutableReferenceFrame zUpDragParentFrame;
    private final FramePose3D zUpDragPose = new FramePose3D();
    private final RigidBodyTransform dragStartToWorld = new RigidBodyTransform();
    private boolean clickValid = false;

    public RDXVRDragData(BooleanSupplier isButtonDown, ReferenceFrame controllerPickFrame) {
        this.isButtonDown = isButtonDown;
        this.controllerPickFrame = controllerPickFrame;
        this.dragReferenceFrame = new MutableReferenceFrame(controllerPickFrame);
        this.zUpDragParentFrame = new MutableReferenceFrame();
    }

    public void update() {
        boolean buttonUp;
        boolean bl = buttonUp = !this.isButtonDown.getAsBoolean();
        if (buttonUp) {
            if (!this.dragging) {
                this.clickValid = false;
            }
            this.dragging = false;
            this.dragJustStarted = false;
        } else {
            this.dragJustStarted = !this.dragging;
            this.dragging = true;
            this.dragStartToWorld.set(this.controllerPickFrame.getTransformToRoot());
            this.clickValid = true;
        }
        if (buttonUp || this.dragJustStarted) {
            this.objectBeingDragged = null;
        }
        if (this.dragging) {
            double translationError = this.dragStartToWorld.getTranslation().differenceNorm((Tuple3DReadOnly)this.controllerPickFrame.getTransformToRoot().getTranslation());
            double rotationError = this.dragStartToWorld.getRotation().distance((Orientation3DReadOnly)this.controllerPickFrame.getTransformToRoot().getRotation(), true);
            this.clickValid &= translationError <= 0.02;
            this.clickValid &= rotationError <= DRAG_ROTATION_TOLERANCE;
        }
    }

    public boolean isDraggingSomething() {
        return this.dragging && this.objectBeingDragged != null;
    }

    public boolean isBeingDragged(Object objectInQuestion) {
        return this.objectBeingDragged == objectInQuestion && this.dragging;
    }

    public boolean getDragJustStarted() {
        return this.dragJustStarted;
    }

    public void setObjectBeingDragged(Object objectBeingDragged) {
        this.objectBeingDragged = objectBeingDragged;
    }

    public Object getObjectBeingDragged() {
        return this.objectBeingDragged;
    }

    public void setInteractableFrameOnDragStart(ReferenceFrame interactableFrame) {
        interactableFrame.getTransformToDesiredFrame(this.dragReferenceFrame.getTransformToParent(), this.controllerPickFrame);
        this.dragReferenceFrame.getReferenceFrame().update();
    }

    public void setZUpDragStart(ReferenceFrame interactableFrame) {
        this.updateZUpDrag(interactableFrame);
        this.zUpDragParentFrame.setParentFrame(this.pickPlaneYawCalculator.getYawReferenceFrame());
        interactableFrame.getTransformToDesiredFrame(this.zUpDragParentFrame.getTransformToParent(), this.pickPlaneYawCalculator.getYawReferenceFrame());
        this.zUpDragParentFrame.getTransformToParent().getTranslation().setToZero();
        this.zUpDragParentFrame.getReferenceFrame().update();
    }

    public void updateZUpDrag(ReferenceFrame interactableFrame) {
        this.pickPlaneYawCalculator.calculate(this.controllerPickFrame, interactableFrame);
    }

    public ReferenceFrame getDragFrame() {
        return this.dragReferenceFrame.getReferenceFrame();
    }

    public ReferenceFrame getZUpDragFrame() {
        return this.zUpDragParentFrame.getReferenceFrame();
    }

    public FramePose3D getZUpDragPose() {
        this.zUpDragPose.setToZero(this.getZUpDragFrame());
        this.zUpDragPose.changeFrame(ReferenceFrame.getWorldFrame());
        return this.zUpDragPose;
    }

    boolean isClickValid() {
        return this.clickValid;
    }
}

