/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.rdx.vr;

import com.badlogic.gdx.graphics.g3d.Renderable;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Pool;
import java.awt.Color;
import us.ihmc.euclid.orientation.interfaces.Orientation3DBasics;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.yawPitchRoll.YawPitchRoll;
import us.ihmc.rdx.RDX3DSituatedText;
import us.ihmc.rdx.tools.LibGDXTools;
import us.ihmc.robotics.EuclidCoreMissingTools;
import us.ihmc.robotics.referenceFrames.MutableReferenceFrame;
import us.ihmc.robotics.robotSide.RobotSide;

public class RDXVRControllerButtonLabel {
    private final MutableReferenceFrame textFrame;
    private final RDX3DSituatedText situatedText;

    public RDXVRControllerButtonLabel(ReferenceFrame controllerFrame, RobotSide side, Point3D labelOffset, YawPitchRoll labelOrientation) {
        this.textFrame = new MutableReferenceFrame(controllerFrame);
        this.textFrame.update(transformToParent -> {
            transformToParent.getTranslation().set((Tuple3DReadOnly)labelOffset);
            EuclidCoreMissingTools.setYawPitchRollDegrees((Orientation3DBasics)transformToParent.getRotation(), (double)(-90.0 + side.negateIfLeftSide(10.0)), (double)0.0, (double)15.0);
            transformToParent.getRotation().append((Orientation3DReadOnly)labelOrientation);
        });
        this.situatedText = new RDX3DSituatedText("", Color.WHITE, 0.01f);
    }

    public void setText(String text) {
        this.situatedText.setText(text);
        LibGDXTools.toLibGDX(this.textFrame.getReferenceFrame().getTransformToRoot(), this.situatedText.getModelTransform());
    }

    public void getRenderables(Array<Renderable> renderables, Pool<Renderable> pool) {
        this.situatedText.getRenderables(renderables, pool);
    }
}

