/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.rdx.vr;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.backends.lwjgl3.Lwjgl3Files;
import com.badlogic.gdx.backends.lwjgl3.Lwjgl3NativesLoader;
import java.io.PrintStream;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWErrorCallback;
import org.lwjgl.glfw.GLFWErrorCallbackI;
import org.lwjgl.opengl.GL;
import us.ihmc.rdx.Lwjgl3ApplicationAdapter;
import us.ihmc.rdx.sceneManager.RDX3DScene;
import us.ihmc.rdx.tools.LibGDXTools;
import us.ihmc.rdx.vr.RDXVRContext;
import us.ihmc.rdx.vr.minimalLibGDX.MinimalLibGDXApplication;
import us.ihmc.rdx.vr.minimalLibGDX.MinimalLibGDXGraphics;
import us.ihmc.rdx.vr.minimalLibGDX.MinimalLwjgl3GL30;

public class RDXVRApplication {
    private static GLFWErrorCallback errorCallback;
    private long windowHandle;
    private volatile boolean running = true;
    private RDX3DScene scene;
    private RDXVRContext vrContext;
    private int renderNumber = 0;
    private Runnable thingToRunAfter10Frames;

    public void launch(Lwjgl3ApplicationAdapter applicationAdapter) {
        Lwjgl3NativesLoader.load();
        errorCallback = GLFWErrorCallback.createPrint((PrintStream)System.err);
        GLFW.glfwSetErrorCallback((GLFWErrorCallbackI)errorCallback);
        if (!GLFW.glfwInit()) {
            throw new RuntimeException("Unable to initialize GLFW");
        }
        GLFW.glfwWindowHint((int)131076, (int)0);
        this.windowHandle = GLFW.glfwCreateWindow((int)640, (int)480, (CharSequence)"", (long)0L, (long)0L);
        GLFW.glfwMakeContextCurrent((long)this.windowHandle);
        GL.createCapabilities();
        LibGDXTools.printGLVersion();
        Gdx.gl30 = new MinimalLwjgl3GL30();
        Gdx.gl = Gdx.gl30;
        Gdx.gl20 = Gdx.gl30;
        Gdx.files = new Lwjgl3Files();
        Gdx.graphics = new MinimalLibGDXGraphics();
        MinimalLibGDXApplication app = new MinimalLibGDXApplication();
        Gdx.app = app;
        this.scene = new RDX3DScene();
        this.scene.create();
        this.vrContext = new RDXVRContext();
        this.vrContext.initSystem();
        this.vrContext.setupEyes();
        applicationAdapter.create();
        while (this.running) {
            this.vrContext.waitGetPoses();
            this.vrContext.pollEvents();
            while (!app.getPostRunnables().isEmpty()) {
                app.getPostRunnables().pollFirst().run();
            }
            if (this.renderNumber < 10) {
                ++this.renderNumber;
                if (this.renderNumber == 10 && this.thingToRunAfter10Frames != null) {
                    this.thingToRunAfter10Frames.run();
                }
            }
            applicationAdapter.render();
            this.vrContext.renderEyes(this.scene);
        }
        applicationAdapter.dispose();
        GLFW.glfwDestroyWindow((long)this.windowHandle);
        errorCallback.free();
        errorCallback = null;
        GLFW.glfwTerminate();
    }

    public void runAfter10Frames(Runnable thingToRunAfter10Frames) {
        this.thingToRunAfter10Frames = thingToRunAfter10Frames;
    }

    public RDX3DScene getScene() {
        return this.scene;
    }

    public RDXVRContext getVRContext() {
        return this.vrContext;
    }

    public void exit() {
        this.running = false;
    }
}

