/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.rdx.visualizers;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Mesh;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g3d.Attribute;
import com.badlogic.gdx.graphics.g3d.Material;
import com.badlogic.gdx.graphics.g3d.Model;
import com.badlogic.gdx.graphics.g3d.ModelInstance;
import com.badlogic.gdx.graphics.g3d.Renderable;
import com.badlogic.gdx.graphics.g3d.RenderableProvider;
import com.badlogic.gdx.graphics.g3d.attributes.ColorAttribute;
import com.badlogic.gdx.graphics.g3d.attributes.TextureAttribute;
import com.badlogic.gdx.graphics.g3d.model.MeshPart;
import com.badlogic.gdx.graphics.g3d.utils.ModelBuilder;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Pool;
import java.util.ArrayList;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.rdx.mesh.RDXMultiColorMeshBuilder;
import us.ihmc.tools.thread.MissingThreadTools;
import us.ihmc.tools.thread.ResettableExceptionHandlingExecutorService;

public class RDXLineGraphic
implements RenderableProvider {
    private final ModelBuilder modelBuilder = new ModelBuilder();
    private volatile Runnable buildMeshAndCreateModelInstance = null;
    private ModelInstance modelInstance;
    private Model lastModel;
    private Color color;
    private float lineWidth = 0.1f;
    private final ResettableExceptionHandlingExecutorService executorService = MissingThreadTools.newSingleThreadExecutor((String)this.getClass().getSimpleName(), (boolean)true, (int)1);

    public RDXLineGraphic(float lineWidth, Color color) {
        this.color = color;
        this.lineWidth = lineWidth;
    }

    public void clear() {
        this.generateMeshes(new ArrayList<Point3D>(), 1);
    }

    public void update() {
        if (this.buildMeshAndCreateModelInstance != null) {
            this.buildMeshAndCreateModelInstance.run();
            this.buildMeshAndCreateModelInstance = null;
        }
    }

    public void generateMeshesAsync(ArrayList<Point3D> points, int skip) {
        this.executorService.clearQueueAndExecute(() -> this.generateMeshes(points, skip));
    }

    public synchronized void generateMeshForMatchLines(ArrayList<Point3DReadOnly> points) {
        if (points == null) {
            points = new ArrayList();
        }
        RDXMultiColorMeshBuilder meshBuilder = new RDXMultiColorMeshBuilder();
        for (int i = 0; i < points.size(); i += 2) {
            meshBuilder.addLine((Tuple3DReadOnly)points.get(i), (Tuple3DReadOnly)points.get(i + 1), this.lineWidth, this.color);
        }
        this.buildMeshAndCreateModelInstance = () -> {
            this.modelBuilder.begin();
            Mesh mesh = meshBuilder.generateMesh();
            MeshPart meshPart = new MeshPart("xyz", mesh, 0, mesh.getNumIndices(), 4);
            Material material = new Material();
            Texture paletteTexture = RDXMultiColorMeshBuilder.loadPaletteTexture();
            material.set((Attribute)TextureAttribute.createDiffuse((Texture)paletteTexture));
            material.set((Attribute)ColorAttribute.createDiffuse((Color)new Color(0.7f, 0.7f, 0.7f, 1.0f)));
            this.modelBuilder.part(meshPart, material);
            if (this.lastModel != null) {
                this.lastModel.dispose();
            }
            this.lastModel = this.modelBuilder.end();
            this.modelInstance = new ModelInstance(this.lastModel);
        };
    }

    public synchronized void generateMeshes(ArrayList<Point3D> points, int skip) {
        if (points == null) {
            points = new ArrayList();
        }
        RDXMultiColorMeshBuilder meshBuilder = new RDXMultiColorMeshBuilder();
        for (int i = skip; i < points.size(); i += skip) {
            meshBuilder.addLine((Tuple3DReadOnly)points.get(i - skip), (Tuple3DReadOnly)points.get(i), this.lineWidth, this.color);
        }
        this.buildMeshAndCreateModelInstance = () -> {
            this.modelBuilder.begin();
            Mesh mesh = meshBuilder.generateMesh();
            MeshPart meshPart = new MeshPart("xyz", mesh, 0, mesh.getNumIndices(), 4);
            Material material = new Material();
            Texture paletteTexture = RDXMultiColorMeshBuilder.loadPaletteTexture();
            material.set((Attribute)TextureAttribute.createDiffuse((Texture)paletteTexture));
            material.set((Attribute)ColorAttribute.createDiffuse((Color)new Color(0.7f, 0.7f, 0.7f, 1.0f)));
            this.modelBuilder.part(meshPart, material);
            if (this.lastModel != null) {
                this.lastModel.dispose();
            }
            this.lastModel = this.modelBuilder.end();
            this.modelInstance = new ModelInstance(this.lastModel);
        };
    }

    public void getRenderables(Array<Renderable> renderables, Pool<Renderable> pool) {
        if (this.modelInstance != null) {
            this.modelInstance.getRenderables(renderables, pool);
        }
    }

    public void destroy() {
        this.executorService.destroy();
    }
}

