/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.rdx.ui.gizmo;

import com.badlogic.gdx.graphics.g3d.Renderable;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Pool;
import imgui.internal.ImGui;
import imgui.type.ImBoolean;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.rdx.imgui.ImGuiTools;
import us.ihmc.rdx.input.ImGui3DViewInput;
import us.ihmc.rdx.sceneManager.RDXSceneLevel;
import us.ihmc.rdx.ui.RDX3DPanel;
import us.ihmc.rdx.ui.gizmo.RDXPose3DGizmo;

public class RDXSelectablePose3DGizmo {
    private final RDXPose3DGizmo poseGizmo;
    private final ImBoolean selected;

    public RDXSelectablePose3DGizmo() {
        this.selected = new ImBoolean(false);
        this.poseGizmo = new RDXPose3DGizmo();
    }

    public RDXSelectablePose3DGizmo(ReferenceFrame parentReferenceFrame) {
        this.selected = new ImBoolean(false);
        this.poseGizmo = new RDXPose3DGizmo(parentReferenceFrame);
    }

    public RDXSelectablePose3DGizmo(ReferenceFrame gizmoFrame, RigidBodyTransform gizmoTransformToParentFrameToModify) {
        this(gizmoFrame, gizmoTransformToParentFrameToModify, new ImBoolean(false));
    }

    public RDXSelectablePose3DGizmo(ReferenceFrame gizmoFrame, RigidBodyTransform gizmoTransformToParentFrameToModify, ImBoolean selected) {
        this.selected = selected;
        this.poseGizmo = new RDXPose3DGizmo(gizmoFrame, gizmoTransformToParentFrameToModify);
    }

    public RDXSelectablePose3DGizmo(RigidBodyTransform gizmoTransformToParentFrameToModify, ReferenceFrame parentReferenceFrame, ImBoolean selected) {
        this.selected = selected;
        this.poseGizmo = new RDXPose3DGizmo(gizmoTransformToParentFrameToModify, parentReferenceFrame);
    }

    public void create(RDX3DPanel panel3D) {
        this.poseGizmo.create(panel3D);
    }

    public void createAndSetupDefault(RDX3DPanel panel3D) {
        this.create(panel3D);
        panel3D.addImGui3DViewPickCalculator(this, this::calculate3DViewPick);
        panel3D.addImGui3DViewInputProcessor(this, this::process3DViewInput);
        panel3D.getScene().addRenderableProvider(this, this::getVirtualRenderables, RDXSceneLevel.VIRTUAL);
    }

    public void removeRenderables(RDX3DPanel panel3D) {
        panel3D.getScene().removeRenderable(this);
        panel3D.removeImGui3DViewPickCalculator(this);
        panel3D.removeImGui3DViewInputProcessor(this);
    }

    public void calculate3DViewPick(ImGui3DViewInput input) {
        if (input.isWindowHovered() && this.selected.get()) {
            this.poseGizmo.calculate3DViewPick(input);
        }
    }

    public void process3DViewInput(ImGui3DViewInput input) {
        this.process3DViewInput(input, this.selected.get());
    }

    public void process3DViewInput(ImGui3DViewInput input, boolean isPickSelected) {
        if (input.isWindowHovered()) {
            boolean deselectionKeyPressed;
            boolean leftMouseReleasedWithoutDrag = input.mouseReleasedWithoutDrag(0);
            boolean isClickedOn = isPickSelected && leftMouseReleasedWithoutDrag;
            boolean somethingElseIsClickedOn = !isPickSelected && leftMouseReleasedWithoutDrag;
            boolean bl = deselectionKeyPressed = ImGui.isKeyReleased((int)ImGuiTools.getDeleteKey()) || ImGui.isKeyReleased((int)ImGuiTools.getEscapeKey());
            if (isClickedOn) {
                this.selected.set(true);
            }
            if (somethingElseIsClickedOn || deselectionKeyPressed) {
                this.selected.set(false);
            }
        }
        if (this.selected.get()) {
            this.poseGizmo.process3DViewInput(input);
        } else {
            this.poseGizmo.update();
        }
    }

    public void getVirtualRenderables(Array<Renderable> renderables, Pool<Renderable> pool) {
        if (this.selected.get()) {
            this.poseGizmo.getRenderables(renderables, pool);
        }
    }

    public RDXPose3DGizmo getPoseGizmo() {
        return this.poseGizmo;
    }

    public boolean isSelected() {
        return this.selected.get();
    }

    public ImBoolean getSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.selected.set(selected);
    }
}

