/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.rdx.ui.gizmo;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Mesh;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g3d.Attribute;
import com.badlogic.gdx.graphics.g3d.Material;
import com.badlogic.gdx.graphics.g3d.Renderable;
import com.badlogic.gdx.graphics.g3d.RenderableProvider;
import com.badlogic.gdx.graphics.g3d.attributes.BlendingAttribute;
import com.badlogic.gdx.graphics.g3d.attributes.TextureAttribute;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Pool;
import imgui.internal.ImGui;
import imgui.type.ImBoolean;
import imgui.type.ImFloat;
import us.ihmc.commons.thread.Notification;
import us.ihmc.euclid.Axis3D;
import us.ihmc.euclid.axisAngle.interfaces.AxisAngleReadOnly;
import us.ihmc.euclid.exceptions.NotARotationMatrixException;
import us.ihmc.euclid.geometry.interfaces.Line3DReadOnly;
import us.ihmc.euclid.matrix.interfaces.RotationMatrixReadOnly;
import us.ihmc.euclid.orientation.interfaces.Orientation3DBasics;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.FramePose3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FramePose3DReadOnly;
import us.ihmc.euclid.referenceFrame.tools.ReferenceFrameTools;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformBasics;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.euclid.tuple4D.Quaternion;
import us.ihmc.euclid.yawPitchRoll.YawPitchRoll;
import us.ihmc.graphicsDescription.MeshDataGenerator;
import us.ihmc.graphicsDescription.MeshDataHolder;
import us.ihmc.log.LogTools;
import us.ihmc.rdx.RDXFocusBasedCamera;
import us.ihmc.rdx.imgui.ImGuiTools;
import us.ihmc.rdx.imgui.ImGuiUniqueLabelMap;
import us.ihmc.rdx.imgui.RDXPanel;
import us.ihmc.rdx.input.ImGui3DViewInput;
import us.ihmc.rdx.input.ImGui3DViewPickResult;
import us.ihmc.rdx.input.ImGuiMouseDragData;
import us.ihmc.rdx.mesh.RDXMeshBuilder;
import us.ihmc.rdx.mesh.RDXMeshDataInterpreter;
import us.ihmc.rdx.mesh.RDXMultiColorMeshBuilder;
import us.ihmc.rdx.sceneManager.RDXSceneLevel;
import us.ihmc.rdx.tools.LibGDXTools;
import us.ihmc.rdx.ui.RDX3DPanel;
import us.ihmc.rdx.ui.RDXBaseUI;
import us.ihmc.rdx.ui.gizmo.DynamicLibGDXModel;
import us.ihmc.rdx.ui.gizmo.FrameBasedGizmoModification;
import us.ihmc.rdx.ui.gizmo.RDXGizmoTools;
import us.ihmc.robotics.interaction.Axis3DRotations;
import us.ihmc.robotics.interaction.ClockFaceRotation3DMouseDragAlgorithm;
import us.ihmc.robotics.interaction.DiscreteArrowRayIntersection;
import us.ihmc.robotics.interaction.DiscreteTorusRayIntersection;
import us.ihmc.robotics.interaction.Line3DMouseDragAlgorithm;
import us.ihmc.robotics.interaction.Plane3DMouseDragAlgorithm;
import us.ihmc.robotics.interaction.SixDoFSelection;
import us.ihmc.robotics.interaction.SphereRayIntersection;
import us.ihmc.robotics.referenceFrames.ReferenceFrameMissingTools;
import us.ihmc.robotics.robotSide.RobotSide;

public class RDXPose3DGizmo
implements RenderableProvider {
    private final ImGuiUniqueLabelMap labels = new ImGuiUniqueLabelMap(this.getClass());
    private final ImFloat torusRadius = new ImFloat(0.5f);
    private final ImFloat torusCameraSize = new ImFloat(0.067f);
    private final ImFloat torusTubeRadiusRatio = new ImFloat(0.074f);
    private final ImFloat centerSphereRadius = new ImFloat();
    private final ImFloat centerSphereToTorusRatio = new ImFloat(0.125f);
    private final ImFloat arrowLengthRatio = new ImFloat(0.431f);
    private final ImFloat arrowHeadBodyLengthRatio = new ImFloat(0.48f);
    private final ImFloat arrowHeadBodyRadiusRatio = new ImFloat(2.0f);
    private final ImFloat arrowSpacingFactor = new ImFloat(2.22f);
    private final ImBoolean resizeAutomatically = new ImBoolean(true);
    private double arrowBodyRadius;
    private double arrowLength;
    private double arrowBodyLength;
    private double arrowHeadRadius;
    private double arrowHeadLength;
    private double arrowSpacing;
    private final Material[] normalMaterials = new Material[3];
    private final Material[] highlightedMaterials = new Material[3];
    private final Axis3DRotations axisRotations = new Axis3DRotations();
    private final DynamicLibGDXModel centerSphereModel = new DynamicLibGDXModel();
    private final DynamicLibGDXModel[] arrowModels = new DynamicLibGDXModel[3];
    private final DynamicLibGDXModel[] torusModels = new DynamicLibGDXModel[3];
    private final Point3D closestCollision = new Point3D();
    private SixDoFSelection closestCollisionSelection = null;
    private double closestCollisionDistance;
    private final ImGui3DViewPickResult pickResult = new ImGui3DViewPickResult();
    private boolean isGizmoHovered = false;
    private boolean isBeingManipulated = false;
    private final SphereRayIntersection boundingSphereIntersection = new SphereRayIntersection();
    private final SphereRayIntersection centerSphereIntersection = new SphereRayIntersection();
    private final DiscreteTorusRayIntersection torusIntersection = new DiscreteTorusRayIntersection();
    private final DiscreteArrowRayIntersection arrowIntersection = new DiscreteArrowRayIntersection();
    private RigidBodyTransform transformToParent;
    private final FramePose3D framePose3D = new FramePose3D();
    private ReferenceFrame gizmoFrame;
    private final RigidBodyTransform transformToWorld = new RigidBodyTransform();
    private final RigidBodyTransform[] axisTransformToWorlds = new RigidBodyTransform[3];
    private final Notification gizmoModifiedByUser = new Notification();
    private static final YawPitchRoll FLIP_180 = new YawPitchRoll(0.0, Math.PI, 0.0);
    private final Plane3DMouseDragAlgorithm planeDragAlgorithm = new Plane3DMouseDragAlgorithm();
    private final Line3DMouseDragAlgorithm lineDragAlgorithm = new Line3DMouseDragAlgorithm();
    private final ClockFaceRotation3DMouseDragAlgorithm clockFaceDragAlgorithm = new ClockFaceRotation3DMouseDragAlgorithm();
    private RDXFocusBasedCamera camera3D;
    private final Point3D cameraPosition = new Point3D();
    private double distanceToCamera;
    private double lastDistanceToCamera = -1.0;
    private final double translateSpeedFactor = 0.5;
    private boolean queuePopupToOpen = false;
    private boolean proportionsNeedUpdate = false;
    private FrameBasedGizmoModification frameBasedGizmoModification;

    public RDXPose3DGizmo() {
        this(ReferenceFrame.getWorldFrame());
    }

    public RDXPose3DGizmo(String gizmoFrameName) {
        this(gizmoFrameName, ReferenceFrame.getWorldFrame());
    }

    public RDXPose3DGizmo(ReferenceFrame parentReferenceFrame) {
        this(ReferenceFrameMissingTools.computeFrameName(), parentReferenceFrame);
    }

    public RDXPose3DGizmo(String gizmoFrameName, ReferenceFrame parentReferenceFrame) {
        RigidBodyTransform transformToParent = new RigidBodyTransform();
        ReferenceFrame gizmoFrame = ReferenceFrameTools.constructFrameWithChangingTransformToParent((String)gizmoFrameName, (ReferenceFrame)parentReferenceFrame, (RigidBodyTransformReadOnly)transformToParent);
        this.initialize(gizmoFrame, transformToParent);
    }

    public RDXPose3DGizmo(ReferenceFrame gizmoFrame, RigidBodyTransform gizmoTransformToParentFrameToModify) {
        this.initialize(gizmoFrame, gizmoTransformToParentFrameToModify);
    }

    public RDXPose3DGizmo(RigidBodyTransform gizmoTransformToParentFrameToModify, ReferenceFrame parentReferenceFrame) {
        this(ReferenceFrameMissingTools.computeFrameName(), gizmoTransformToParentFrameToModify, parentReferenceFrame);
    }

    public RDXPose3DGizmo(String gizmoFrameName, RigidBodyTransform gizmoTransformToParentFrameToModify, ReferenceFrame parentReferenceFrame) {
        ReferenceFrame gizmoFrame = ReferenceFrameTools.constructFrameWithChangingTransformToParent((String)gizmoFrameName, (ReferenceFrame)parentReferenceFrame, (RigidBodyTransformReadOnly)gizmoTransformToParentFrameToModify);
        this.initialize(gizmoFrame, gizmoTransformToParentFrameToModify);
    }

    private void initialize(ReferenceFrame gizmoFrame, RigidBodyTransform gizmoTransformToParentFrameToModify) {
        this.transformToParent = gizmoTransformToParentFrameToModify;
        this.gizmoFrame = gizmoFrame;
        RDXBaseUI.getInstance().getKeyBindings().register("Translation adjustment X+", "Up arrow");
        RDXBaseUI.getInstance().getKeyBindings().register("Translation adjustment X-", "Down arrow");
        RDXBaseUI.getInstance().getKeyBindings().register("Translation adjustment Y+", "Left arrow");
        RDXBaseUI.getInstance().getKeyBindings().register("Translation adjustment Y-", "Right arrow");
        RDXBaseUI.getInstance().getKeyBindings().register("Translation adjustment Z+", "Ctrl + Up arrow");
        RDXBaseUI.getInstance().getKeyBindings().register("Translation adjustment Z-", "Ctrl + Down arrow");
        RDXBaseUI.getInstance().getKeyBindings().register("Pitch adjustment +", "Alt + Up arrow");
        RDXBaseUI.getInstance().getKeyBindings().register("Pitch adjustment -", "Alt + Down arrow");
        RDXBaseUI.getInstance().getKeyBindings().register("Roll adjustment +", "Alt + Right arrow");
        RDXBaseUI.getInstance().getKeyBindings().register("Roll adjustment -", "Alt + Left arrow");
        RDXBaseUI.getInstance().getKeyBindings().register("Yaw adjustment +", "Ctrl + Left arrow");
        RDXBaseUI.getInstance().getKeyBindings().register("Yaw adjustment -", "Ctrl + Right arrow");
        RDXBaseUI.getInstance().getKeyBindings().register("Yaw adjustment +", "Ctrl + Mouse scroll down");
        RDXBaseUI.getInstance().getKeyBindings().register("Yaw adjustment -", "Ctrl + Mouse scroll up");
        RDXBaseUI.getInstance().getKeyBindings().register("Fine adjustment modifier", "Shift");
        RDXBaseUI.getInstance().getKeyBindings().register("Manipulate axes", "Left mouse drag");
        RDXBaseUI.getInstance().getKeyBindings().register("Open context menu", "Right mouse click");
        RDXBaseUI.getInstance().getKeyBindings().register("Open context menu", "Right mouse click");
    }

    public void setGizmoFrame(ReferenceFrame gizmoFrame) {
        this.gizmoFrame = gizmoFrame;
    }

    public void setParentFrame(ReferenceFrame newParentFrame) {
        this.gizmoFrame.remove();
        this.gizmoFrame = ReferenceFrameMissingTools.constructFrameWithChangingTransformToParent((ReferenceFrame)newParentFrame, (RigidBodyTransformReadOnly)this.transformToParent);
    }

    public void changeParentFrameWithoutMoving(ReferenceFrame newParentFrame) {
        RigidBodyTransform newTransformToParent = new RigidBodyTransform();
        this.gizmoFrame.getTransformToDesiredFrame(newTransformToParent, newParentFrame);
        this.transformToParent.set(newTransformToParent);
        this.gizmoFrame = ReferenceFrameMissingTools.constructFrameWithChangingTransformToParent((ReferenceFrame)newParentFrame, (RigidBodyTransformReadOnly)this.transformToParent);
    }

    public void createAndSetupDefault(RDX3DPanel panel3D) {
        this.create(panel3D);
        panel3D.addImGui3DViewPickCalculator(this::calculate3DViewPick);
        panel3D.addImGui3DViewInputProcessor(this::process3DViewInput);
        panel3D.getScene().addRenderableProvider(this, RDXSceneLevel.VIRTUAL);
    }

    public void create(RDX3DPanel panel3D) {
        this.camera3D = panel3D.getCamera3D();
        this.frameBasedGizmoModification = new FrameBasedGizmoModification(this::getGizmoFrame, () -> this.gizmoFrame.getParent(), this.camera3D);
        panel3D.addImGuiOverlayAddition(this::renderTooltipAndContextMenu);
        this.centerSphereModel.setMesh(meshBuilder -> meshBuilder.addSphere(this.centerSphereRadius.get(), RDXGizmoTools.CENTER_DEFAULT_COLOR));
        for (Axis3D axis : Axis3D.values) {
            Color color = RDXGizmoTools.AXIS_COLORS[axis.ordinal()];
            this.normalMaterials[axis.ordinal()] = new Material();
            this.normalMaterials[axis.ordinal()].set((Attribute)TextureAttribute.createDiffuse((Texture)RDXMultiColorMeshBuilder.loadPaletteTexture()));
            this.normalMaterials[axis.ordinal()].set((Attribute)new BlendingAttribute(true, color.a));
            this.highlightedMaterials[axis.ordinal()] = new Material();
            this.highlightedMaterials[axis.ordinal()].set((Attribute)TextureAttribute.createDiffuse((Texture)RDXMultiColorMeshBuilder.loadPaletteTexture()));
            this.highlightedMaterials[axis.ordinal()].set((Attribute)new BlendingAttribute(true, RDXGizmoTools.AXIS_SELECTED_COLORS[axis.ordinal()].a));
            this.arrowModels[axis.ordinal()] = new DynamicLibGDXModel();
            this.arrowModels[axis.ordinal()].setMesh(meshBuilder -> {
                meshBuilder.addCylinder(this.arrowBodyLength, this.arrowBodyRadius, (Tuple3DReadOnly)new Point3D(0.0, 0.0, 0.5 * this.arrowSpacing), color);
                meshBuilder.addCone(this.arrowHeadLength, this.arrowHeadRadius, (Tuple3DReadOnly)new Point3D(0.0, 0.0, 0.5 * this.arrowSpacing + this.arrowBodyLength), color);
                meshBuilder.addCylinder(this.arrowBodyLength, this.arrowBodyRadius, (Tuple3DReadOnly)new Point3D(0.0, 0.0, -0.5 * this.arrowSpacing), (Orientation3DReadOnly)FLIP_180, color);
            });
            this.torusModels[axis.ordinal()] = new DynamicLibGDXModel();
            int resolution = 25;
            this.torusModels[axis.ordinal()].setMesh(meshBuilder -> meshBuilder.addArcTorus(0.0, Math.PI * 2, this.torusRadius.get(), this.torusTubeRadiusRatio.get() * this.torusRadius.get(), resolution, color));
            this.axisTransformToWorlds[axis.ordinal()] = new RigidBodyTransform();
        }
        this.recreateGraphics();
    }

    public void calculate3DViewPick(ImGui3DViewInput input) {
        boolean isWindowHovered = ImGui.isWindowHovered();
        ImGuiMouseDragData manipulationDragData = input.getMouseDragData(0);
        if (isWindowHovered && (!manipulationDragData.isDragging() || manipulationDragData.getDragJustStarted())) {
            Line3DReadOnly pickRay = input.getPickRayInWorld();
            this.determineCurrentSelectionFromPickRay(pickRay);
            if (this.closestCollisionSelection != null) {
                this.pickResult.setDistanceToCamera(this.closestCollisionDistance);
                input.addPickResult(this.pickResult);
            }
        }
    }

    public void process3DViewInput(ImGui3DViewInput input) {
        boolean isWindowHovered = input.isWindowHovered();
        ImGuiMouseDragData manipulationDragData = input.getMouseDragData(0);
        boolean bl = this.isGizmoHovered = isWindowHovered && this.pickResult == input.getClosestPick();
        if (this.isGizmoHovered && input.mouseReleasedWithoutDrag(1)) {
            this.queuePopupToOpen = true;
        }
        if (this.isGizmoHovered && manipulationDragData.getDragJustStarted()) {
            this.clockFaceDragAlgorithm.reset();
            manipulationDragData.setObjectBeingDragged(this);
        }
        this.isBeingManipulated = manipulationDragData.isBeingDragged(this);
        this.updateMaterialHighlighting();
        if (this.isBeingManipulated && this.closestCollisionSelection != null) {
            Line3DReadOnly pickRay = input.getPickRayInWorld();
            if (this.closestCollisionSelection.isCenter()) {
                Vector3DReadOnly planarMotion = this.planeDragAlgorithm.calculate(pickRay, (Point3DReadOnly)this.closestCollision, (Vector3DReadOnly)Axis3D.Z);
                this.frameBasedGizmoModification.translateInWorld(planarMotion);
                this.closestCollision.add((Tuple3DReadOnly)planarMotion);
            } else if (this.closestCollisionSelection.isLinear()) {
                Vector3DReadOnly linearMotion = this.lineDragAlgorithm.calculate(pickRay, this.closestCollision, this.axisRotations.get(this.closestCollisionSelection.toAxis3D()), (RigidBodyTransformReadOnly)this.transformToWorld);
                this.frameBasedGizmoModification.translateInWorld(linearMotion);
                this.closestCollision.add((Tuple3DReadOnly)linearMotion);
            } else if (this.closestCollisionSelection.isAngular() && this.clockFaceDragAlgorithm.calculate(pickRay, this.closestCollision, (RotationMatrixReadOnly)this.axisRotations.get(this.closestCollisionSelection.toAxis3D()), (RigidBodyTransformReadOnly)this.transformToWorld)) {
                this.frameBasedGizmoModification.rotateInWorld((AxisAngleReadOnly)this.clockFaceDragAlgorithm.getMotion());
            }
        }
        if (isWindowHovered) {
            boolean anyArrowHeld;
            boolean ctrlHeld = ImGui.getIO().getKeyCtrl();
            boolean shiftHeld = ImGui.getIO().getKeyShift();
            if (ctrlHeld && input.getMouseWheelDelta() != 0.0f) {
                float deltaScroll = input.getMouseWheelDelta();
                double amount = shiftHeld ? 0.001 : 0.012;
                this.frameBasedGizmoModification.yawInWorld((double)Math.signum(deltaScroll) * amount * Math.PI);
            }
            boolean upArrowHeld = ImGui.isKeyDown((int)ImGuiTools.getUpArrowKey());
            boolean downArrowHeld = ImGui.isKeyDown((int)ImGuiTools.getDownArrowKey());
            boolean leftArrowHeld = ImGui.isKeyDown((int)ImGuiTools.getLeftArrowKey());
            boolean rightArrowHeld = ImGui.isKeyDown((int)ImGuiTools.getRightArrowKey());
            boolean bl2 = anyArrowHeld = upArrowHeld || downArrowHeld || leftArrowHeld || rightArrowHeld;
            if (anyArrowHeld) {
                boolean altHeld = ImGui.getIO().getKeyAlt();
                double deltaTime = Gdx.graphics.getDeltaTime();
                double amountRotation = deltaTime * (shiftHeld ? 0.2 : 1.0);
                double amountTranslation = deltaTime * (shiftHeld ? 0.05 : 0.4);
                Orientation3DBasics orientationToAdjust = this.frameBasedGizmoModification.beforeForRotationAdjustment();
                Point3DBasics positionToAdjust = this.frameBasedGizmoModification.beforeForTranslationAdjustment();
                if (altHeld && !ctrlHeld) {
                    if (upArrowHeld) {
                        orientationToAdjust.appendPitchRotation(amountRotation);
                    }
                    if (downArrowHeld) {
                        orientationToAdjust.appendPitchRotation(-amountRotation);
                    }
                    if (rightArrowHeld) {
                        orientationToAdjust.appendRollRotation(amountRotation);
                    }
                    if (leftArrowHeld) {
                        orientationToAdjust.appendRollRotation(-amountRotation);
                    }
                } else if (!altHeld && ctrlHeld) {
                    if (leftArrowHeld) {
                        orientationToAdjust.appendYawRotation(amountRotation);
                    }
                    if (rightArrowHeld) {
                        orientationToAdjust.appendYawRotation(-amountRotation);
                    }
                    if (upArrowHeld) {
                        positionToAdjust.addZ(this.getTranslateSpeedFactor() * amountTranslation);
                    }
                    if (downArrowHeld) {
                        positionToAdjust.subZ(this.getTranslateSpeedFactor() * amountTranslation);
                    }
                } else {
                    if (upArrowHeld && !ctrlHeld) {
                        positionToAdjust.addX(this.getTranslateSpeedFactor() * amountTranslation);
                    }
                    if (downArrowHeld && !ctrlHeld) {
                        positionToAdjust.subX(this.getTranslateSpeedFactor() * amountTranslation);
                    }
                    if (leftArrowHeld && !ctrlHeld) {
                        positionToAdjust.addY(this.getTranslateSpeedFactor() * amountTranslation);
                    }
                    if (rightArrowHeld && !ctrlHeld) {
                        positionToAdjust.subY(this.getTranslateSpeedFactor() * amountTranslation);
                    }
                }
                this.frameBasedGizmoModification.afterRotationAdjustment(true);
                this.frameBasedGizmoModification.afterRotationAdjustment(true);
                this.frameBasedGizmoModification.setAdjustmentNeedsToBeApplied();
            }
        }
        this.update();
    }

    private void renderTooltipAndContextMenu() {
        if (this.queuePopupToOpen) {
            this.queuePopupToOpen = false;
            ImGui.openPopup((String)this.labels.get("Popup"));
        }
        if (ImGui.beginPopup((String)this.labels.get("Popup"))) {
            this.renderImGuiTuner();
            if (ImGui.menuItem((String)"Close")) {
                ImGui.closeCurrentPopup();
            }
            ImGui.endPopup();
        }
    }

    public void update() {
        if (this.frameBasedGizmoModification.applyAdjustmentIfNeeded(this.transformToParent)) {
            this.gizmoModifiedByUser.set();
        }
        this.gizmoFrame.update();
        this.frameBasedGizmoModification.setToZeroGizmoFrame();
        for (Axis3D axis : Axis3D.values) {
            this.framePose3D.setToZero(this.gizmoFrame);
            this.framePose3D.getOrientation().setAndNormalize((Orientation3DReadOnly)this.axisRotations.get(axis));
            try {
                this.framePose3D.changeFrame(this.gizmoFrame.getRootFrame());
            }
            catch (NotARotationMatrixException notARotationMatrixException) {
                LogTools.error((String)notARotationMatrixException.getMessage());
            }
            this.framePose3D.get((RigidBodyTransformBasics)this.axisTransformToWorlds[axis.ordinal()]);
        }
        this.framePose3D.get((RigidBodyTransformBasics)this.transformToWorld);
        this.updateGraphicTransforms();
        LibGDXTools.toEuclid(this.camera3D.position, (Point3DBasics)this.cameraPosition);
        this.distanceToCamera = this.cameraPosition.distance((Point3DReadOnly)this.framePose3D.getPosition());
        if (this.resizeAutomatically.get() && !EuclidCoreTools.epsilonEquals((double)this.lastDistanceToCamera, (double)this.distanceToCamera, (double)0.001)) {
            this.lastDistanceToCamera = this.distanceToCamera;
            this.recreateGraphics();
        }
        if (this.proportionsNeedUpdate) {
            this.proportionsNeedUpdate = false;
            this.recreateGraphics();
        }
    }

    private void updateGraphicTransforms() {
        LibGDXTools.toLibGDX(this.transformToWorld, this.centerSphereModel.getOrCreateModelInstance().transform);
        for (Axis3D axis : Axis3D.values) {
            LibGDXTools.toLibGDX(this.axisTransformToWorlds[axis.ordinal()], this.arrowModels[axis.ordinal()].getOrCreateModelInstance().transform);
            LibGDXTools.toLibGDX(this.axisTransformToWorlds[axis.ordinal()], this.torusModels[axis.ordinal()].getOrCreateModelInstance().transform);
        }
    }

    private void determineCurrentSelectionFromPickRay(Line3DReadOnly pickRay) {
        this.closestCollisionSelection = null;
        this.closestCollisionDistance = Double.POSITIVE_INFINITY;
        this.boundingSphereIntersection.update(1.5 * (double)this.torusRadius.get(), (RigidBodyTransformReadOnly)this.transformToWorld);
        if (this.boundingSphereIntersection.intersect(pickRay)) {
            this.centerSphereIntersection.update((double)this.centerSphereRadius.get(), (RigidBodyTransformReadOnly)this.transformToWorld);
            boolean hoveringCenterSphere = this.centerSphereIntersection.intersect(pickRay);
            double distance = this.centerSphereIntersection.getFirstIntersectionToPack().distance(pickRay.getPoint());
            if (hoveringCenterSphere && distance < this.closestCollisionDistance) {
                this.closestCollisionDistance = distance;
                this.closestCollisionSelection = SixDoFSelection.CENTER;
                this.closestCollision.set((Tuple3DReadOnly)this.centerSphereIntersection.getFirstIntersectionToPack());
            }
            for (Axis3D axis : Axis3D.values) {
                this.torusIntersection.update((double)this.torusRadius.get(), (double)(this.torusTubeRadiusRatio.get() * this.torusRadius.get()), (RigidBodyTransformReadOnly)this.axisTransformToWorlds[axis.ordinal()]);
                distance = this.torusIntersection.intersect(pickRay, 100);
                if (Double.isNaN(distance) || !(distance < this.closestCollisionDistance)) continue;
                this.closestCollisionDistance = distance;
                this.closestCollisionSelection = SixDoFSelection.toAngularSelection((Axis3D)axis);
                this.closestCollision.set(this.torusIntersection.getClosestIntersection());
            }
            for (Axis3D axis : Axis3D.values) {
                for (RobotSide side : RobotSide.values) {
                    double zOffset = side.negateIfRightSide(0.5 * this.arrowSpacing + 0.5 * this.arrowBodyLength);
                    this.arrowIntersection.update(this.arrowBodyLength, this.arrowBodyRadius, this.arrowHeadRadius, this.arrowHeadLength, zOffset, (RigidBodyTransformReadOnly)this.axisTransformToWorlds[axis.ordinal()]);
                    distance = this.arrowIntersection.intersect(pickRay, 100, side == RobotSide.LEFT);
                    if (Double.isNaN(distance) || !(distance < this.closestCollisionDistance)) continue;
                    this.closestCollisionDistance = distance;
                    this.closestCollisionSelection = SixDoFSelection.toLinearSelection((Axis3D)axis);
                    this.closestCollision.set(this.arrowIntersection.getIntersection());
                }
            }
        }
    }

    private void updateMaterialHighlighting() {
        boolean highlightingPrior;
        boolean bl = highlightingPrior = (this.isGizmoHovered || this.isBeingManipulated) && this.closestCollisionSelection != null;
        if (highlightingPrior && this.closestCollisionSelection.isCenter()) {
            this.centerSphereModel.setMaterial(this.highlightedMaterials[0]);
        } else {
            this.centerSphereModel.setMaterial(this.normalMaterials[0]);
        }
        for (Axis3D axis : Axis3D.values) {
            if (highlightingPrior && this.closestCollisionSelection.isAngular() && this.closestCollisionSelection.toAxis3D() == axis) {
                this.torusModels[axis.ordinal()].setMaterial(this.highlightedMaterials[axis.ordinal()]);
            } else {
                this.torusModels[axis.ordinal()].setMaterial(this.normalMaterials[axis.ordinal()]);
            }
            if (highlightingPrior && this.closestCollisionSelection.isLinear() && this.closestCollisionSelection.toAxis3D() == axis) {
                this.arrowModels[axis.ordinal()].setMaterial(this.highlightedMaterials[axis.ordinal()]);
                continue;
            }
            this.arrowModels[axis.ordinal()].setMaterial(this.normalMaterials[axis.ordinal()]);
        }
    }

    public RDXPanel createTunerPanel(String name) {
        return new RDXPanel("Pose3D Gizmo Tuner (" + name + ")", this::renderImGuiTuner);
    }

    public void renderImGuiTuner() {
        this.frameBasedGizmoModification.renderImGuiTunerWidgets();
        if (ImGui.collapsingHeader((String)this.labels.get("Controls"))) {
            ImGui.text((String)"Drag using the left mouse button to manipulate the gizmo.");
        }
        if (ImGui.collapsingHeader((String)this.labels.get("Visual options"))) {
            ImGui.checkbox((String)"Resize based on camera distance", (ImBoolean)this.resizeAutomatically);
            ImGui.pushItemWidth((float)100.0f);
            this.proportionsNeedUpdate = this.resizeAutomatically.get() ? (this.proportionsNeedUpdate |= ImGui.dragFloat((String)this.labels.get("Torus camera size"), (float[])this.torusCameraSize.getData(), (float)0.001f)) : (this.proportionsNeedUpdate |= ImGui.dragFloat((String)this.labels.get("Torus radius"), (float[])this.torusRadius.getData(), (float)0.001f));
            ImGui.popItemWidth();
            ImGui.separator();
            ImGui.pushItemWidth((float)100.0f);
            this.proportionsNeedUpdate |= ImGui.dragFloat((String)this.labels.get("Center sphere to torus ratio"), (float[])this.centerSphereToTorusRatio.getData(), (float)0.05f);
            this.proportionsNeedUpdate |= ImGui.dragFloat((String)this.labels.get("Torus tube radius ratio"), (float[])this.torusTubeRadiusRatio.getData(), (float)0.001f);
            this.proportionsNeedUpdate |= ImGui.dragFloat((String)this.labels.get("Arrow length ratio"), (float[])this.arrowLengthRatio.getData(), (float)0.05f);
            this.proportionsNeedUpdate |= ImGui.dragFloat((String)this.labels.get("Arrow head body length ratio"), (float[])this.arrowHeadBodyLengthRatio.getData(), (float)0.05f);
            this.proportionsNeedUpdate |= ImGui.dragFloat((String)this.labels.get("Arrow head body radius ratio"), (float[])this.arrowHeadBodyRadiusRatio.getData(), (float)0.05f);
            this.proportionsNeedUpdate |= ImGui.dragFloat((String)this.labels.get("Arrow spacing factor"), (float[])this.arrowSpacingFactor.getData(), (float)0.05f);
            ImGui.popItemWidth();
        }
    }

    private void recreateGraphics() {
        if (this.resizeAutomatically.get()) {
            if (this.lastDistanceToCamera > 0.0) {
                this.torusRadius.set(this.torusCameraSize.get() * (float)this.lastDistanceToCamera);
            } else {
                this.torusRadius.set(this.torusCameraSize.get());
            }
        }
        this.centerSphereRadius.set(this.torusRadius.get() * this.centerSphereToTorusRatio.get());
        this.arrowBodyRadius = this.torusTubeRadiusRatio.get() * this.torusRadius.get();
        this.arrowLength = this.arrowLengthRatio.get() * this.torusRadius.get();
        this.arrowBodyLength = (1.0 - (double)this.arrowHeadBodyLengthRatio.get()) * this.arrowLength;
        this.arrowHeadRadius = (double)this.arrowHeadBodyRadiusRatio.get() * this.arrowBodyRadius;
        this.arrowHeadLength = (double)this.arrowHeadBodyLengthRatio.get() * this.arrowLength;
        this.arrowSpacing = this.arrowSpacingFactor.get() * (this.torusRadius.get() + this.torusTubeRadiusRatio.get() * this.torusRadius.get());
        this.updateMaterialHighlighting();
        this.centerSphereModel.invalidateMesh();
        for (Axis3D axis : Axis3D.values) {
            this.arrowModels[axis.ordinal()].invalidateMesh();
            this.torusModels[axis.ordinal()].invalidateMesh();
        }
        this.updateGraphicTransforms();
    }

    public void getRenderables(Array<Renderable> renderables, Pool<Renderable> pool) {
        this.centerSphereModel.getOrCreateModelInstance().getRenderables(renderables, pool);
        for (Axis3D axis : Axis3D.values) {
            this.arrowModels[axis.ordinal()].getOrCreateModelInstance().getRenderables(renderables, pool);
            this.torusModels[axis.ordinal()].getOrCreateModelInstance().getRenderables(renderables, pool);
        }
    }

    public FramePose3DReadOnly getPose() {
        return this.framePose3D;
    }

    public RigidBodyTransform getTransformToParent() {
        return this.transformToParent;
    }

    public ReferenceFrame getGizmoFrame() {
        return this.gizmoFrame;
    }

    public static Mesh angularHighlightMesh(double majorRadius, double minorRadius) {
        return RDXPose3DGizmo.tetrahedronRingMesh(1.75 * minorRadius, 1.25 * minorRadius, 5);
    }

    public static Mesh linearControlHighlightMesh(double bodyRadius, double bodyLength, double spacing) {
        RDXMeshBuilder meshBuilder = new RDXMeshBuilder();
        int numberOfHighlights = 5;
        Point3D center = new Point3D(0.0, 0.0, 0.5 * spacing + 0.33 * bodyLength);
        MeshDataHolder ringMesh = RDXPose3DGizmo.tetrahedronRingMeshDataHolder(1.75 * bodyRadius, 1.25 * bodyRadius, numberOfHighlights);
        meshBuilder.addMesh(ringMesh, (Tuple3DReadOnly)center);
        center.negate();
        meshBuilder.addMesh(ringMesh, (Tuple3DReadOnly)center);
        return meshBuilder.generateMesh();
    }

    public static Mesh tetrahedronRingMesh(double ringRadius, double tetrahedronSize, int numberOfTetrahedrons) {
        return RDXMeshDataInterpreter.interpretMeshData(RDXPose3DGizmo.tetrahedronRingMeshDataHolder(ringRadius, tetrahedronSize, numberOfTetrahedrons));
    }

    public static MeshDataHolder tetrahedronRingMeshDataHolder(double ringRadius, double tetrahedronSize, int numberOfTetrahedrons) {
        RDXMeshBuilder meshBuilder = new RDXMeshBuilder();
        Point3D position = new Point3D();
        Point3D offset = new Point3D();
        Quaternion orientation = new Quaternion();
        for (int i = 0; i < numberOfTetrahedrons; ++i) {
            MeshDataHolder tetrahedron = MeshDataGenerator.Tetrahedron((double)tetrahedronSize);
            orientation.setToYawOrientation((double)i * 2.0 * Math.PI / (double)numberOfTetrahedrons);
            orientation.appendPitchRotation(1.5707963267948966);
            offset.set(0.0, 0.0, ringRadius);
            orientation.transform((Tuple3DBasics)offset);
            position.set(offset);
            meshBuilder.addMesh(tetrahedron, (Tuple3DReadOnly)position, (Orientation3DReadOnly)orientation);
        }
        return meshBuilder.generateMeshDataHolder();
    }

    private double getTranslateSpeedFactor() {
        return 0.5 * this.distanceToCamera;
    }

    public void setResizeAutomatically(boolean resizeAutomatically) {
        this.resizeAutomatically.set(resizeAutomatically);
    }

    ClockFaceRotation3DMouseDragAlgorithm getClockFaceDragAlgorithm() {
        return this.clockFaceDragAlgorithm;
    }

    public Notification getGizmoModifiedByUser() {
        return this.gizmoModifiedByUser;
    }
}

