/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.rdx.ui.gizmo;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g3d.Attribute;
import com.badlogic.gdx.graphics.g3d.Material;
import com.badlogic.gdx.graphics.g3d.Renderable;
import com.badlogic.gdx.graphics.g3d.RenderableProvider;
import com.badlogic.gdx.graphics.g3d.attributes.BlendingAttribute;
import com.badlogic.gdx.graphics.g3d.attributes.TextureAttribute;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Pool;
import imgui.internal.ImGui;
import imgui.type.ImFloat;
import java.util.Random;
import us.ihmc.commons.thread.Notification;
import us.ihmc.euclid.Axis3D;
import us.ihmc.euclid.axisAngle.interfaces.AxisAngleReadOnly;
import us.ihmc.euclid.geometry.interfaces.Line3DReadOnly;
import us.ihmc.euclid.geometry.interfaces.Pose3DReadOnly;
import us.ihmc.euclid.orientation.interfaces.Orientation3DBasics;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.FramePose3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameLine3DReadOnly;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformBasics;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.euclid.yawPitchRoll.YawPitchRoll;
import us.ihmc.rdx.RDXFocusBasedCamera;
import us.ihmc.rdx.imgui.ImGuiTools;
import us.ihmc.rdx.imgui.ImGuiUniqueLabelMap;
import us.ihmc.rdx.imgui.RDXPanel;
import us.ihmc.rdx.input.ImGui3DViewInput;
import us.ihmc.rdx.input.ImGui3DViewPickResult;
import us.ihmc.rdx.input.ImGuiMouseDragData;
import us.ihmc.rdx.mesh.RDXMultiColorMeshBuilder;
import us.ihmc.rdx.sceneManager.RDXSceneLevel;
import us.ihmc.rdx.tools.LibGDXTools;
import us.ihmc.rdx.ui.RDX3DPanel;
import us.ihmc.rdx.ui.RDXBaseUI;
import us.ihmc.rdx.ui.gizmo.DynamicLibGDXModel;
import us.ihmc.rdx.ui.gizmo.FrameBasedGizmoModification;
import us.ihmc.rdx.ui.gizmo.RDXGizmoTools;
import us.ihmc.rdx.ui.gizmo.RDXPathControlRingCollisionSelection;
import us.ihmc.rdx.vr.RDXVRContext;
import us.ihmc.rdx.vr.RDXVRDragData;
import us.ihmc.rdx.vr.RDXVRPickResult;
import us.ihmc.robotics.interaction.BoxRayIntersection;
import us.ihmc.robotics.interaction.ClockFaceRotation3DMouseDragAlgorithm;
import us.ihmc.robotics.interaction.DiscreteIsoscelesTriangularPrismRayIntersection;
import us.ihmc.robotics.interaction.HollowCylinderRayIntersection;
import us.ihmc.robotics.interaction.Plane3DMouseDragAlgorithm;
import us.ihmc.robotics.referenceFrames.ReferenceFrameMissingTools;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.robotics.robotSide.SideDependentList;

public class RDXPathControlRingGizmo
implements RenderableProvider {
    public static final Color DISC_COLOR = RDXGizmoTools.CENTER_DEFAULT_COLOR;
    public static final Color X_ARROW_COLOR = RDXGizmoTools.X_AXIS_DEFAULT_COLOR;
    public static final Color Y_ARROW_COLOR = RDXGizmoTools.Y_AXIS_DEFAULT_COLOR;
    private static final double QUARTER_TURN = 1.5707963267948966;
    private final ImGuiUniqueLabelMap labels = new ImGuiUniqueLabelMap(this.getClass());
    private final ImFloat discOuterRadius = new ImFloat(0.426f);
    private final ImFloat discInnerRadius = new ImFloat(0.29f);
    private final ImFloat discThickness = new ImFloat(0.03f);
    private final ImFloat arrowWidth = new ImFloat(0.257f);
    private final ImFloat arrowHeight = new ImFloat(0.137f);
    private final ImFloat arrowSpacing = new ImFloat(0.079f);
    private final ImFloat arrowTailWidthRatio = new ImFloat(0.5f);
    private final ImFloat arrowTailLengthRatio = new ImFloat(1.0f);
    private Material normalMaterial;
    private Material highlightedMaterial;
    private final DynamicLibGDXModel discModel = new DynamicLibGDXModel();
    private final DynamicLibGDXModel positiveXArrowModel = new DynamicLibGDXModel();
    private final DynamicLibGDXModel positiveYArrowModel = new DynamicLibGDXModel();
    private final DynamicLibGDXModel negativeXArrowModel = new DynamicLibGDXModel();
    private final DynamicLibGDXModel negativeYArrowModel = new DynamicLibGDXModel();
    private final RigidBodyTransform xArrowTailTransform = new RigidBodyTransform();
    private final RigidBodyTransform yArrowTailTransform = new RigidBodyTransform();
    private final RigidBodyTransform temporaryTailTransform = new RigidBodyTransform();
    private final Point3D closestCollision = new Point3D();
    private RDXPathControlRingCollisionSelection closestCollisionSelection = null;
    private double closestCollisionDistance;
    private final ImGui3DViewPickResult pickResult = new ImGui3DViewPickResult();
    private boolean isGizmoHovered = false;
    private boolean isBeingManipulated = false;
    private final HollowCylinderRayIntersection hollowCylinderIntersection = new HollowCylinderRayIntersection();
    private final DiscreteIsoscelesTriangularPrismRayIntersection positiveXArrowIntersection = new DiscreteIsoscelesTriangularPrismRayIntersection();
    private final DiscreteIsoscelesTriangularPrismRayIntersection positiveYArrowIntersection = new DiscreteIsoscelesTriangularPrismRayIntersection();
    private final BoxRayIntersection negativeXArrowIntersection = new BoxRayIntersection();
    private final BoxRayIntersection negativeYArrowIntersection = new BoxRayIntersection();
    private RigidBodyTransform transformToParent;
    private final FramePose3D framePose3D = new FramePose3D();
    private ReferenceFrame gizmoFrame;
    private final RigidBodyTransform transformToWorld = new RigidBodyTransform();
    private final Notification gizmoModifiedByUser = new Notification();
    private RDXFocusBasedCamera camera3D;
    private final Point3D cameraPosition = new Point3D();
    private double distanceToCamera;
    private final Plane3DMouseDragAlgorithm planeDragAlgorithm = new Plane3DMouseDragAlgorithm();
    private final ClockFaceRotation3DMouseDragAlgorithm clockFaceDragAlgorithm = new ClockFaceRotation3DMouseDragAlgorithm();
    private boolean showArrows = true;
    private boolean highlightingEnabled = true;
    private final double translateSpeedFactor = 0.5;
    private boolean queuePopupToOpen = false;
    private final Random random = new Random();
    private boolean proportionsNeedUpdate = false;
    private FrameBasedGizmoModification frameBasedGizmoModification;
    private final SideDependentList<RDXVRPickResult> vrPickResult = new SideDependentList(RDXVRPickResult::new);
    private final SideDependentList<Boolean> isGizmoHoveredVR = new SideDependentList((Object)false, (Object)false);
    private final SideDependentList<Boolean> isRingBeingDraggedVR = new SideDependentList((Object)false, (Object)false);
    private final SideDependentList<RDXPathControlRingCollisionSelection> closestVRCollisionSelection = new SideDependentList(null, null);

    public RDXPathControlRingGizmo() {
        this(ReferenceFrame.getWorldFrame());
    }

    public RDXPathControlRingGizmo(ReferenceFrame parentReferenceFrame) {
        RigidBodyTransform transformToParent = new RigidBodyTransform();
        ReferenceFrame gizmoFrame = ReferenceFrameMissingTools.constructFrameWithChangingTransformToParent((ReferenceFrame)parentReferenceFrame, (RigidBodyTransformReadOnly)transformToParent);
        this.initialize(gizmoFrame, transformToParent);
    }

    public RDXPathControlRingGizmo(ReferenceFrame gizmoFrame, RigidBodyTransform gizmoTransformToParentFrameToModify) {
        this.initialize(gizmoFrame, gizmoTransformToParentFrameToModify);
    }

    public RDXPathControlRingGizmo(RigidBodyTransform gizmoTransformToParentFrameToModify, ReferenceFrame parentReferenceFrame) {
        ReferenceFrame gizmoFrame = ReferenceFrameMissingTools.constructFrameWithChangingTransformToParent((ReferenceFrame)parentReferenceFrame, (RigidBodyTransformReadOnly)gizmoTransformToParentFrameToModify);
        this.initialize(gizmoFrame, gizmoTransformToParentFrameToModify);
    }

    private void initialize(ReferenceFrame gizmoFrame, RigidBodyTransform gizmoTransformToParentFrameToModify) {
        this.transformToParent = gizmoTransformToParentFrameToModify;
        this.gizmoFrame = gizmoFrame;
        RDXBaseUI.getInstance().getKeyBindings().register("Move control ring away from camera", "Up arrow");
        RDXBaseUI.getInstance().getKeyBindings().register("Move control ring toward from camera", "Down arrow");
        RDXBaseUI.getInstance().getKeyBindings().register("Move control ring left", "Left arrow");
        RDXBaseUI.getInstance().getKeyBindings().register("Move control ring right", "Right arrow");
        RDXBaseUI.getInstance().getKeyBindings().register("Drag control ring", "Left mouse");
        RDXBaseUI.getInstance().getKeyBindings().register("Drag control ring (yaw)", "Right mouse");
        RDXBaseUI.getInstance().getKeyBindings().register("Move control ring slowly", "Shift");
        for (RobotSide side : RobotSide.values) {
            ((RDXVRPickResult)this.vrPickResult.get((Enum)side)).setPickedObjectID(this, "Path Control Ring Gizmo");
        }
    }

    public void setGizmoFrame(ReferenceFrame gizmoFrame) {
        this.gizmoFrame = gizmoFrame;
    }

    public void setParentFrame(ReferenceFrame parentReferenceFrame) {
        this.gizmoFrame.remove();
        this.gizmoFrame = ReferenceFrameMissingTools.constructFrameWithChangingTransformToParent((ReferenceFrame)parentReferenceFrame, (RigidBodyTransformReadOnly)this.transformToParent);
    }

    public void createAndSetupDefault(RDXBaseUI baseUI) {
        this.create(baseUI.getPrimary3DPanel());
        baseUI.getVRManager().getContext().addVRPickCalculator(this::calculateVRPick);
        baseUI.getVRManager().getContext().addVRPickCalculator(this::processVRInput);
        baseUI.getPrimary3DPanel().addImGui3DViewPickCalculator(this::calculate3DViewPick);
        baseUI.getPrimary3DPanel().addImGui3DViewInputProcessor(this::process3DViewInput);
        baseUI.getPrimary3DPanel().getScene().addRenderableProvider(this, RDXSceneLevel.VIRTUAL);
    }

    public void create(RDX3DPanel panel3D) {
        this.camera3D = panel3D.getCamera3D();
        boolean yawOnly = true;
        this.frameBasedGizmoModification = new FrameBasedGizmoModification(this::getGizmoFrame, () -> this.gizmoFrame.getParent(), this.camera3D, yawOnly);
        panel3D.addImGuiOverlayAddition(this::renderTooltipAndContextMenu);
        this.normalMaterial = this.createAlphaPaletteMaterial(RDXGizmoTools.X_AXIS_DEFAULT_COLOR.a);
        this.highlightedMaterial = this.createAlphaPaletteMaterial(RDXGizmoTools.X_AXIS_SELECTED_DEFAULT_COLOR.a);
        this.discModel.setMesh(meshBuilder -> meshBuilder.addHollowCylinder(this.discThickness.get(), this.discOuterRadius.get(), this.discInnerRadius.get(), (Tuple3DReadOnly)new Point3D(0.0, 0.0, 0.0), DISC_COLOR));
        this.positiveXArrowModel.setMesh(meshBuilder -> meshBuilder.addIsoscelesTriangularPrism(this.arrowWidth.get(), this.arrowHeight.get(), this.discThickness.get(), (Tuple3DReadOnly)new Point3D((double)(this.discOuterRadius.get() + this.arrowSpacing.get()), 0.0, (double)this.discThickness.get() / 2.0), (Orientation3DReadOnly)new YawPitchRoll(-1.5707963267948966, 0.0, -1.5707963267948966), X_ARROW_COLOR));
        this.positiveYArrowModel.setMesh(meshBuilder -> meshBuilder.addIsoscelesTriangularPrism(this.arrowWidth.get(), this.arrowHeight.get(), this.discThickness.get(), (Tuple3DReadOnly)new Point3D(0.0, (double)(this.discOuterRadius.get() + this.arrowSpacing.get()), (double)this.discThickness.get() / 2.0), (Orientation3DReadOnly)new YawPitchRoll(0.0, 0.0, -1.5707963267948966), Y_ARROW_COLOR));
        this.negativeXArrowModel.setMesh(meshBuilder -> {
            float arrowLength = this.arrowTailLengthRatio.get() * this.arrowHeight.get();
            this.xArrowTailTransform.getTranslation().set((double)(-this.discOuterRadius.get() - this.arrowSpacing.get()) - (double)arrowLength / 2.0, 0.0, (double)this.discThickness.get() / 2.0);
            this.xArrowTailTransform.getRotation().setYawPitchRoll(1.5707963267948966, 0.0, 0.0);
            meshBuilder.addBox(this.arrowTailWidthRatio.get() * this.arrowWidth.get(), arrowLength, this.discThickness.get(), (Tuple3DReadOnly)this.xArrowTailTransform.getTranslation(), (Orientation3DReadOnly)this.xArrowTailTransform.getRotation(), X_ARROW_COLOR);
        });
        this.negativeYArrowModel.setMesh(meshBuilder -> {
            float arrowLength = this.arrowTailLengthRatio.get() * this.arrowHeight.get();
            this.yArrowTailTransform.getTranslation().set(0.0, (double)(-this.discOuterRadius.get() - this.arrowSpacing.get()) - (double)arrowLength / 2.0, (double)this.discThickness.get() / 2.0);
            this.yArrowTailTransform.getRotation().setYawPitchRoll(0.0, 0.0, 0.0);
            meshBuilder.addBox(this.arrowTailWidthRatio.get() * this.arrowWidth.get(), arrowLength, this.discThickness.get(), (Tuple3DReadOnly)this.yArrowTailTransform.getTranslation(), (Orientation3DReadOnly)this.yArrowTailTransform.getRotation(), Y_ARROW_COLOR);
        });
        this.recreateGraphics();
    }

    private Material createAlphaPaletteMaterial(float alpha) {
        Material material = new Material();
        material.set((Attribute)TextureAttribute.createDiffuse((Texture)RDXMultiColorMeshBuilder.loadPaletteTexture()));
        material.set((Attribute)new BlendingAttribute(true, alpha));
        return material;
    }

    public void calculateVRPick(RDXVRContext vrContext) {
        for (RobotSide side : RobotSide.values) {
            vrContext.getController(side).runIfConnected(controller -> {
                if (!controller.getTriggerDragData().isDraggingSomething()) {
                    FrameLine3DReadOnly pickRay = controller.getPickRay();
                    if (!((Boolean)this.isRingBeingDraggedVR.get((Enum)side.getOppositeSide())).booleanValue()) {
                        this.closestVRCollisionSelection.put((Enum)side, (Object)this.determineCurrentSelectionFromPickRay((Line3DReadOnly)pickRay));
                    }
                }
                if (this.closestVRCollisionSelection.get((Enum)side) != null) {
                    ((RDXVRPickResult)this.vrPickResult.get((Enum)side)).setPointingAtCollision(this.closestCollisionDistance);
                    controller.addPickResult((RDXVRPickResult)this.vrPickResult.get((Enum)side));
                }
            });
        }
    }

    private void calculateHovered(RDXVRContext vrContext) {
        for (RobotSide side : RobotSide.values) {
            this.isGizmoHoveredVR.put((Enum)side, (Object)(vrContext.getController(side).getSelectedPick() == this.vrPickResult.get((Enum)side) ? 1 : 0));
        }
    }

    public void processVRInput(RDXVRContext vrContext) {
        this.calculateHovered(vrContext);
        this.processVRInputModification(vrContext);
    }

    private void processVRInputModification(RDXVRContext vrContext) {
        for (RobotSide side : RobotSide.values) {
            vrContext.getController(side).runIfConnected(controller -> {
                RDXVRDragData triggerDragData = controller.getTriggerDragData();
                if (this.closestVRCollisionSelection.get((Enum)side) == RDXPathControlRingCollisionSelection.RING && triggerDragData.getDragJustStarted()) {
                    triggerDragData.setObjectBeingDragged(this);
                    triggerDragData.setZUpDragStart(this.gizmoFrame);
                }
                this.isRingBeingDraggedVR.put((Enum)side, (Object)triggerDragData.isBeingDragged(this));
                if (((Boolean)this.isRingBeingDraggedVR.get((Enum)side)).booleanValue()) {
                    FrameLine3DReadOnly pickRay = controller.getPickRay();
                    if (triggerDragData.isDraggingSomething() && this.closestVRCollisionSelection.get((Enum)side) == RDXPathControlRingCollisionSelection.RING) {
                        Vector3DReadOnly planarMotion = this.planeDragAlgorithm.calculate((Line3DReadOnly)pickRay, (Point3DReadOnly)this.closestCollision, (Vector3DReadOnly)Axis3D.Z);
                        this.frameBasedGizmoModification.translateInWorld(planarMotion);
                        this.closestCollision.add((Tuple3DReadOnly)planarMotion);
                        triggerDragData.updateZUpDrag(this.gizmoFrame);
                        double deltaYaw = triggerDragData.getZUpDragPose().getOrientation().getYaw() - this.gizmoFrame.getTransformToRoot().getRotation().getYaw();
                        this.frameBasedGizmoModification.yawInWorld(deltaYaw);
                    }
                    this.frameBasedGizmoModification.setAdjustmentNeedsToBeApplied();
                } else if (controller.getTriggerClickReleasedWithoutDrag()) {
                    if (this.closestVRCollisionSelection.get((Enum)side) == RDXPathControlRingCollisionSelection.NEGATIVE_X_ARROW) {
                        this.frameBasedGizmoModification.yawInWorld(Math.PI);
                    } else if (this.closestVRCollisionSelection.get((Enum)side) == RDXPathControlRingCollisionSelection.POSITIVE_Y_ARROW) {
                        this.frameBasedGizmoModification.yawInWorld(1.5707963267948966);
                    } else if (this.closestVRCollisionSelection.get((Enum)side) == RDXPathControlRingCollisionSelection.NEGATIVE_Y_ARROW) {
                        this.frameBasedGizmoModification.yawInWorld(-1.5707963267948966);
                    }
                    this.frameBasedGizmoModification.setAdjustmentNeedsToBeApplied();
                }
            });
        }
        this.update();
    }

    public void calculate3DViewPick(ImGui3DViewInput input) {
        boolean isWindowHovered = ImGui.isWindowHovered();
        ImGuiMouseDragData translateDragData = input.getMouseDragData(0);
        ImGuiMouseDragData yawDragData = input.getMouseDragData(1);
        if (isWindowHovered) {
            if (!translateDragData.isDragging() && !yawDragData.isDragging()) {
                Line3DReadOnly pickRay = input.getPickRayInWorld();
                this.closestCollisionSelection = this.determineCurrentSelectionFromPickRay(pickRay);
            }
            if (this.closestCollisionSelection != null) {
                this.pickResult.setDistanceToCamera(this.closestCollisionDistance);
                input.addPickResult(this.pickResult);
            }
        }
    }

    public void process3DViewInput(ImGui3DViewInput input) {
        this.calculateHovered(input);
        this.process3DViewInputModification(input);
    }

    void calculateHovered(ImGui3DViewInput input) {
        this.isGizmoHovered = input.isWindowHovered() && this.pickResult == input.getClosestPick();
    }

    void process3DViewInputModification(ImGui3DViewInput input) {
        boolean isRingHovered;
        boolean isWindowHovered = input.isWindowHovered();
        int yawMouseButton = 1;
        ImGuiMouseDragData translateDragData = input.getMouseDragData(0);
        ImGuiMouseDragData yawDragData = input.getMouseDragData(yawMouseButton);
        if (this.isGizmoHovered && input.mouseReleasedWithoutDrag(1)) {
            this.queuePopupToOpen = true;
        }
        boolean bl = isRingHovered = this.isGizmoHovered && this.closestCollisionSelection == RDXPathControlRingCollisionSelection.RING;
        if (isRingHovered) {
            if (yawDragData.getDragJustStarted()) {
                this.clockFaceDragAlgorithm.reset();
                yawDragData.setObjectBeingDragged(this);
            } else if (translateDragData.getDragJustStarted()) {
                translateDragData.setObjectBeingDragged(this);
            }
        }
        boolean bl2 = this.isBeingManipulated = translateDragData.isBeingDragged(this) || yawDragData.isBeingDragged(this);
        if (this.isBeingManipulated) {
            Line3DReadOnly pickRay = input.getPickRayInWorld();
            if (translateDragData.isDragging()) {
                Vector3DReadOnly planarMotion = this.planeDragAlgorithm.calculate(pickRay, (Point3DReadOnly)this.closestCollision, (Vector3DReadOnly)Axis3D.Z);
                this.frameBasedGizmoModification.translateInWorld(planarMotion);
                this.closestCollision.add((Tuple3DReadOnly)planarMotion);
            } else if (this.clockFaceDragAlgorithm.calculate(pickRay, this.closestCollision, (Vector3DReadOnly)Axis3D.Z, (RigidBodyTransformReadOnly)this.transformToWorld)) {
                this.frameBasedGizmoModification.rotateInWorld((AxisAngleReadOnly)this.clockFaceDragAlgorithm.getMotion());
            }
        }
        if (isWindowHovered) {
            boolean anyArrowHeld;
            if (ImGui.getIO().getKeyCtrl() && input.getMouseWheelDelta() != 0.0f) {
                float deltaScroll = input.getMouseWheelDelta();
                double noise = this.random.nextDouble() * 0.005;
                double speed = 0.012 + noise;
                this.frameBasedGizmoModification.yawInWorld((double)Math.signum(deltaScroll) * speed * Math.PI);
            }
            boolean upArrowHeld = ImGui.isKeyDown((int)ImGuiTools.getUpArrowKey());
            boolean downArrowHeld = ImGui.isKeyDown((int)ImGuiTools.getDownArrowKey());
            boolean leftArrowHeld = ImGui.isKeyDown((int)ImGuiTools.getLeftArrowKey());
            boolean rightArrowHeld = ImGui.isKeyDown((int)ImGuiTools.getRightArrowKey());
            boolean bl3 = anyArrowHeld = upArrowHeld || downArrowHeld || leftArrowHeld || rightArrowHeld;
            if (anyArrowHeld) {
                boolean ctrlHeld = ImGui.getIO().getKeyCtrl();
                boolean altHeld = ImGui.getIO().getKeyAlt();
                boolean shiftHeld = ImGui.getIO().getKeyShift();
                double deltaTime = Gdx.graphics.getDeltaTime();
                if (altHeld) {
                    double amount = deltaTime * (shiftHeld ? 0.2 : 1.0);
                    Orientation3DBasics orientationToAdjust = this.frameBasedGizmoModification.beforeForRotationAdjustment();
                    if (leftArrowHeld) {
                        orientationToAdjust.appendYawRotation(amount);
                    }
                    if (rightArrowHeld) {
                        orientationToAdjust.appendYawRotation(-amount);
                    }
                    this.frameBasedGizmoModification.afterRotationAdjustment(true);
                } else {
                    double amount = deltaTime * (shiftHeld ? 0.05 : 0.4);
                    Point3DBasics positionToAdjust = this.frameBasedGizmoModification.beforeForTranslationAdjustment();
                    if (upArrowHeld && !ctrlHeld) {
                        positionToAdjust.addX(this.getTranslateSpeedFactor() * amount);
                    }
                    if (downArrowHeld && !ctrlHeld) {
                        positionToAdjust.subX(this.getTranslateSpeedFactor() * amount);
                    }
                    if (leftArrowHeld) {
                        positionToAdjust.addY(this.getTranslateSpeedFactor() * amount);
                    }
                    if (rightArrowHeld) {
                        positionToAdjust.subY(this.getTranslateSpeedFactor() * amount);
                    }
                    if (upArrowHeld && ctrlHeld) {
                        positionToAdjust.addZ(this.getTranslateSpeedFactor() * amount);
                    }
                    if (downArrowHeld && ctrlHeld) {
                        positionToAdjust.subZ(this.getTranslateSpeedFactor() * amount);
                    }
                }
                this.frameBasedGizmoModification.setAdjustmentNeedsToBeApplied();
            }
        }
        this.update();
    }

    private void renderTooltipAndContextMenu() {
        if (this.queuePopupToOpen) {
            this.queuePopupToOpen = false;
            ImGui.openPopup((String)this.labels.get("Popup"));
        }
        if (ImGui.beginPopup((String)this.labels.get("Popup"))) {
            this.renderImGuiTuner();
            if (ImGui.menuItem((String)"Close")) {
                ImGui.closeCurrentPopup();
            }
            ImGui.endPopup();
        }
    }

    public void update() {
        if (this.frameBasedGizmoModification.applyAdjustmentIfNeeded(this.transformToParent)) {
            this.gizmoModifiedByUser.set();
        }
        this.gizmoFrame.update();
        this.frameBasedGizmoModification.setToZeroGizmoFrame();
        this.framePose3D.setToZero(this.gizmoFrame);
        this.framePose3D.changeFrame(ReferenceFrame.getWorldFrame());
        this.framePose3D.get((RigidBodyTransformBasics)this.transformToWorld);
        this.updateGraphicTransforms();
        LibGDXTools.toEuclid(this.camera3D.position, (Point3DBasics)this.cameraPosition);
        this.distanceToCamera = this.cameraPosition.distance((Point3DReadOnly)this.framePose3D.getPosition());
        if (this.proportionsNeedUpdate) {
            this.proportionsNeedUpdate = false;
            this.recreateGraphics();
        }
    }

    private void updateGraphicTransforms() {
        LibGDXTools.toLibGDX(this.transformToWorld, this.discModel.getOrCreateModelInstance().transform);
        LibGDXTools.toLibGDX(this.transformToWorld, this.positiveXArrowModel.getOrCreateModelInstance().transform);
        LibGDXTools.toLibGDX(this.transformToWorld, this.positiveYArrowModel.getOrCreateModelInstance().transform);
        LibGDXTools.toLibGDX(this.transformToWorld, this.negativeXArrowModel.getOrCreateModelInstance().transform);
        LibGDXTools.toLibGDX(this.transformToWorld, this.negativeYArrowModel.getOrCreateModelInstance().transform);
    }

    private RDXPathControlRingCollisionSelection determineCurrentSelectionFromPickRay(Line3DReadOnly pickRay) {
        RDXPathControlRingCollisionSelection closestCollisionSelection = null;
        this.closestCollisionDistance = Double.POSITIVE_INFINITY;
        this.hollowCylinderIntersection.update((double)this.discThickness.get(), (double)this.discOuterRadius.get(), (double)this.discInnerRadius.get(), (double)this.discThickness.get() / 2.0, (RigidBodyTransformReadOnly)this.transformToWorld);
        double distance = this.hollowCylinderIntersection.intersect(pickRay);
        if (!Double.isNaN(distance) && distance < this.closestCollisionDistance) {
            this.closestCollisionDistance = distance;
            closestCollisionSelection = RDXPathControlRingCollisionSelection.RING;
            this.closestCollision.set(this.hollowCylinderIntersection.getClosestIntersection());
        }
        if (this.showArrows) {
            this.positiveXArrowIntersection.update((double)this.arrowWidth.get(), (double)this.arrowHeight.get(), (double)this.discThickness.get(), (Tuple3DReadOnly)new Point3D((double)(this.discOuterRadius.get() + this.arrowSpacing.get()), 0.0, (double)this.discThickness.get() / 2.0), (Orientation3DReadOnly)new YawPitchRoll(-1.5707963267948966, 0.0, -1.5707963267948966), (RigidBodyTransformReadOnly)this.transformToWorld);
            distance = this.positiveXArrowIntersection.intersect(pickRay, 100);
            if (!Double.isNaN(distance) && distance < this.closestCollisionDistance) {
                this.closestCollisionDistance = distance;
                closestCollisionSelection = RDXPathControlRingCollisionSelection.POSITIVE_X_ARROW;
                this.closestCollision.set(this.positiveXArrowIntersection.getClosestIntersection());
            }
            this.positiveYArrowIntersection.update((double)this.arrowWidth.get(), (double)this.arrowHeight.get(), (double)this.discThickness.get(), (Tuple3DReadOnly)new Point3D(0.0, (double)(this.discOuterRadius.get() + this.arrowSpacing.get()), (double)this.discThickness.get() / 2.0), (Orientation3DReadOnly)new YawPitchRoll(0.0, 0.0, -1.5707963267948966), (RigidBodyTransformReadOnly)this.transformToWorld);
            distance = this.positiveYArrowIntersection.intersect(pickRay, 100);
            if (!Double.isNaN(distance) && distance < this.closestCollisionDistance) {
                this.closestCollisionDistance = distance;
                closestCollisionSelection = RDXPathControlRingCollisionSelection.POSITIVE_Y_ARROW;
                this.closestCollision.set(this.positiveYArrowIntersection.getClosestIntersection());
            }
            this.temporaryTailTransform.set(this.xArrowTailTransform);
            this.transformToWorld.transform((RigidBodyTransformBasics)this.temporaryTailTransform);
            boolean intersects = this.negativeXArrowIntersection.intersect((double)(this.arrowTailWidthRatio.get() * this.arrowWidth.get()), (double)(this.arrowTailLengthRatio.get() * this.arrowHeight.get()), (double)this.discThickness.get(), this.temporaryTailTransform, pickRay);
            distance = this.negativeXArrowIntersection.getFirstIntersectionToPack().distance(pickRay.getPoint());
            if (intersects && distance < this.closestCollisionDistance) {
                this.closestCollisionDistance = distance;
                closestCollisionSelection = RDXPathControlRingCollisionSelection.NEGATIVE_X_ARROW;
                this.closestCollision.set((Tuple3DReadOnly)this.negativeXArrowIntersection.getFirstIntersectionToPack());
            }
            this.temporaryTailTransform.set(this.yArrowTailTransform);
            this.transformToWorld.transform((RigidBodyTransformBasics)this.temporaryTailTransform);
            intersects = this.negativeYArrowIntersection.intersect((double)(this.arrowTailWidthRatio.get() * this.arrowWidth.get()), (double)(this.arrowTailLengthRatio.get() * this.arrowHeight.get()), (double)this.discThickness.get(), this.temporaryTailTransform, pickRay);
            distance = this.negativeYArrowIntersection.getFirstIntersectionToPack().distance(pickRay.getPoint());
            if (intersects && distance < this.closestCollisionDistance) {
                this.closestCollisionDistance = distance;
                closestCollisionSelection = RDXPathControlRingCollisionSelection.NEGATIVE_Y_ARROW;
                this.closestCollision.set((Tuple3DReadOnly)this.negativeYArrowIntersection.getFirstIntersectionToPack());
            }
        }
        this.updateMaterialHighlighting();
        return closestCollisionSelection;
    }

    private void updateMaterialHighlighting() {
        boolean gizmoHoveredByVR = (Boolean)this.isGizmoHoveredVR.get((Enum)RobotSide.LEFT) != false || (Boolean)this.isGizmoHoveredVR.get((Enum)RobotSide.RIGHT) != false;
        boolean gizmoHoveredByAnything = this.isGizmoHovered || gizmoHoveredByVR;
        boolean highlightingPrior = this.highlightingEnabled && gizmoHoveredByAnything;
        this.discModel.setMaterial(highlightingPrior && (this.closestCollisionSelection == RDXPathControlRingCollisionSelection.RING || this.closestVRCollisionSelection.get((Enum)RobotSide.LEFT) == RDXPathControlRingCollisionSelection.RING || this.closestVRCollisionSelection.get((Enum)RobotSide.RIGHT) == RDXPathControlRingCollisionSelection.RING) ? this.highlightedMaterial : this.normalMaterial);
        this.positiveXArrowModel.setMaterial(highlightingPrior && (this.closestCollisionSelection == RDXPathControlRingCollisionSelection.POSITIVE_X_ARROW || this.closestVRCollisionSelection.get((Enum)RobotSide.LEFT) == RDXPathControlRingCollisionSelection.POSITIVE_X_ARROW || this.closestVRCollisionSelection.get((Enum)RobotSide.RIGHT) == RDXPathControlRingCollisionSelection.POSITIVE_X_ARROW) ? this.highlightedMaterial : this.normalMaterial);
        this.positiveYArrowModel.setMaterial(highlightingPrior && (this.closestCollisionSelection == RDXPathControlRingCollisionSelection.POSITIVE_Y_ARROW || this.closestVRCollisionSelection.get((Enum)RobotSide.LEFT) == RDXPathControlRingCollisionSelection.POSITIVE_Y_ARROW || this.closestVRCollisionSelection.get((Enum)RobotSide.RIGHT) == RDXPathControlRingCollisionSelection.POSITIVE_Y_ARROW) ? this.highlightedMaterial : this.normalMaterial);
        this.negativeXArrowModel.setMaterial(highlightingPrior && (this.closestCollisionSelection == RDXPathControlRingCollisionSelection.NEGATIVE_X_ARROW || this.closestVRCollisionSelection.get((Enum)RobotSide.LEFT) == RDXPathControlRingCollisionSelection.NEGATIVE_X_ARROW || this.closestVRCollisionSelection.get((Enum)RobotSide.RIGHT) == RDXPathControlRingCollisionSelection.NEGATIVE_X_ARROW) ? this.highlightedMaterial : this.normalMaterial);
        this.negativeYArrowModel.setMaterial(highlightingPrior && (this.closestCollisionSelection == RDXPathControlRingCollisionSelection.NEGATIVE_Y_ARROW || this.closestVRCollisionSelection.get((Enum)RobotSide.LEFT) == RDXPathControlRingCollisionSelection.NEGATIVE_Y_ARROW || this.closestVRCollisionSelection.get((Enum)RobotSide.RIGHT) == RDXPathControlRingCollisionSelection.NEGATIVE_Y_ARROW) ? this.highlightedMaterial : this.normalMaterial);
    }

    public RDXPanel createTunerPanel(String name) {
        return new RDXPanel("Footstep Ring Gizmo Tuner (" + name + ")", this::renderImGuiTuner);
    }

    public void renderImGuiTuner() {
        this.frameBasedGizmoModification.renderImGuiTunerWidgets();
        if (ImGui.collapsingHeader((String)this.labels.get("Controls"))) {
            ImGui.text((String)"Use the left mouse drag on the ring to move the gizmo around on its X-Y plane.");
            ImGui.text((String)"Use the right mouse drag on the ring to adjust the yaw.");
        }
        if (ImGui.button((String)this.labels.get("Reset"))) {
            this.transformToParent.setToZero();
        }
        if (ImGui.collapsingHeader((String)this.labels.get("Visual options"))) {
            ImGui.pushItemWidth((float)100.0f);
            this.proportionsNeedUpdate |= ImGui.dragFloat((String)this.labels.get("Disc outer radius"), (float[])this.discOuterRadius.getData(), (float)0.001f, (float)0.0f, (float)1000.0f);
            this.proportionsNeedUpdate |= ImGui.dragFloat((String)this.labels.get("Disc inner radius"), (float[])this.discInnerRadius.getData(), (float)0.001f, (float)0.0f, (float)1000.0f);
            this.proportionsNeedUpdate |= ImGui.dragFloat((String)this.labels.get("Disc thickness"), (float[])this.discThickness.getData(), (float)0.001f, (float)0.0f, (float)1000.0f);
            this.proportionsNeedUpdate |= ImGui.dragFloat((String)this.labels.get("Arrow width"), (float[])this.arrowWidth.getData(), (float)0.001f, (float)0.0f, (float)1000.0f);
            this.proportionsNeedUpdate |= ImGui.dragFloat((String)this.labels.get("Arrow height"), (float[])this.arrowHeight.getData(), (float)0.001f, (float)0.0f, (float)1000.0f);
            this.proportionsNeedUpdate |= ImGui.dragFloat((String)this.labels.get("Arrow spacing"), (float[])this.arrowSpacing.getData(), (float)0.001f, (float)0.0f, (float)1000.0f);
            this.proportionsNeedUpdate |= ImGui.dragFloat((String)this.labels.get("Arrow tail width ratio"), (float[])this.arrowTailWidthRatio.getData(), (float)0.001f, (float)0.0f, (float)1000.0f);
            this.proportionsNeedUpdate |= ImGui.dragFloat((String)this.labels.get("Arrow tail length ratio"), (float[])this.arrowTailLengthRatio.getData(), (float)0.001f, (float)0.0f, (float)1000.0f);
            ImGui.popItemWidth();
        }
    }

    private void recreateGraphics() {
        this.updateMaterialHighlighting();
        this.discModel.invalidateMesh();
        this.positiveXArrowModel.invalidateMesh();
        this.positiveYArrowModel.invalidateMesh();
        this.negativeXArrowModel.invalidateMesh();
        this.negativeYArrowModel.invalidateMesh();
        this.updateGraphicTransforms();
    }

    public void getRenderables(Array<Renderable> renderables, Pool<Renderable> pool) {
        this.discModel.getOrCreateModelInstance().getRenderables(renderables, pool);
        if (this.showArrows) {
            this.positiveXArrowModel.getOrCreateModelInstance().getRenderables(renderables, pool);
            this.positiveYArrowModel.getOrCreateModelInstance().getRenderables(renderables, pool);
            this.negativeXArrowModel.getOrCreateModelInstance().getRenderables(renderables, pool);
            this.negativeYArrowModel.getOrCreateModelInstance().getRenderables(renderables, pool);
        }
    }

    public Pose3DReadOnly getPose3D() {
        return this.framePose3D;
    }

    public RigidBodyTransform getTransformToParent() {
        return this.transformToParent;
    }

    public ReferenceFrame getGizmoFrame() {
        return this.gizmoFrame;
    }

    public boolean getAnyPartHovered() {
        return this.isGizmoHovered;
    }

    public boolean getAnyArrowHovered() {
        boolean anyArrowHovered = this.closestCollisionSelection == RDXPathControlRingCollisionSelection.POSITIVE_X_ARROW;
        anyArrowHovered |= this.closestCollisionSelection == RDXPathControlRingCollisionSelection.POSITIVE_Y_ARROW;
        anyArrowHovered |= this.closestCollisionSelection == RDXPathControlRingCollisionSelection.NEGATIVE_X_ARROW;
        return this.isGizmoHovered && (anyArrowHovered |= this.closestCollisionSelection == RDXPathControlRingCollisionSelection.NEGATIVE_Y_ARROW);
    }

    public boolean getRingHovered() {
        return this.isGizmoHovered && this.closestCollisionSelection == RDXPathControlRingCollisionSelection.RING;
    }

    public boolean getPositiveXArrowHovered() {
        return this.isGizmoHovered && this.closestCollisionSelection == RDXPathControlRingCollisionSelection.POSITIVE_X_ARROW || (Boolean)this.isGizmoHoveredVR.get((Enum)RobotSide.LEFT) != false && this.closestVRCollisionSelection.get((Enum)RobotSide.LEFT) == RDXPathControlRingCollisionSelection.POSITIVE_X_ARROW || (Boolean)this.isGizmoHoveredVR.get((Enum)RobotSide.RIGHT) != false && this.closestVRCollisionSelection.get((Enum)RobotSide.RIGHT) == RDXPathControlRingCollisionSelection.POSITIVE_X_ARROW;
    }

    public boolean getPositiveYArrowHovered() {
        return this.isGizmoHovered && this.closestCollisionSelection == RDXPathControlRingCollisionSelection.POSITIVE_Y_ARROW || (Boolean)this.isGizmoHoveredVR.get((Enum)RobotSide.LEFT) != false && this.closestVRCollisionSelection.get((Enum)RobotSide.LEFT) == RDXPathControlRingCollisionSelection.POSITIVE_Y_ARROW || (Boolean)this.isGizmoHoveredVR.get((Enum)RobotSide.RIGHT) != false && this.closestVRCollisionSelection.get((Enum)RobotSide.RIGHT) == RDXPathControlRingCollisionSelection.POSITIVE_Y_ARROW;
    }

    public boolean getNegativeXArrowHovered() {
        return this.isGizmoHovered && this.closestCollisionSelection == RDXPathControlRingCollisionSelection.NEGATIVE_X_ARROW || (Boolean)this.isGizmoHoveredVR.get((Enum)RobotSide.LEFT) != false && this.closestVRCollisionSelection.get((Enum)RobotSide.LEFT) == RDXPathControlRingCollisionSelection.NEGATIVE_X_ARROW || (Boolean)this.isGizmoHoveredVR.get((Enum)RobotSide.RIGHT) != false && this.closestVRCollisionSelection.get((Enum)RobotSide.RIGHT) == RDXPathControlRingCollisionSelection.NEGATIVE_X_ARROW;
    }

    public boolean getNegativeYArrowHovered() {
        return this.isGizmoHovered && this.closestCollisionSelection == RDXPathControlRingCollisionSelection.NEGATIVE_Y_ARROW || (Boolean)this.isGizmoHoveredVR.get((Enum)RobotSide.LEFT) != false && this.closestVRCollisionSelection.get((Enum)RobotSide.LEFT) == RDXPathControlRingCollisionSelection.NEGATIVE_Y_ARROW || (Boolean)this.isGizmoHoveredVR.get((Enum)RobotSide.RIGHT) != false && this.closestVRCollisionSelection.get((Enum)RobotSide.RIGHT) == RDXPathControlRingCollisionSelection.NEGATIVE_Y_ARROW;
    }

    public void setShowArrows(boolean showArrows) {
        this.showArrows = showArrows;
    }

    private double getTranslateSpeedFactor() {
        return 0.5 * this.distanceToCamera;
    }

    public void setHighlightingEnabled(boolean highlightingEnabled) {
        this.highlightingEnabled = highlightingEnabled;
    }

    public Notification getGizmoModifiedByUser() {
        return this.gizmoModifiedByUser;
    }

    public SideDependentList<Boolean> getIsRingBeingDraggedVR() {
        return this.isRingBeingDraggedVR;
    }

    public SideDependentList<Boolean> getIsGizmoHoveredVR() {
        return this.isGizmoHoveredVR;
    }
}

