/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.rdx.ui;

import imgui.ImGui;
import imgui.type.ImString;
import java.nio.file.FileVisitResult;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.TreeSet;
import java.util.function.Consumer;
import java.util.function.Function;
import us.ihmc.commons.nio.BasicPathVisitor;
import us.ihmc.commons.nio.PathTools;
import us.ihmc.commons.nio.PathVisitor;
import us.ihmc.log.LogTools;
import us.ihmc.rdx.imgui.ImGuiTools;
import us.ihmc.rdx.imgui.ImGuiUniqueLabelMap;
import us.ihmc.rdx.ui.ImGuiConfigurationLocation;
import us.ihmc.tools.io.HybridResourceDirectory;
import us.ihmc.tools.io.HybridResourceMode;

public class RDXImGuiLayoutManager {
    private final Path dotIHMCDirectory = Paths.get(System.getProperty("user.home"), ".ihmc");
    private final Class<?> classForLoading;
    private final String configurationExtraPath;
    private final HybridResourceDirectory configurationBaseDirectory;
    private final ArrayList<Consumer<HybridResourceDirectory>> layoutDirectoryUpdatedListeners = new ArrayList();
    private final ArrayList<Function<ImGuiConfigurationLocation, Boolean>> loadListeners = new ArrayList();
    private final ArrayList<Consumer<ImGuiConfigurationLocation>> saveListeners = new ArrayList();
    private HybridResourceDirectory layoutDirectory;
    private boolean needToReindexLayouts = false;
    private boolean firstIndex = true;
    private boolean layoutHasBeenLoadedOnce = false;
    private final ImGuiUniqueLabelMap labels = new ImGuiUniqueLabelMap(this.getClass());
    private final ImString userHomeLayoutNameToSave = new ImString(100);
    private final ImString versionControlLayoutNameToSave = new ImString(100);
    private final TreeSet<String> userHomeLayouts = new TreeSet<String>(Comparator.comparing(String::toString));
    private final TreeSet<String> versionControlLayouts = new TreeSet<String>(Comparator.comparing(String::toString));
    private String currentLayoutName = "Main";
    private ImGuiConfigurationLocation currentConfigurationLocation;

    public RDXImGuiLayoutManager(Class<?> classForLoading, String configurationExtraPath, HybridResourceDirectory configurationBaseDirectory) {
        this.classForLoading = classForLoading;
        this.configurationExtraPath = configurationExtraPath;
        this.configurationBaseDirectory = configurationBaseDirectory;
        this.indexLayouts();
    }

    public void renderImGuiLayoutMenu() {
        if (this.needToReindexLayouts) {
            this.needToReindexLayouts = false;
            this.indexLayouts();
        }
        if (ImGui.beginMenu((String)this.labels.get("Layout"))) {
            ImGui.text((String)"Version control:");
            this.renderLayoutManager(this.versionControlLayouts, ImGuiConfigurationLocation.VERSION_CONTROL, this.versionControlLayoutNameToSave);
            ImGui.separator();
            ImGui.text((String)"User home:");
            this.renderLayoutManager(this.userHomeLayouts, ImGuiConfigurationLocation.USER_HOME, this.userHomeLayoutNameToSave);
            ImGui.separator();
            if (ImGui.button((String)this.labels.get("Reindex directories"))) {
                this.needToReindexLayouts = true;
            }
            ImGui.endMenu();
        }
    }

    private void indexLayouts() {
        this.indexLayouts(this.versionControlLayouts, HybridResourceMode.WORKSPACE, true);
        this.indexLayouts(this.userHomeLayouts, HybridResourceMode.EXTERNAL, false);
        if (this.firstIndex) {
            this.firstIndex = false;
            if (this.versionControlLayouts.contains("Main")) {
                this.currentConfigurationLocation = ImGuiConfigurationLocation.VERSION_CONTROL;
            }
            if (this.userHomeLayouts.contains("Main")) {
                this.currentConfigurationLocation = ImGuiConfigurationLocation.USER_HOME;
            }
        }
    }

    private void indexLayouts(TreeSet<String> layouts, HybridResourceMode resourceMode, boolean addMainEvenIfItsNotThere) {
        layouts.clear();
        if (addMainEvenIfItsNotThere) {
            layouts.add("Main");
        }
        final TreeSet fileNames = new TreeSet();
        final TreeSet directoryNames = new TreeSet();
        if (resourceMode == HybridResourceMode.WORKSPACE) {
            this.configurationBaseDirectory.walkResourcesFlat((path, pathType) -> {
                if (pathType == BasicPathVisitor.PathType.DIRECTORY) {
                    directoryNames.add(path);
                } else {
                    fileNames.add(path);
                }
            });
        } else {
            PathTools.walkFlat((Path)this.configurationBaseDirectory.getExternalDirectory(), (PathVisitor)new BasicPathVisitor(){

                public FileVisitResult visitPath(Path path, BasicPathVisitor.PathType pathType) {
                    if (pathType == BasicPathVisitor.PathType.FILE) {
                        String fileName = path.getFileName().toString();
                        fileNames.add(fileName);
                    }
                    if (pathType == BasicPathVisitor.PathType.DIRECTORY) {
                        String directoryName = path.getFileName().toString();
                        directoryNames.add(directoryName);
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        for (String fileName : fileNames) {
            if (!fileName.equals("ImGuiSettings.ini")) continue;
            layouts.add("Main");
        }
        for (String directoryName : directoryNames) {
            String matchString;
            if (!directoryName.endsWith(matchString = "Layout")) continue;
            String layoutName = directoryName.substring(0, directoryName.lastIndexOf(matchString));
            LogTools.info((String)"Found layout {}", (Object)layoutName);
            layouts.add(layoutName);
        }
    }

    private void renderLayoutManager(TreeSet<String> layouts, ImGuiConfigurationLocation configurationLocation, ImString layoutNameToSave) {
        boolean enableSaving = configurationLocation.isUserHome() || configurationLocation.isVersionControl() && this.configurationBaseDirectory.isWorkspaceFileAccessAvailable();
        for (String layout : layouts) {
            if (ImGui.radioButton((String)this.labels.get(layout, configurationLocation.name()), (this.currentLayoutName.equals(layout) && this.currentConfigurationLocation == configurationLocation ? 1 : 0) != 0)) {
                this.currentLayoutName = layout;
                this.currentConfigurationLocation = configurationLocation;
                this.applyLayoutDirectory();
                this.loadConfiguration(configurationLocation);
            }
            if (!enableSaving || !this.currentLayoutName.equals(layout)) continue;
            ImGui.sameLine();
            if (!ImGui.button((String)this.labels.get("Save", configurationLocation.name(), 0))) continue;
            for (Consumer<ImGuiConfigurationLocation> saveListener : this.saveListeners) {
                saveListener.accept(configurationLocation);
            }
        }
        if (enableSaving) {
            ImGui.text((String)"Save as:");
            ImGui.sameLine();
            String layoutNameToCreateString = layoutNameToSave.get();
            boolean renderSaveButton = layoutNameToCreateString.isEmpty();
            ImGui.setNextItemWidth((float)(renderSaveButton ? 190.0f : 150.0f));
            boolean saveRequested = ImGuiTools.inputText(this.labels.getHidden("NewSaveName" + configurationLocation.name()), layoutNameToSave);
            ImGuiTools.previousWidgetTooltip("A PascalCased name is recommended.\nPress Enter to save.");
            layoutNameToCreateString = layoutNameToSave.get();
            if (!renderSaveButton) {
                ImGui.sameLine();
                if (saveRequested |= ImGui.button((String)this.labels.get("Save", configurationLocation.name(), 1))) {
                    String sanitizedName = layoutNameToCreateString.replaceAll(" ", "");
                    layouts.add(sanitizedName);
                    this.currentLayoutName = sanitizedName;
                    this.applyLayoutDirectory();
                    layoutNameToSave.clear();
                    for (Consumer<ImGuiConfigurationLocation> saveListener : this.saveListeners) {
                        saveListener.accept(configurationLocation);
                    }
                }
            }
        }
    }

    private void loadConfiguration(ImGuiConfigurationLocation configurationLocation) {
        boolean success = true;
        for (Function<ImGuiConfigurationLocation, Boolean> loadListener : this.loadListeners) {
            success &= loadListener.apply(configurationLocation).booleanValue();
        }
        if (!success && configurationLocation.isVersionControl()) {
            LogTools.warn((String)"Layout configuration file(s) not found. If you just created this layout, try building in the IDE to copy the resources to a classpath directory.");
        }
    }

    public void applyLayoutDirectory() {
        this.layoutDirectory = new HybridResourceDirectory(this.dotIHMCDirectory, this.classForLoading, "/");
        this.layoutDirectory = this.layoutDirectory.resolve(this.configurationExtraPath);
        if (!this.currentLayoutName.equals("Main")) {
            this.layoutDirectory = this.layoutDirectory.resolve(this.currentLayoutName + "Layout");
        }
        for (Consumer<HybridResourceDirectory> layoutDirectoryUpdatedListener : this.layoutDirectoryUpdatedListeners) {
            layoutDirectoryUpdatedListener.accept(this.layoutDirectory);
        }
    }

    public void loadInitialLayout() {
        if (!this.layoutHasBeenLoadedOnce) {
            this.layoutHasBeenLoadedOnce = true;
            LogTools.info((int)1, (Object)"Loading layout.");
            this.reloadLayoutInternal();
        }
    }

    public void reloadLayout() {
        if (this.layoutHasBeenLoadedOnce) {
            LogTools.info((int)1, (Object)"Reloading layout.");
            this.reloadLayoutInternal();
        }
    }

    private void reloadLayoutInternal() {
        this.applyLayoutDirectory();
        this.loadConfiguration(this.currentConfigurationLocation);
    }

    public ImGuiConfigurationLocation getCurrentConfigurationLocation() {
        return this.currentConfigurationLocation;
    }

    public HybridResourceDirectory getLayoutDirectory() {
        return this.layoutDirectory;
    }

    public ArrayList<Consumer<HybridResourceDirectory>> getLayoutDirectoryUpdatedListeners() {
        return this.layoutDirectoryUpdatedListeners;
    }

    public ArrayList<Consumer<ImGuiConfigurationLocation>> getSaveListeners() {
        return this.saveListeners;
    }

    public ArrayList<Function<ImGuiConfigurationLocation, Boolean>> getLoadListeners() {
        return this.loadListeners;
    }
}

