/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.rdx.tools.assimp;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.g3d.Model;
import com.badlogic.gdx.graphics.g3d.model.data.ModelData;
import com.badlogic.gdx.graphics.g3d.model.data.ModelMaterial;
import com.badlogic.gdx.graphics.g3d.model.data.ModelMesh;
import com.badlogic.gdx.graphics.g3d.utils.TextureProvider;
import java.util.ArrayList;
import org.lwjgl.PointerBuffer;
import org.lwjgl.assimp.AIMaterial;
import org.lwjgl.assimp.AIMesh;
import org.lwjgl.assimp.AINode;
import org.lwjgl.assimp.AIPropertyStore;
import org.lwjgl.assimp.AIScene;
import org.lwjgl.assimp.Assimp;
import org.lwjgl.system.MemoryUtil;
import us.ihmc.log.LogTools;
import us.ihmc.rdx.tools.assimp.AssimpResourceImporter;
import us.ihmc.rdx.tools.assimp.RDXAssimpMaterialLoader;
import us.ihmc.rdx.tools.assimp.RDXAssimpMeshLoader;
import us.ihmc.rdx.tools.assimp.RDXAssimpNodeLoader;

public class RDXAssimpModelLoader {
    private final String basePath;
    private final AssimpResourceImporter assimpResourceImporter = new AssimpResourceImporter();
    private final String modelFilePath;

    public RDXAssimpModelLoader(String modelFilePath) {
        this.modelFilePath = modelFilePath;
        FileHandle fileHandle = Gdx.files.internal(modelFilePath);
        this.basePath = fileHandle.parent().path();
    }

    public Model load() {
        TextureProvider.FileTextureProvider textureProvider = new TextureProvider.FileTextureProvider();
        ModelData modelData = this.loadModelData();
        Model model = new Model(modelData, (TextureProvider)textureProvider);
        return model;
    }

    public ModelData loadModelData() {
        AIPropertyStore assimpPropertyStore = Assimp.aiCreatePropertyStore();
        int postProcessingSteps = 0;
        postProcessingSteps += 0x800000;
        postProcessingSteps += 8;
        Assimp.aiSetImportPropertyInteger((AIPropertyStore)assimpPropertyStore, (CharSequence)"PP_SLM_VERTEX_LIMIT", (int)65536);
        AIScene assimpScene = this.assimpResourceImporter.importScene(this.modelFilePath, postProcessingSteps += 128, assimpPropertyStore);
        ModelData modelData = new ModelData();
        modelData.id = "";
        int numberOfMeshes = assimpScene.mNumMeshes();
        LogTools.debug((String)"Number of meshes: {}", (Object)numberOfMeshes);
        PointerBuffer meshesPointerBuffer = assimpScene.mMeshes();
        modelData.meshes.ensureCapacity(numberOfMeshes);
        ArrayList<RDXAssimpMeshLoader> rdxAssimpMeshLoaders = new ArrayList<RDXAssimpMeshLoader>();
        for (int i = 0; i < numberOfMeshes; ++i) {
            AIMesh assimpMesh = new AIMesh(MemoryUtil.memByteBuffer((long)meshesPointerBuffer.get(i), (int)AIMesh.SIZEOF));
            RDXAssimpMeshLoader rdxAssimpMeshLoader = new RDXAssimpMeshLoader(assimpMesh);
            ModelMesh modelMesh = rdxAssimpMeshLoader.load();
            rdxAssimpMeshLoaders.add(rdxAssimpMeshLoader);
            modelData.meshes.add((Object)modelMesh);
        }
        int numberOfMaterials = assimpScene.mNumMaterials();
        LogTools.debug((String)"Number of materials: {}", (Object)numberOfMaterials);
        ArrayList<RDXAssimpMaterialLoader> RDXAssimpMaterialLoaders = new ArrayList<RDXAssimpMaterialLoader>();
        if (numberOfMaterials > 0) {
            modelData.materials.ensureCapacity(numberOfMaterials);
            PointerBuffer materialsPointerBuffer = assimpScene.mMaterials();
            for (int i = 0; i < numberOfMaterials; ++i) {
                AIMaterial assimpMaterial = new AIMaterial(MemoryUtil.memByteBuffer((long)materialsPointerBuffer.get(i), (int)AIMaterial.SIZEOF));
                RDXAssimpMaterialLoader RDXAssimpMaterialLoader2 = new RDXAssimpMaterialLoader(assimpMaterial, this.basePath);
                RDXAssimpMaterialLoaders.add(RDXAssimpMaterialLoader2);
                ModelMaterial modelMaterial = RDXAssimpMaterialLoader2.load();
                modelData.materials.add((Object)modelMaterial);
            }
        }
        AINode assimpRootNode = assimpScene.mRootNode();
        modelData.nodes.ensureCapacity(1);
        modelData.nodes.add((Object)new RDXAssimpNodeLoader(rdxAssimpMeshLoaders, RDXAssimpMaterialLoaders).load(assimpRootNode));
        return modelData;
    }
}

