/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.rdx.tools;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g3d.Model;
import com.badlogic.gdx.graphics.g3d.ModelInstance;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.math.collision.BoundingBox;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.rdx.tools.LibGDXTools;
import us.ihmc.scs2.definition.visual.ColorDefinition;

public class RDXModelInstance
extends ModelInstance {
    public final Vector3 center = new Vector3();
    public final Vector3 dimensions = new Vector3();
    public float radius;
    private static final BoundingBox bounds = new BoundingBox();
    private final RigidBodyTransform tempTransform = new RigidBodyTransform();
    private float currentOpacity = Float.NaN;

    public RDXModelInstance(Model model) {
        super(model);
    }

    public RDXModelInstance(ModelInstance modelInstance) {
        super(modelInstance);
    }

    public void calculateBoundingBox() {
        this.calculateBoundingBox(bounds);
        bounds.getCenter(this.center);
        bounds.getDimensions(this.dimensions);
        this.radius = this.dimensions.len() / 2.0f;
    }

    public void setTransformToReferenceFrame(ReferenceFrame referenceFrame) {
        referenceFrame.getTransformToDesiredFrame(this.tempTransform, ReferenceFrame.getWorldFrame());
        LibGDXTools.toLibGDX(this.tempTransform, this.transform);
    }

    public void setTransformToWorldFrame(RigidBodyTransform transformToWorldFrame) {
        LibGDXTools.toLibGDX(transformToWorldFrame, this.transform);
    }

    public void setPoseInWorldFrame(RigidBodyTransformReadOnly pose) {
        LibGDXTools.toLibGDX(pose, this.tempTransform, this.transform);
    }

    public void setPositionInWorldFrame(Point3DReadOnly position) {
        LibGDXTools.toLibGDX(position, this.transform);
    }

    public void setOpacity(float opacity) {
        if (opacity != this.currentOpacity) {
            LibGDXTools.setOpacity(this, opacity);
        }
        this.currentOpacity = opacity;
    }

    public void setDiffuseColor(Color color) {
        LibGDXTools.setDiffuseColor(this, color);
    }

    public void setColor(ColorDefinition color) {
        Color colorGDX = LibGDXTools.toLibGDX(color);
        this.setDiffuseColor(colorGDX);
        if (colorGDX.a < 1.0f) {
            this.setOpacity(colorGDX.a);
        }
    }
}

