/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.rdx.tools;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g3d.Attribute;
import com.badlogic.gdx.graphics.g3d.Material;
import com.badlogic.gdx.graphics.g3d.Model;
import com.badlogic.gdx.graphics.g3d.ModelInstance;
import com.badlogic.gdx.graphics.g3d.attributes.ColorAttribute;
import com.badlogic.gdx.graphics.g3d.model.Node;
import com.badlogic.gdx.graphics.g3d.utils.MeshPartBuilder;
import com.badlogic.gdx.graphics.g3d.utils.ModelBuilder;
import com.badlogic.gdx.graphics.g3d.utils.shapebuilders.BoxShapeBuilder;

public class BoxesDemoModel {
    private final float boxSize = 1.0f;
    private final float distance = 5.0f;
    private final ModelBuilder modelBuilder = new ModelBuilder();
    private int partIndex = 0;
    private final Model model;

    public BoxesDemoModel() {
        this.modelBuilder.begin();
        this.buildBoxPart(5.0f, 5.0f, 5.0f, Color.GREEN);
        this.buildBoxPart(-5.0f, 5.0f, 5.0f, Color.DARK_GRAY);
        this.buildBoxPart(5.0f, -5.0f, 5.0f, Color.RED);
        this.buildBoxPart(-5.0f, -5.0f, 5.0f, Color.ORANGE);
        this.buildBoxPart(5.0f, 5.0f, -5.0f, Color.BLUE);
        this.buildBoxPart(-5.0f, 5.0f, -5.0f, Color.BLACK);
        this.buildBoxPart(5.0f, -5.0f, -5.0f, Color.WHITE);
        this.buildBoxPart(-5.0f, -5.0f, -5.0f, Color.YELLOW);
        this.model = this.modelBuilder.end();
    }

    private void buildBoxPart(float x, float y, float z, Color color) {
        Node node = this.modelBuilder.node();
        node.translation.set(x, y, z);
        MeshPartBuilder partBuilder = this.modelBuilder.part("box" + this.partIndex++, 4, 9L, new Material(new Attribute[]{ColorAttribute.createDiffuse((Color)color)}));
        BoxShapeBuilder.build((MeshPartBuilder)partBuilder, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public ModelInstance newInstance() {
        return new ModelInstance(this.model);
    }

    public void dispose() {
        this.model.dispose();
    }
}

