/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.rdx.sceneManager;

import com.badlogic.gdx.graphics.g3d.Renderable;
import com.badlogic.gdx.graphics.g3d.RenderableProvider;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Pool;
import java.util.Set;
import us.ihmc.rdx.sceneManager.RDXRenderableProvider;
import us.ihmc.rdx.sceneManager.RDXSceneLevel;

public class RDXRenderableAdapter
implements RenderableProvider {
    private final RDXRenderableProvider rdxRenderableProvider;
    private final RenderableProvider renderableProvider;
    private final RDXSceneLevel sceneLevel;
    private Set<RDXSceneLevel> sceneLevelsToRender;

    public RDXRenderableAdapter(RenderableProvider renderableProvider, RDXSceneLevel sceneLevel) {
        this.renderableProvider = renderableProvider;
        this.sceneLevel = sceneLevel;
        this.rdxRenderableProvider = null;
    }

    public RDXRenderableAdapter(RDXRenderableProvider rdxRenderableProvider) {
        this.rdxRenderableProvider = rdxRenderableProvider;
        this.renderableProvider = null;
        this.sceneLevel = null;
    }

    public void getRenderables(Array<Renderable> renderables, Pool<Renderable> pool) {
        if (this.rdxRenderableProvider != null) {
            this.rdxRenderableProvider.getRenderables(renderables, pool, this.sceneLevelsToRender);
        } else if (this.sceneLevelsToRender.contains((Object)this.sceneLevel)) {
            this.renderableProvider.getRenderables(renderables, pool);
        }
    }

    public void setSceneLevelsToRender(Set<RDXSceneLevel> sceneLevelsToRender) {
        this.sceneLevelsToRender = sceneLevelsToRender;
    }
}

