/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.rdx.sceneManager;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.InputMultiplexer;
import com.badlogic.gdx.InputProcessor;
import com.badlogic.gdx.graphics.Camera;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.profiling.GLProfiler;
import com.badlogic.gdx.utils.viewport.ScreenViewport;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Consumer;
import us.ihmc.log.LogTools;
import us.ihmc.rdx.input.RDXInputMode;
import us.ihmc.rdx.sceneManager.RDX2DOrthographicCamera;
import us.ihmc.rdx.sceneManager.RDX2DSpriteDrawable;
import us.ihmc.rdx.sceneManager.RDX3DSceneTools;
import us.ihmc.rdx.tools.LibGDXTools;

public class RDX2DSceneManager {
    private final ArrayList<RDX2DSpriteDrawable> sprites = new ArrayList();
    private SpriteBatch spriteBatch;
    private final ArrayList<Consumer<ArrayList<RDX2DSpriteDrawable>>> spriteRenderableProviders = new ArrayList();
    private final ConcurrentLinkedQueue<Consumer<ArrayList<RDX2DSpriteDrawable>>> spriteRenderableRemovalQueue = new ConcurrentLinkedQueue();
    private InputMultiplexer inputMultiplexer;
    private RDX2DOrthographicCamera orthographicCamera;
    private ScreenViewport screenViewport;
    private int width = -1;
    private int height = -1;
    private boolean firstRenderStarted = false;
    private Runnable onCreate;
    private GLProfiler glProfiler;

    public void create() {
        this.create(RDXInputMode.libGDX);
    }

    public void create(RDXInputMode inputMode) {
        if (LibGDXTools.ENABLE_OPENGL_DEBUGGER) {
            this.glProfiler = LibGDXTools.createGLProfiler();
        }
        LibGDXTools.syncLogLevelWithLogTools();
        this.spriteBatch = new SpriteBatch();
        this.orthographicCamera = new RDX2DOrthographicCamera();
        if (inputMode == RDXInputMode.libGDX) {
            this.inputMultiplexer = new InputMultiplexer();
            Gdx.input.setInputProcessor((InputProcessor)this.inputMultiplexer);
            this.inputMultiplexer.addProcessor(this.orthographicCamera.setInputForLibGDX());
        }
        this.screenViewport = new ScreenViewport((Camera)this.orthographicCamera);
        this.screenViewport.setUnitsPerPixel(1.0f);
        this.screenViewport.apply();
        if (this.onCreate != null) {
            this.onCreate.run();
        }
    }

    public void render() {
        if (!this.firstRenderStarted) {
            this.firstRenderStarted = true;
            LogTools.info((String)"Starting first render.");
        }
        while (!this.spriteRenderableRemovalQueue.isEmpty()) {
            this.spriteRenderableProviders.remove(this.spriteRenderableRemovalQueue.poll());
        }
        this.screenViewport.update(this.width, this.height);
        RDX3DSceneTools.glClearGray();
        this.spriteBatch.setProjectionMatrix(this.orthographicCamera.combined);
        this.spriteBatch.begin();
        this.sprites.clear();
        for (Consumer<ArrayList<RDX2DSpriteDrawable>> spriteRenderableProvider : this.spriteRenderableProviders) {
            spriteRenderableProvider.accept(this.sprites);
        }
        for (RDX2DSpriteDrawable sprite : this.sprites) {
            sprite.draw(this.spriteBatch);
        }
        this.spriteBatch.end();
        if (LibGDXTools.ENABLE_OPENGL_DEBUGGER) {
            this.glProfiler.reset();
        }
    }

    public boolean closeRequested() {
        return true;
    }

    public void setViewportBounds(int width, int height) {
        this.width = width;
        this.height = height;
    }

    public RDX2DOrthographicCamera getOrthographicCamera() {
        return this.orthographicCamera;
    }

    public ScreenViewport getScreenViewport() {
        return this.screenViewport;
    }

    public void addLibGDXInputProcessor(InputProcessor inputProcessor) {
        if (this.inputMultiplexer != null) {
            this.inputMultiplexer.addProcessor(inputProcessor);
        } else {
            LogTools.error((int)1, (Object)"libGDX is not being used for input!");
        }
    }

    public void setOnCreate(Runnable onCreate) {
        this.onCreate = onCreate;
    }

    public void addSpriteRenderableProvider(Consumer<ArrayList<RDX2DSpriteDrawable>> spriteRenderableProvider) {
        this.spriteRenderableProviders.add(spriteRenderableProvider);
    }

    public void queueRemoveSpriteRenderableProvider(Consumer<ArrayList<RDX2DSpriteDrawable>> spriteRenderableProvider) {
        this.spriteRenderableRemovalQueue.add(spriteRenderableProvider);
    }
}

