/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.rdx.mesh;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Mesh;
import com.badlogic.gdx.graphics.g3d.Renderable;
import com.badlogic.gdx.graphics.g3d.model.Node;
import com.badlogic.gdx.graphics.g3d.model.NodePart;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Pool;
import java.util.function.Consumer;
import us.ihmc.graphicsDescription.MeshDataBuilder;
import us.ihmc.graphicsDescription.MeshDataHolder;
import us.ihmc.rdx.mesh.RDXMeshDataInterpreter;
import us.ihmc.rdx.tools.RDXModelBuilder;
import us.ihmc.rdx.tools.RDXModelInstance;

public class RDXMutableMeshModel {
    private Color color = null;
    protected RDXModelInstance modelInstance;
    private final transient MeshDataHolder emptyMeshDataHolder = new MeshDataBuilder().generateMeshDataHolder();

    public boolean isColorOutOfDate(Color color) {
        boolean outOfDate = this.color != color;
        this.color = color;
        return outOfDate;
    }

    protected void updateMesh(MeshDataHolder meshDataHolder) {
        boolean emptyModel = meshDataHolder.getTriangleIndices().length == 0;
        if (emptyModel |= meshDataHolder.getVertices().length == 0) {
            this.modelInstance = null;
        } else {
            boolean initialOrLargerModelNeeded = this.modelInstance == null;
            Mesh mesh = null;
            if (!initialOrLargerModelNeeded) {
                mesh = ((NodePart)((Node)this.modelInstance.model.nodes.get((int)0)).parts.get((int)0)).meshPart.mesh;
                initialOrLargerModelNeeded |= mesh.getIndicesBuffer().capacity() < meshDataHolder.getTriangleIndices().length;
                initialOrLargerModelNeeded |= mesh.getVerticesBuffer().capacity() < meshDataHolder.getVertices().length;
            }
            if (initialOrLargerModelNeeded) {
                this.modelInstance = new RDXModelInstance(RDXModelBuilder.buildModelInstance(meshBuilder -> meshBuilder.addMesh(meshDataHolder, this.color)));
            } else {
                RDXMeshDataInterpreter.reorderMeshVertices(meshDataHolder, mesh);
                RDXMeshDataInterpreter.repositionMeshVertices(meshDataHolder, mesh, this.color);
            }
        }
    }

    public void clear() {
        this.updateMesh(this.emptyMeshDataHolder);
    }

    public void accessModelIfExists(Consumer<RDXModelInstance> modelInstanceAccessor) {
        if (this.modelInstance != null) {
            modelInstanceAccessor.accept(this.modelInstance);
        }
    }

    public void getRenderables(Array<Renderable> renderables, Pool<Renderable> pool) {
        if (this.modelInstance != null) {
            this.modelInstance.getRenderables(renderables, pool);
        }
    }
}

