/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.rdx.mesh;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g3d.Renderable;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Pool;
import us.ihmc.euclid.Axis3D;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.graphicsDescription.MeshDataBuilder;
import us.ihmc.rdx.tools.RDXModelBuilder;
import us.ihmc.rdx.tools.RDXModelInstance;

public class RDXDashedLineMesh {
    public static final double EPSILON = 1.0E-4;
    private Color color = null;
    private final Axis3D dashAxis;
    private final double dashLength;
    private RDXModelInstance modelInstance;
    private final Vector3D drawingVector = new Vector3D();
    private final Point3D drawingPointStart = new Point3D();
    private final Point3D drawingPointEnd = new Point3D();
    private double lineWidth = Double.NaN;
    private double length = Double.NaN;
    private final MeshDataBuilder meshDataBuilder = new MeshDataBuilder();

    public RDXDashedLineMesh(Color color, Axis3D dashAxis, double dashLength) {
        this.color = color;
        this.dashAxis = dashAxis;
        this.dashLength = dashLength;
    }

    public void update(RigidBodyTransformReadOnly pose, double lineWidthUpdate, double lengthUpdate) {
        boolean outOfDate = !EuclidCoreTools.epsilonEquals((double)this.lineWidth, (double)lineWidthUpdate, (double)1.0E-4);
        boolean bl = !EuclidCoreTools.epsilonEquals((double)this.length, (double)lengthUpdate, (double)1.0E-4);
        this.lineWidth = lineWidthUpdate;
        this.length = lengthUpdate;
        if (outOfDate |= bl) {
            this.meshDataBuilder.clear();
            this.drawingPointStart.setToZero();
            this.drawingVector.setAndScale(-this.length / 2.0, (Tuple3DReadOnly)this.dashAxis);
            this.drawingPointStart.add((Tuple3DReadOnly)this.drawingVector);
            int numberOfDashes = (int)Math.ceil(this.length / (2.0 * this.dashLength));
            for (int i = 0; i < numberOfDashes; ++i) {
                this.drawingVector.setAndScale(this.dashLength, (Tuple3DReadOnly)this.dashAxis);
                this.drawingPointEnd.set(this.drawingPointStart);
                this.drawingPointEnd.add((Tuple3DReadOnly)this.drawingVector);
                this.meshDataBuilder.addLine((Tuple3DReadOnly)this.drawingPointStart, (Tuple3DReadOnly)this.drawingPointEnd, this.lineWidth);
                this.drawingPointStart.add((Tuple3DReadOnly)this.drawingVector);
                this.drawingPointStart.add((Tuple3DReadOnly)this.drawingVector);
            }
            this.modelInstance = new RDXModelInstance(RDXModelBuilder.buildModelInstance(meshBuilder -> meshBuilder.addMesh(this.meshDataBuilder.generateMeshDataHolder(), this.color)));
        }
        this.modelInstance.setPoseInWorldFrame(pose);
    }

    public RDXModelInstance getModelInstance() {
        return this.modelInstance;
    }

    public void getRenderables(Array<Renderable> renderables, Pool<Renderable> pool) {
        if (this.modelInstance != null) {
            this.modelInstance.getRenderables(renderables, pool);
        }
    }
}

