/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.rdx.input;

import imgui.internal.ImGui;
import java.util.function.Supplier;
import us.ihmc.rdx.imgui.ImGuiTools;
import us.ihmc.rdx.input.ImGuiMouseDragData;
import us.ihmc.rdx.sceneManager.RDX2DOrthographicCamera;

public class ImGui2DViewInput {
    private final RDX2DOrthographicCamera camera;
    private final Supplier<Float> viewportSizeXSupplier;
    private final Supplier<Float> viewportSizeYSupplier;
    private final ImGuiMouseDragData mouseDragDataLeft = new ImGuiMouseDragData(0);
    private final ImGuiMouseDragData mouseDragDataRight = new ImGuiMouseDragData(1);
    private final ImGuiMouseDragData mouseDragDataMiddle = new ImGuiMouseDragData(2);
    private final ImGuiMouseDragData[] mouseDragData = new ImGuiMouseDragData[]{this.mouseDragDataLeft, this.mouseDragDataRight, this.mouseDragDataMiddle};
    private float mousePosX = 0.0f;
    private float mousePosY = 0.0f;
    private boolean isWindowHovered;
    private float mouseWheelDelta;
    private boolean initialized = false;

    public ImGui2DViewInput(RDX2DOrthographicCamera camera, Supplier<Float> viewportSizeXSupplier, Supplier<Float> viewportSizeYSupplier) {
        this.camera = camera;
        this.viewportSizeXSupplier = viewportSizeXSupplier;
        this.viewportSizeYSupplier = viewportSizeYSupplier;
    }

    public void compute() {
        if (!this.initialized) {
            this.initialized = true;
        }
        this.isWindowHovered = ImGui.isWindowHovered();
        this.mousePosX = (int)ImGui.getMousePosX() - (int)ImGui.getWindowPosX();
        this.mousePosY = (int)ImGui.getMousePosY() - (int)ImGui.getWindowPosY() - (int)ImGuiTools.TAB_BAR_HEIGHT;
        this.mouseWheelDelta = -ImGui.getIO().getMouseWheel();
        for (ImGuiMouseDragData mouseDragDatum : this.mouseDragData) {
            mouseDragDatum.update();
        }
    }

    public boolean mouseReleasedWithoutDrag(int button) {
        return ImGui.getMouseDragDeltaX() == 0.0f && ImGui.getMouseDragDeltaX() == 0.0f && ImGui.isMouseReleased((int)button);
    }

    public boolean isWindowHovered() {
        return this.isWindowHovered;
    }

    public boolean isDragging(int imGuiMouseButton) {
        return this.mouseDragData[imGuiMouseButton].isDragging();
    }

    public float getMouseDraggedX(int imGuiMouseButton) {
        return this.mouseDragData[imGuiMouseButton].getMouseDraggedX();
    }

    public float getMouseDraggedY(int imGuiMouseButton) {
        return this.mouseDragData[imGuiMouseButton].getMouseDraggedY();
    }

    public float getMousePosX() {
        return this.mousePosX;
    }

    public float getMousePosY() {
        return this.mousePosY;
    }

    public float getMouseWheelDelta() {
        return this.mouseWheelDelta;
    }
}

