/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.rdx.imgui;

import imgui.extension.implot.ImPlot;
import us.ihmc.rdx.imgui.ImPlotPlotLineSwapBuffer;
import us.ihmc.rdx.imgui.ImPlotTools;
import us.ihmc.tools.thread.SwapReference;

public class ImPlotPlotLineDoubleSwapBuffer
implements ImPlotPlotLineSwapBuffer {
    private SwapReference<double[]> yValues;
    private int bufferSize;
    private double value = Double.NaN;

    @Override
    public void initialize(int bufferSize) {
        this.bufferSize = bufferSize;
        this.yValues = new SwapReference(() -> ImPlotTools.newNaNFilledBuffer(bufferSize));
    }

    public void addValue(double value) {
        this.value = value;
    }

    @Override
    public void setAValue(int index) {
        ((double[])this.yValues.getA())[index] = this.value;
    }

    @Override
    public void setPreviousValue(int index) {
        ((double[])this.yValues.getForThreadOne())[index] = this.value;
    }

    @Override
    public void setUpdatedValue(int index) {
        ((double[])this.yValues.getForThreadTwo())[index] = this.value;
    }

    @Override
    public void copyAToB() {
        System.arraycopy(this.yValues.getA(), 0, this.yValues.getB(), 0, this.bufferSize);
    }

    @Override
    public void copyPreviousToUpdated(int srcPos, int destPos, int length) {
        double[] previousValues = (double[])this.yValues.getForThreadOne();
        double[] updatedValues = (double[])this.yValues.getForThreadTwo();
        System.arraycopy(previousValues, srcPos, updatedValues, 0, length);
        this.yValues.swap();
    }

    @Override
    public void plot(String labelID, double[] xValues, int offset) {
        ImPlot.plotLine((String)labelID, (double[])xValues, (double[])((double[])this.yValues.getForThreadOne()), (int)xValues.length, (int)offset);
    }

    public double getValue(int bufferIndex) {
        return ((double[])this.yValues.getForThreadOne())[bufferIndex];
    }
}

