/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.rdx.imgui;

import imgui.extension.implot.ImPlot;
import us.ihmc.rdx.imgui.ImPlotPlotLine;

public class ImPlotBasicDoublePlotLine
implements ImPlotPlotLine {
    private int size = 0;
    private double[] xValues = new double[100];
    private double[] yValues = new double[100];
    private String legendLabel = "";
    private int dataColor = -1;

    public ImPlotBasicDoublePlotLine() {
        this.initializeXValues();
    }

    public void setLegendLabel(String legendLabel) {
        this.legendLabel = legendLabel;
    }

    public void setDataColor(int dataColor) {
        this.dataColor = dataColor;
    }

    public void clear() {
        this.size = 0;
    }

    private void initializeXValues() {
        for (int i = 0; i < this.xValues.length; ++i) {
            this.xValues[i] = i;
        }
    }

    public void addValue(double newValue) {
        if (this.size == this.xValues.length) {
            double[] enlargedXValues = new double[this.xValues.length * 2];
            System.arraycopy(this.xValues, 0, enlargedXValues, 0, this.xValues.length);
            this.xValues = enlargedXValues;
            double[] enlargedYValues = new double[this.yValues.length * 2];
            System.arraycopy(this.yValues, 0, enlargedYValues, 0, this.yValues.length);
            this.yValues = enlargedYValues;
            this.initializeXValues();
        }
        this.yValues[this.size] = newValue;
        ++this.size;
    }

    @Override
    public boolean render() {
        if (this.dataColor != -1) {
            ImPlot.pushStyleColor((int)0, (long)this.dataColor);
        }
        ImPlot.plotLine((String)this.legendLabel, (double[])this.xValues, (double[])this.yValues, (int)this.size, (int)0);
        if (this.dataColor != -1) {
            ImPlot.popStyleColor();
        }
        return false;
    }

    @Override
    public String getVariableName() {
        return this.legendLabel;
    }

    @Override
    public String getValueString(int bufferIndex) {
        return "%.2f".formatted(this.yValues[bufferIndex]);
    }

    public double getMaxYValue() {
        double max = Double.NaN;
        for (int i = 0; i < this.size; ++i) {
            if (Double.isNaN(this.yValues[i])) continue;
            max = Double.isNaN(max) ? this.yValues[i] : Math.max(this.yValues[i], max);
        }
        return max;
    }
}

