/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.rdx.imgui;

import imgui.ImGui;
import us.ihmc.rdx.imgui.ImGuiLabelledWidgetAligner;
import us.ihmc.rdx.imgui.ImGuiTools;
import us.ihmc.rdx.imgui.ImGuiUniqueLabelMap;

public abstract class ImGuiFancyWidget {
    private final ImGuiUniqueLabelMap labels = new ImGuiUniqueLabelMap(this.getClass());
    protected final String label;
    protected final String format;
    private final String prefixLabel;
    private float widgetWidth = -1.0f;
    private boolean widgetTextColoring = false;
    private int widgetTextColor = 0;
    private String buttonText;
    private Runnable onButtonPressed;
    private ImGuiLabelledWidgetAligner widgetAligner;

    protected ImGuiFancyWidget(String label) {
        this.prefixLabel = label;
        this.label = this.labels.getHidden(label);
        this.format = null;
    }

    protected ImGuiFancyWidget(String label, String format) {
        this.prefixLabel = label;
        this.label = this.labels.getHidden(label);
        this.format = format;
    }

    protected void beforeWidgetRender() {
        if (this.widgetAligner != null) {
            this.widgetAligner.text(this.prefixLabel);
        } else {
            ImGui.text((String)this.prefixLabel);
            ImGui.sameLine();
        }
        float itemWidth = ImGui.getColumnWidth();
        if (this.widgetWidth >= 0.0f) {
            itemWidth = this.widgetWidth;
        }
        if (this.buttonText != null) {
            itemWidth -= ImGuiTools.calcButtonWidth(this.buttonText) + ImGui.getStyle().getItemSpacingX();
        }
        ImGui.pushItemWidth((float)itemWidth);
        if (this.widgetTextColoring) {
            ImGui.pushStyleColor((int)0, (int)this.widgetTextColor);
        }
    }

    protected void afterWidgetRender() {
        ImGui.popItemWidth();
        if (this.widgetTextColoring) {
            ImGui.popStyleColor();
        }
        if (this.buttonText != null) {
            ImGui.sameLine();
            if (ImGui.button((String)this.labels.get(this.buttonText, this.prefixLabel))) {
                this.onButtonPressed.run();
            }
        }
    }

    public void setWidgetTextColor(int intColor) {
        this.widgetTextColoring = true;
        this.widgetTextColor = intColor;
    }

    public void clearWidgetTextColor() {
        this.widgetTextColoring = false;
    }

    public void setWidgetWidth(float widgetWidth) {
        this.widgetWidth = widgetWidth;
    }

    public void addButton(String buttonText, Runnable onButtonPressed) {
        this.buttonText = buttonText;
        this.onButtonPressed = onButtonPressed;
    }

    public void addWidgetAligner(ImGuiLabelledWidgetAligner widgetAligner) {
        this.widgetAligner = widgetAligner;
    }
}

