/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.rdx.imgui;

import us.ihmc.commons.time.Stopwatch;
import us.ihmc.rdx.imgui.ImGuiPlot;

public class ImGuiDerivativePlot
extends ImGuiPlot {
    private float previousValue = Float.NaN;
    private final Stopwatch stopwatch = new Stopwatch();

    public ImGuiDerivativePlot(String name, int bufferSize) {
        super(name, bufferSize);
    }

    public ImGuiDerivativePlot(String name, int bufferSize, int width, int height) {
        super(name, bufferSize, width, height);
    }

    @Override
    public void setValue(float newValue) {
        if (Float.isNaN(this.previousValue)) {
            super.setValue(Float.NaN);
            this.stopwatch.reset();
        } else {
            float lap = (float)this.stopwatch.lap();
            super.setValue((newValue - this.previousValue) / lap);
        }
        this.previousValue = newValue;
    }
}

