/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.rdx;

import imgui.ImFont;
import imgui.ImVec2;
import imgui.internal.ImGui;
import imgui.type.ImString;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import us.ihmc.rdx.imgui.ImGuiTools;
import us.ihmc.tools.string.StringTools;

public class RDXKeyBindings {
    private static final int WINDOW_WIDTH = 600;
    private static final int WINDOW_HEIGHT = 600;
    private final Map<String, KeyBindingsSection> sections = new HashMap<String, KeyBindingsSection>();
    private final ImString filter = new ImString();
    private boolean filterInputActive = false;
    private boolean forceActive = false;

    public boolean register(String function, String key) {
        KeyBindingsSection section;
        String callingClassName = RDXKeyBindings.getCallingClassName();
        if (this.sections.containsKey(callingClassName)) {
            section = this.sections.get(callingClassName);
        } else {
            String description = StringTools.pascalCaseToSentenceCase((String)callingClassName.replace("RDX", ""));
            section = new KeyBindingsSection(description);
            this.sections.put(callingClassName, section);
        }
        KeyBinding keyBinding = new KeyBinding(function, key);
        if (!section.registry.contains(keyBinding)) {
            section.registry.add(keyBinding);
            return true;
        }
        return false;
    }

    public void renderKeyBindingsTable() {
        boolean tabKeyIsDown;
        if (this.filterInputActive && ImGui.isKeyPressed((int)ImGui.getKeyIndex((int)14))) {
            this.filterInputActive = false;
        }
        if ((tabKeyIsDown = ImGui.isKeyDown((int)ImGui.getKeyIndex((int)0))) || this.filterInputActive || this.forceActive) {
            ImGui.setNextWindowViewport((int)ImGui.getMainViewport().getID());
            float x = ImGui.getMainViewport().getCenterX() - 300.0f;
            float y = ImGui.getMainViewport().getCenterY() - 300.0f;
            ImGui.setNextWindowPos((float)x, (float)y, (int)1);
            ImGui.begin((String)"##keyBindingsWindow", (int)3);
            ImGui.beginChild((String)"##keyBindingsWindowChild", (float)600.0f, (float)600.0f);
            if (ImGui.beginTable((String)"##keyBindingsSearch", (int)2)) {
                ImGui.tableNextRow();
                ImGui.tableSetColumnIndex((int)0);
                ImGui.alignTextToFramePadding();
                ImGui.pushFont((ImFont)ImGuiTools.getMediumFont());
                ImGui.text((String)"Key Bindings");
                ImGui.popFont();
                ImGui.tableSetColumnIndex((int)1);
                if (this.forceActive) {
                    ImGui.setKeyboardFocusHere((int)0);
                }
                if (ImGui.inputText((String)"Search", (ImString)this.filter)) {
                    this.filterInputActive = true;
                }
                boolean bl = this.filterInputActive = ImGui.isItemFocused() || this.forceActive;
                if (!this.filterInputActive) {
                    this.filter.set("");
                }
                ImGui.endTable();
            }
            for (Map.Entry<String, KeyBindingsSection> entry : this.sections.entrySet()) {
                KeyBindingsSection section = entry.getValue();
                if (!ImGui.beginTable((String)("##keyBindingsTable_" + section.description), (int)2)) continue;
                ImGui.tableSetupColumn((String)section.description);
                ImGui.tableSetupColumn((String)"Key");
                ImGui.tableHeadersRow();
                section.renderSection(this.filter);
                ImGui.endTable();
            }
            ImGui.endChild();
            ImGui.end();
            this.forceActive = false;
        }
    }

    public void showKeybindings() {
        this.forceActive = true;
        this.filterInputActive = true;
    }

    private static String getCallingClassName() {
        StackTraceElement callerStackElement = new Throwable().getStackTrace()[2];
        return callerStackElement.getClassName().substring(callerStackElement.getClassName().lastIndexOf(".") + 1);
    }

    private static class KeyBindingsSection {
        private final String description;
        private final TreeSet<KeyBinding> registry = new TreeSet<KeyBinding>(Comparator.comparing(KeyBinding::combined));
        private final transient ImVec2 textSize = new ImVec2();
        private int keyButtonWidth = 85;

        private KeyBindingsSection(String description) {
            this.description = description;
        }

        public void renderSection(ImString filter) {
            for (KeyBinding keyBinding : this.registry) {
                if (!filter.isEmpty()) {
                    boolean match = false;
                    if (keyBinding.function().toLowerCase().contains(filter.get().toLowerCase())) {
                        match = true;
                    }
                    if (this.description.toLowerCase().contains(filter.get().toLowerCase())) {
                        match = true;
                    }
                    if (!match) continue;
                }
                ImGui.calcTextSize((ImVec2)this.textSize, (String)keyBinding.key());
                this.keyButtonWidth = Math.max(this.keyButtonWidth, Math.round(this.textSize.x) + 10);
                ImGui.tableNextRow();
                ImGui.tableSetColumnIndex((int)0);
                ImGui.alignTextToFramePadding();
                ImGui.text((String)keyBinding.function());
                ImGui.tableSetColumnIndex((int)1);
                ImGui.pushItemFlag((int)4, (boolean)true);
                ImGui.button((String)keyBinding.key(), (float)this.keyButtonWidth, (float)0.0f);
                ImGui.popItemFlag();
            }
        }
    }

    private record KeyBinding(String function, String key) {
        public String combined() {
            return this.function + this.key;
        }
    }
}

