/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.tests.g3d.shadows.utils;

import com.badlogic.gdx.graphics.Camera;
import com.badlogic.gdx.graphics.g3d.environment.DirectionalLight;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.math.collision.BoundingBox;
import com.badlogic.gdx.tests.g3d.shadows.utils.DirectionalAnalyzer;

public class BoundingSphereDirectionalAnalyzer
implements DirectionalAnalyzer {
    protected BoundingBox bb = new BoundingBox();
    protected Vector3 tmpV = new Vector3();
    protected Vector3 tmpV2 = new Vector3();

    @Override
    public Camera analyze(DirectionalLight light, Camera out, Camera mainCamera) {
        this.bb.inf();
        for (int i = 0; i < mainCamera.frustum.planePoints.length; ++i) {
            this.bb.ext(mainCamera.frustum.planePoints[i]);
        }
        float radius = this.bb.getDimensions(this.tmpV).len() * 0.5f;
        this.bb.getCenter(this.tmpV);
        this.tmpV2.set(light.direction);
        this.tmpV2.scl(radius * 1.5f);
        out.direction.set(light.direction);
        out.position.set(this.tmpV.sub(this.tmpV2));
        out.near = 0.5f * radius;
        out.far = 2.5f * radius;
        Vector3 d = light.direction;
        if (d.z < d.x + d.y) {
            out.up.set(-light.direction.y, light.direction.x, light.direction.z);
        } else {
            out.up.set(light.direction.x, -light.direction.z, light.direction.y);
        }
        out.viewportWidth = radius;
        out.viewportHeight = radius;
        return out;
    }
}

