/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.tests.g3d.shadows.system;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Camera;
import com.badlogic.gdx.graphics.Cubemap;
import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.graphics.PerspectiveCamera;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.graphics.g3d.RenderableProvider;
import com.badlogic.gdx.graphics.g3d.environment.BaseLight;
import com.badlogic.gdx.graphics.g3d.environment.DirectionalLight;
import com.badlogic.gdx.graphics.g3d.environment.PointLight;
import com.badlogic.gdx.graphics.g3d.environment.SpotLight;
import com.badlogic.gdx.graphics.g3d.utils.ShaderProvider;
import com.badlogic.gdx.graphics.glutils.FrameBuffer;
import com.badlogic.gdx.tests.g3d.shadows.system.ShadowSystem;
import com.badlogic.gdx.tests.g3d.shadows.utils.AABBNearFarAnalyzer;
import com.badlogic.gdx.tests.g3d.shadows.utils.BoundingSphereDirectionalAnalyzer;
import com.badlogic.gdx.tests.g3d.shadows.utils.DirectionalAnalyzer;
import com.badlogic.gdx.tests.g3d.shadows.utils.FixedShadowMapAllocator;
import com.badlogic.gdx.tests.g3d.shadows.utils.FrustumLightFilter;
import com.badlogic.gdx.tests.g3d.shadows.utils.LightFilter;
import com.badlogic.gdx.tests.g3d.shadows.utils.NearFarAnalyzer;
import com.badlogic.gdx.tests.g3d.shadows.utils.ShadowMapAllocator;
import com.badlogic.gdx.utils.Disposable;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.ObjectMap;
import java.util.EnumSet;
import java.util.Set;

public abstract class BaseShadowSystem
implements ShadowSystem,
Disposable {
    protected Camera camera;
    protected Iterable<RenderableProvider> renderableProviders;
    protected ObjectMap<SpotLight, LightProperties> spotCameras = new ObjectMap();
    protected ObjectMap<DirectionalLight, LightProperties> dirCameras = new ObjectMap();
    protected ObjectMap<PointLight, PointLightProperties> pointCameras = new ObjectMap();
    protected NearFarAnalyzer nearFarAnalyzer;
    protected ShadowMapAllocator allocator;
    protected DirectionalAnalyzer directionalAnalyzer;
    protected LightFilter lightFilter;
    protected FrameBuffer[] frameBuffers;
    protected int currentPass = -1;
    protected ObjectMap.Entries<SpotLight, LightProperties> spotCameraIterator;
    protected ObjectMap.Entries<DirectionalLight, LightProperties> dirCameraIterator;
    protected ObjectMap.Entries<PointLight, PointLightProperties> pointCameraIterator;
    protected int currentPointSide;
    protected PointLightProperties currentPointProperties;
    protected ShaderProvider[] passShaderProviders;
    protected ShaderProvider mainShaderProvider;
    protected LightProperties currentLightProperties;
    protected BaseLight currentLight;

    public BaseShadowSystem(NearFarAnalyzer nearFarAnalyzer, ShadowMapAllocator allocator, DirectionalAnalyzer directionalAnalyzer, LightFilter lightFilter) {
        this.nearFarAnalyzer = nearFarAnalyzer;
        this.allocator = allocator;
        this.directionalAnalyzer = directionalAnalyzer;
        this.lightFilter = lightFilter;
    }

    public BaseShadowSystem() {
        this(new AABBNearFarAnalyzer(), new FixedShadowMapAllocator(2048, 16), new BoundingSphereDirectionalAnalyzer(), new FrustumLightFilter());
    }

    @Override
    public void init() {
        this.frameBuffers = new FrameBuffer[this.getPassQuantity()];
        this.passShaderProviders = new ShaderProvider[this.getPassQuantity()];
        for (int i = 0; i < this.getPassQuantity(); ++i) {
            this.init(i);
        }
    }

    protected abstract void init(int var1);

    @Override
    public abstract int getPassQuantity();

    @Override
    public ShaderProvider getPassShaderProvider(int n) {
        return this.passShaderProviders[n];
    }

    @Override
    public ShaderProvider getShaderProvider() {
        return this.mainShaderProvider;
    }

    @Override
    public void addLight(SpotLight spot) {
        PerspectiveCamera camera = new PerspectiveCamera(spot.cutoffAngle, 0.0f, 0.0f);
        camera.position.set(spot.position);
        camera.direction.set(spot.direction);
        camera.near = 1.0f;
        camera.far = 100.0f;
        camera.up.set(camera.direction.y, camera.direction.z, camera.direction.x);
        this.spotCameras.put((Object)spot, (Object)new LightProperties((Camera)camera));
    }

    @Override
    public void addLight(DirectionalLight dir) {
        OrthographicCamera camera = new OrthographicCamera();
        camera.direction.set(dir.direction);
        camera.near = 1.0f;
        camera.far = 100.0f;
        this.dirCameras.put((Object)dir, (Object)new LightProperties((Camera)camera));
    }

    @Override
    public void addLight(PointLight point) {
        this.addLight(point, EnumSet.of(Cubemap.CubemapSide.PositiveX, new Cubemap.CubemapSide[]{Cubemap.CubemapSide.NegativeX, Cubemap.CubemapSide.PositiveY, Cubemap.CubemapSide.NegativeY, Cubemap.CubemapSide.PositiveZ, Cubemap.CubemapSide.NegativeZ}));
    }

    @Override
    public void addLight(PointLight point, Set<Cubemap.CubemapSide> sides) {
        PointLightProperties plProperty = new PointLightProperties();
        for (int i = 0; i < 6; ++i) {
            Cubemap.CubemapSide cubemapSide = Cubemap.CubemapSide.values()[i];
            if (!sides.contains(cubemapSide)) continue;
            PerspectiveCamera camera = new PerspectiveCamera(90.0f, 0.0f, 0.0f);
            camera.position.set(point.position);
            camera.direction.set(cubemapSide.direction);
            camera.up.set(cubemapSide.up);
            camera.near = 1.0f;
            camera.far = 100.0f;
            LightProperties p = new LightProperties((Camera)camera);
            plProperty.properties.put((Object)cubemapSide, (Object)p);
        }
        this.pointCameras.put((Object)point, (Object)plProperty);
    }

    @Override
    public void removeLight(SpotLight spot) {
        this.spotCameras.remove((Object)spot);
    }

    @Override
    public void removeLight(DirectionalLight dir) {
        this.dirCameras.remove((Object)dir);
    }

    @Override
    public void removeLight(PointLight point) {
        this.pointCameras.remove((Object)point);
    }

    @Override
    public boolean hasLight(SpotLight spot) {
        return this.spotCameras.containsKey((Object)spot);
    }

    @Override
    public boolean hasLight(DirectionalLight dir) {
        return this.dirCameras.containsKey((Object)dir);
    }

    @Override
    public boolean hasLight(PointLight point) {
        return this.pointCameras.containsKey((Object)point);
    }

    @Override
    public void update() {
        for (ObjectMap.Entry e : this.spotCameras) {
            ((LightProperties)e.value).camera.position.set(((SpotLight)e.key).position);
            ((LightProperties)e.value).camera.direction.set(((SpotLight)e.key).direction);
            this.nearFarAnalyzer.analyze((BaseLight)e.key, ((LightProperties)e.value).camera, this.renderableProviders);
        }
        for (ObjectMap.Entry e : this.dirCameras) {
            this.directionalAnalyzer.analyze((DirectionalLight)e.key, ((LightProperties)e.value).camera, this.camera).update();
        }
        for (ObjectMap.Entry e : this.pointCameras) {
            for (ObjectMap.Entry c : ((PointLightProperties)e.value).properties) {
                ((LightProperties)c.value).camera.position.set(((PointLight)e.key).position);
                this.nearFarAnalyzer.analyze((BaseLight)e.key, ((LightProperties)c.value).camera, this.renderableProviders);
            }
        }
    }

    @Override
    public <T extends RenderableProvider> void begin(Camera camera, Iterable<T> renderableProviders) {
        if (this.renderableProviders != null || this.camera != null) {
            throw new GdxRuntimeException("Call end() first.");
        }
        this.camera = camera;
        this.renderableProviders = renderableProviders;
    }

    @Override
    public void begin(int n) {
        if (n >= this.passShaderProviders.length) {
            throw new GdxRuntimeException("Pass " + n + " doesn't exist in " + this.getClass().getName());
        }
        this.currentPass = n;
        this.spotCameraIterator = this.spotCameras.iterator();
        this.dirCameraIterator = this.dirCameras.iterator();
        this.pointCameraIterator = this.pointCameras.iterator();
        this.currentPointSide = 6;
        this.beginPass(n);
    }

    protected void beginPass(int n) {
        this.frameBuffers[n].begin();
    }

    @Override
    public void end() {
        this.camera = null;
        this.renderableProviders = null;
        this.currentPass = -1;
    }

    @Override
    public void end(int n) {
        if (this.currentPass != n) {
            throw new GdxRuntimeException("Begin " + n + " must be called before end " + n);
        }
        this.endPass(n);
    }

    protected void endPass(int n) {
        this.frameBuffers[n].end();
    }

    @Override
    public Camera next() {
        LightProperties lp = this.nextDirectional();
        if (lp != null) {
            return this.interceptCamera(lp);
        }
        lp = this.nextSpot();
        if (lp != null) {
            return this.interceptCamera(lp);
        }
        lp = this.nextPoint();
        if (lp != null) {
            return this.interceptCamera(lp);
        }
        return null;
    }

    protected Camera interceptCamera(LightProperties lp) {
        return lp.camera;
    }

    protected LightProperties nextDirectional() {
        if (!this.dirCameraIterator.hasNext()) {
            return null;
        }
        ObjectMap.Entry e = this.dirCameraIterator.next();
        this.currentLight = (BaseLight)e.key;
        this.currentLightProperties = (LightProperties)e.value;
        LightProperties lp = (LightProperties)e.value;
        this.processViewport(lp, false);
        return lp;
    }

    protected LightProperties nextSpot() {
        if (!this.spotCameraIterator.hasNext()) {
            return null;
        }
        ObjectMap.Entry e = this.spotCameraIterator.next();
        this.currentLight = (BaseLight)e.key;
        this.currentLightProperties = (LightProperties)e.value;
        LightProperties lp = (LightProperties)e.value;
        if (!this.lightFilter.filter((BaseLight)this.spotCameras.findKey((Object)lp, true), lp.camera, this.camera)) {
            return this.nextSpot();
        }
        this.processViewport(lp, true);
        return lp;
    }

    protected LightProperties nextPoint() {
        if (!this.pointCameraIterator.hasNext() && this.currentPointSide > 5) {
            return null;
        }
        if (this.currentPointSide > 5) {
            this.currentPointSide = 0;
        }
        if (this.currentPointSide == 0) {
            ObjectMap.Entry e = this.pointCameraIterator.next();
            this.currentLight = (BaseLight)e.key;
            this.currentPointProperties = (PointLightProperties)e.value;
        }
        if (this.currentPointProperties.properties.containsKey((Object)Cubemap.CubemapSide.values()[this.currentPointSide])) {
            LightProperties lp;
            this.currentLightProperties = lp = (LightProperties)this.currentPointProperties.properties.get((Object)Cubemap.CubemapSide.values()[this.currentPointSide]);
            ++this.currentPointSide;
            if (!this.lightFilter.filter((BaseLight)this.pointCameras.findKey((Object)this.currentPointProperties, true), lp.camera, this.camera)) {
                return this.nextPoint();
            }
            this.processViewport(lp, true);
            return lp;
        }
        ++this.currentPointSide;
        return this.nextPoint();
    }

    protected void processViewport(LightProperties lp, boolean cameraViewport) {
        Camera camera = lp.camera;
        ShadowMapAllocator.ShadowMapRegion r = this.allocator.nextResult(this.currentLight);
        if (r == null) {
            return;
        }
        TextureRegion region = lp.region;
        region.setTexture((Texture)this.frameBuffers[this.currentPass].getColorBufferTexture());
        Gdx.gl.glViewport(r.x, r.y, r.width, r.height);
        Gdx.gl.glScissor(r.x + 1, r.y + 1, r.width - 2, r.height - 2);
        region.setRegion(r.x, r.y, r.width, r.height);
        if (cameraViewport) {
            camera.viewportHeight = r.height;
            camera.viewportWidth = r.width;
            camera.update();
        }
    }

    public ObjectMap<DirectionalLight, LightProperties> getDirectionalCameras() {
        return this.dirCameras;
    }

    public ObjectMap<SpotLight, LightProperties> getSpotCameras() {
        return this.spotCameras;
    }

    public ObjectMap<PointLight, PointLightProperties> getPointCameras() {
        return this.pointCameras;
    }

    public Texture getTexture(int n) {
        if (n >= this.getPassQuantity()) {
            throw new GdxRuntimeException("Can't get texture " + n);
        }
        return (Texture)this.frameBuffers[n].getColorBufferTexture();
    }

    public LightProperties getCurrentLightProperties() {
        return this.currentLightProperties;
    }

    public BaseLight getCurrentLight() {
        return this.currentLight;
    }

    public int getCurrentPass() {
        return this.currentPass;
    }

    public void dispose() {
        for (int i = 0; i < this.getPassQuantity(); ++i) {
            this.frameBuffers[i].dispose();
            this.passShaderProviders[i].dispose();
        }
        this.mainShaderProvider.dispose();
    }

    public static class LightProperties {
        public Camera camera;
        public TextureRegion region = new TextureRegion();

        public LightProperties(Camera camera) {
            this.camera = camera;
        }
    }

    public static class PointLightProperties {
        public ObjectMap<Cubemap.CubemapSide, LightProperties> properties = new ObjectMap(6);
    }
}

