/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.glutils;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.TextureData;
import com.badlogic.gdx.graphics.glutils.FloatTextureData;
import com.badlogic.gdx.graphics.glutils.GLFrameBuffer;
import com.badlogic.gdx.graphics.glutils.PixmapTextureData;

public class SensorFrameBuffer
extends GLFrameBuffer<Texture> {
    private Pixmap colorPixmap;
    private FloatTextureData depthTextureData;
    private Texture colorTexture;
    private Texture depthTexture;

    protected SensorFrameBuffer(GLFrameBuffer.GLFrameBufferBuilder<? extends GLFrameBuffer<Texture>> bufferBuilder) {
        super(bufferBuilder);
    }

    protected Texture createTexture(GLFrameBuffer.FrameBufferTextureAttachmentSpec attachmentSpec) {
        Texture texture;
        if (attachmentSpec.format == Pixmap.Format.toGlFormat((Pixmap.Format)Pixmap.Format.RGBA8888)) {
            this.colorPixmap = new Pixmap(this.bufferBuilder.width, this.bufferBuilder.height, Pixmap.Format.RGBA8888);
            PixmapTextureData pixmapTextureData = new PixmapTextureData(this.colorPixmap, null, false, false);
            texture = this.colorTexture = new Texture((TextureData)pixmapTextureData);
            texture.setFilter(Texture.TextureFilter.Linear, Texture.TextureFilter.Linear);
            texture.setWrap(Texture.TextureWrap.ClampToEdge, Texture.TextureWrap.ClampToEdge);
        } else {
            attachmentSpec.isGpuOnly = true;
            this.depthTextureData = new FloatTextureData(this.bufferBuilder.width, this.bufferBuilder.height, attachmentSpec.internalFormat, attachmentSpec.format, attachmentSpec.type, attachmentSpec.isGpuOnly);
            texture = this.depthTexture = new Texture((TextureData)this.depthTextureData);
            texture.setFilter(Texture.TextureFilter.Linear, Texture.TextureFilter.Linear);
            texture.setWrap(Texture.TextureWrap.ClampToEdge, Texture.TextureWrap.ClampToEdge);
        }
        return texture;
    }

    protected void disposeColorTexture(Texture colorTexture) {
        colorTexture.dispose();
    }

    protected void attachFrameBufferColorTexture(Texture texture) {
        Gdx.gl20.glFramebufferTexture2D(36160, 36064, 3553, texture.getTextureObjectHandle(), 0);
    }

    public static void unbind() {
        GLFrameBuffer.unbind();
    }

    public Pixmap getColorPixmap() {
        return this.colorPixmap;
    }

    public FloatTextureData getDepthTextureData() {
        return this.depthTextureData;
    }

    public Texture getColorTexture() {
        return this.colorTexture;
    }

    public Texture getDepthTexture() {
        return this.depthTexture;
    }
}

