/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.rdx.visualizers;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Mesh;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g3d.Attribute;
import com.badlogic.gdx.graphics.g3d.Material;
import com.badlogic.gdx.graphics.g3d.Model;
import com.badlogic.gdx.graphics.g3d.ModelInstance;
import com.badlogic.gdx.graphics.g3d.Renderable;
import com.badlogic.gdx.graphics.g3d.RenderableProvider;
import com.badlogic.gdx.graphics.g3d.attributes.BlendingAttribute;
import com.badlogic.gdx.graphics.g3d.attributes.ColorAttribute;
import com.badlogic.gdx.graphics.g3d.attributes.TextureAttribute;
import com.badlogic.gdx.graphics.g3d.model.MeshPart;
import com.badlogic.gdx.graphics.g3d.utils.ModelBuilder;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Pool;
import java.util.ArrayList;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.log.LogTools;
import us.ihmc.rdx.mesh.RDXMultiColorMeshBuilder;

public class RDXSplineBody
implements RenderableProvider {
    private final ModelBuilder modelBuilder = new ModelBuilder();
    private final RDXMultiColorMeshBuilder meshBuilder = new RDXMultiColorMeshBuilder();
    private ModelInstance modelInstance;
    private Model lastModel;
    private final ArrayList<Point3DReadOnly> points = new ArrayList();
    private static final int VERTEX_BUFFER_MARGIN = 65525;
    private Color color;
    private float lineWidth = 0.1f;
    private final Material material = new Material();

    public RDXSplineBody(float lineWidth) {
        this.lineWidth = lineWidth;
        Texture paletteTexture = RDXMultiColorMeshBuilder.loadPaletteTexture();
        this.material.set((Attribute)TextureAttribute.createDiffuse((Texture)paletteTexture));
        this.material.set((Attribute)ColorAttribute.createDiffuse((Color)new Color(0.7f, 0.7f, 0.7f, 1.0f)));
    }

    public RDXSplineBody(float lineWidth, float opacity) {
        this.lineWidth = lineWidth;
        Texture paletteTexture = RDXMultiColorMeshBuilder.loadPaletteTexture();
        this.material.set((Attribute)TextureAttribute.createDiffuse((Texture)paletteTexture));
        this.material.set((Attribute)ColorAttribute.createDiffuse((Color)new Color(0.7f, 0.7f, 0.7f, 1.0f)));
        this.material.set((Attribute)new BlendingAttribute(true, 770, 771, opacity));
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public void generateMeshes(Point3DReadOnly startPoint, Point3DReadOnly endPoint) {
        this.meshBuilder.addLine((Tuple3DReadOnly)startPoint, (Tuple3DReadOnly)endPoint, this.lineWidth, this.color);
        this.modelBuilder.begin();
        Mesh mesh = this.meshBuilder.generateMesh();
        if (mesh.getNumIndices() >= 65525) {
            mesh = this.getDecimatedMesh(10);
        }
        MeshPart meshPart = new MeshPart("xyz", mesh, 0, mesh.getNumIndices(), 4);
        this.modelBuilder.part(meshPart, this.material);
        if (this.lastModel != null) {
            this.lastModel.dispose();
        }
        this.lastModel = this.modelBuilder.end();
        this.modelInstance = new ModelInstance(this.lastModel);
        this.points.add(startPoint);
    }

    private Mesh getDecimatedMesh(int skip) {
        LogTools.warn((String)"Decimating mesh of spline: too many vertices");
        this.meshBuilder.clear();
        for (int i = skip; i < this.points.size(); i += skip) {
            this.meshBuilder.addLine((Tuple3DReadOnly)this.points.get(i - skip), (Tuple3DReadOnly)this.points.get(i), this.lineWidth, this.color);
        }
        return this.meshBuilder.generateMesh();
    }

    public void clear() {
        this.meshBuilder.clear();
        this.points.clear();
        if (this.lastModel != null) {
            this.lastModel.dispose();
            this.lastModel = null;
        }
        this.modelInstance = null;
    }

    public void getRenderables(Array<Renderable> renderables, Pool<Renderable> pool) {
        if (this.modelInstance != null) {
            this.modelInstance.getRenderables(renderables, pool);
        }
    }
}

