/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.rdx.visualizers;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g3d.ModelInstance;
import com.badlogic.gdx.graphics.g3d.Renderable;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Pool;
import us.ihmc.euclid.geometry.interfaces.Pose3DReadOnly;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.rdx.tools.LibGDXTools;
import us.ihmc.rdx.tools.RDXModelBuilder;

public class RDXSphereAndArrowGraphic {
    private final RigidBodyTransform tempTransform = new RigidBodyTransform();
    private ModelInstance arrow;
    private ModelInstance sphere;
    private boolean cleared = true;

    public void create(double sphereRadius, double arrowLength, Color color) {
        this.sphere = RDXModelBuilder.createSphere((float)sphereRadius, color);
        this.arrow = RDXModelBuilder.createArrow(arrowLength, color);
    }

    public void clear() {
        this.cleared = true;
    }

    public void setToPose(Pose3DReadOnly pose) {
        LibGDXTools.toLibGDX(pose, this.tempTransform, this.sphere.transform);
        LibGDXTools.toLibGDX(pose, this.tempTransform, this.arrow.transform);
        this.cleared = false;
    }

    public void setToTransform(RigidBodyTransformReadOnly transform) {
        this.tempTransform.set(transform);
        LibGDXTools.toLibGDX(this.tempTransform, this.sphere.transform);
        LibGDXTools.toLibGDX(this.tempTransform, this.arrow.transform);
        this.cleared = false;
    }

    public RigidBodyTransformReadOnly getTransform() {
        LibGDXTools.toEuclid(this.arrow.transform, this.tempTransform);
        return this.tempTransform;
    }

    public void getRenderables(Array<Renderable> renderables, Pool<Renderable> pool) {
        if (!this.cleared) {
            this.sphere.getRenderables(renderables, pool);
            this.arrow.getRenderables(renderables, pool);
        }
    }
}

