/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.rdx.visualizers;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g3d.Renderable;
import com.badlogic.gdx.graphics.g3d.RenderableProvider;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Pool;
import java.util.List;
import us.ihmc.euclid.tools.EuclidCoreFactories;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.graphicsDescription.appearance.AppearanceDefinition;
import us.ihmc.graphicsDescription.appearance.YoAppearance;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicPolynomial3D;
import us.ihmc.rdx.visualizers.RDXSplineBody;
import us.ihmc.robotics.math.trajectories.interfaces.PolynomialReadOnly;
import us.ihmc.robotics.time.TimeInterval;
import us.ihmc.robotics.time.TimeIntervalBasics;
import us.ihmc.robotics.time.TimeIntervalReadOnly;

public class RDXPolynomial
implements RenderableProvider {
    private static final int COLOR_RESOLUTION = 128;
    private final int resolution;
    private YoGraphicPolynomial3D.TrajectoryColorType currentColorType = YoGraphicPolynomial3D.TrajectoryColorType.VELOCITY_BASED;
    private final RDXSplineBody line;
    private final AppearanceDefinition[] colorPalette = RDXPolynomial.createColorPalette(128);

    public RDXPolynomial(double radius, int resolution) {
        this.resolution = resolution;
        this.line = new RDXSplineBody((float)radius);
    }

    public void clear() {
        this.line.clear();
    }

    public void compute(List<? extends Polynomial3DVariableHolder> polynomials) {
        int i;
        this.line.clear();
        if (polynomials.isEmpty()) {
            return;
        }
        List<Polynomial3DVariables> yoPolynomial3Ds = polynomials.stream().map(Polynomial3DVariables::new).toList();
        Point3D[] intermediatePositions = new Point3D[this.resolution];
        Vector3D[] intermediateVelocities = new Vector3D[this.resolution];
        Vector3D[] intermediateAccelerations = new Vector3D[this.resolution];
        double trajectoryTime = polynomials.get(polynomials.size() - 1).getFinalTime();
        int polynomialIndex = 0;
        double maxVelocity = 0.0;
        double maxAcceleration = 0.0;
        for (i = 0; i < this.resolution; ++i) {
            double t = (double)i / ((double)this.resolution - 1.0) * trajectoryTime;
            while (t > polynomials.get(polynomialIndex).getFinalTime()) {
                ++polynomialIndex;
            }
            Point3D intermediatePosition = new Point3D();
            Vector3D intermediateVelocity = new Vector3D();
            Vector3D intermediateAcceleration = new Vector3D();
            Polynomial3DVariables activePolynomial3D = yoPolynomial3Ds.get(polynomialIndex);
            activePolynomial3D.compute(t);
            intermediatePosition.set((Tuple3DReadOnly)activePolynomial3D.getPosition());
            intermediateVelocity.set((Tuple3DReadOnly)activePolynomial3D.getVelocity());
            intermediateAcceleration.set((Tuple3DReadOnly)activePolynomial3D.getAcceleration());
            intermediatePositions[i] = intermediatePosition;
            intermediateVelocities[i] = intermediateVelocity;
            intermediateAccelerations[i] = intermediateAcceleration;
            maxVelocity = Math.max(maxVelocity, activePolynomial3D.getVelocity().normSquared());
            maxAcceleration = Math.max(maxAcceleration, activePolynomial3D.getAcceleration().normSquared());
        }
        maxVelocity = Math.sqrt(maxVelocity);
        maxAcceleration = Math.sqrt(maxAcceleration);
        for (i = 0; i < this.resolution - 1; ++i) {
            this.line.setColor(switch (this.getCurrentColorType()) {
                case YoGraphicPolynomial3D.TrajectoryColorType.VELOCITY_BASED -> {
                    double velocity = intermediateVelocities[i].norm();
                    int colorIndex = (int)Math.round(((double)this.colorPalette.length - 1.0) * (velocity / maxVelocity));
                    yield new Color(this.colorPalette[colorIndex].getAwtColor().getRGB());
                }
                case YoGraphicPolynomial3D.TrajectoryColorType.ACCELERATION_BASED -> {
                    double acceleration = intermediateAccelerations[i].norm();
                    int colorIndex = (int)Math.round(((double)this.colorPalette.length - 1.0) * (acceleration / maxAcceleration));
                    yield new Color(this.colorPalette[colorIndex].getAwtColor().getRGB());
                }
                default -> Color.BLACK;
            });
            this.line.generateMeshes((Point3DReadOnly)intermediatePositions[i], (Point3DReadOnly)intermediatePositions[i + 1]);
        }
    }

    public void getRenderables(Array<Renderable> renderables, Pool<Renderable> pool) {
        this.line.getRenderables(renderables, pool);
    }

    private void setCurrentColorType(YoGraphicPolynomial3D.TrajectoryColorType colorType) {
        this.currentColorType = colorType;
    }

    private YoGraphicPolynomial3D.TrajectoryColorType getCurrentColorType() {
        return this.currentColorType;
    }

    private static AppearanceDefinition[] createColorPalette(int size) {
        AppearanceDefinition[] colorPalette = new AppearanceDefinition[size];
        for (int i = 0; i < size; ++i) {
            float hue = 240.0f * (1.0f - (float)i / ((float)size - 1.0f)) / 360.0f;
            colorPalette[i] = YoAppearance.Color((java.awt.Color)java.awt.Color.getHSBColor(hue, 0.9f, 0.9f));
        }
        return colorPalette;
    }

    public static interface Polynomial3DVariableHolder {
        public double getInitialTime();

        public double getFinalTime();

        public PolynomialReadOnly getPolynomialX();

        public PolynomialReadOnly getPolynomialY();

        public PolynomialReadOnly getPolynomialZ();
    }

    public static class Polynomial3DVariables
    implements Polynomial3DVariableHolder {
        private final PolynomialVariables xPolynomial;
        private final PolynomialVariables yPolynomial;
        private final PolynomialVariables zPolynomial;
        private final Point3DReadOnly position;
        private final Vector3DReadOnly velocity;
        private final Vector3DReadOnly acceleration;

        private Polynomial3DVariables(Polynomial3DVariableHolder holder) {
            this(holder.getPolynomialX(), holder.getPolynomialY(), holder.getPolynomialZ());
        }

        public Polynomial3DVariables(PolynomialReadOnly xPolynomial, PolynomialReadOnly yPolynomial, PolynomialReadOnly zPolynomial) {
            this(new PolynomialVariables(xPolynomial), new PolynomialVariables(yPolynomial), new PolynomialVariables(zPolynomial));
        }

        private Polynomial3DVariables(PolynomialVariables xPolynomial, PolynomialVariables yPolynomial, PolynomialVariables zPolynomial) {
            this.xPolynomial = xPolynomial;
            this.yPolynomial = yPolynomial;
            this.zPolynomial = zPolynomial;
            this.position = EuclidCoreFactories.newLinkedPoint3DReadOnly(xPolynomial::getPosition, yPolynomial::getPosition, zPolynomial::getPosition);
            this.velocity = EuclidCoreFactories.newLinkedVector3DReadOnly(xPolynomial::getVelocity, yPolynomial::getVelocity, zPolynomial::getVelocity);
            this.acceleration = EuclidCoreFactories.newLinkedVector3DReadOnly(xPolynomial::getAcceleration, yPolynomial::getAcceleration, zPolynomial::getAcceleration);
        }

        public void compute(double x) {
            this.xPolynomial.compute(x);
            this.yPolynomial.compute(x);
            this.zPolynomial.compute(x);
        }

        @Override
        public double getInitialTime() {
            return this.xPolynomial.getInitialTime();
        }

        @Override
        public double getFinalTime() {
            return this.xPolynomial.getFinalTime();
        }

        public Point3DReadOnly getPosition() {
            return this.position;
        }

        public Vector3DReadOnly getVelocity() {
            return this.velocity;
        }

        public Vector3DReadOnly getAcceleration() {
            return this.acceleration;
        }

        @Override
        public PolynomialVariables getPolynomialX() {
            return this.xPolynomial;
        }

        @Override
        public PolynomialVariables getPolynomialY() {
            return this.yPolynomial;
        }

        @Override
        public PolynomialVariables getPolynomialZ() {
            return this.zPolynomial;
        }
    }

    static class PolynomialVariables
    implements PolynomialReadOnly {
        private final double[] coefficients;
        private final int numberOfCoefficients;
        private final double[] xPowers;
        private double pos;
        private double vel;
        private double acc;
        private double t = Double.NaN;
        private final TimeIntervalBasics timeInterval = new TimeInterval();

        private PolynomialVariables(PolynomialReadOnly holder) {
            this(holder.getCoefficients(), holder.getNumberOfCoefficients(), (TimeIntervalReadOnly)holder.getTimeInterval());
        }

        private PolynomialVariables(double[] coefficients, int numberOfCoefficients, TimeIntervalReadOnly timeInterval) {
            this.coefficients = coefficients;
            this.numberOfCoefficients = numberOfCoefficients;
            this.xPowers = new double[coefficients.length];
            this.timeInterval.set(timeInterval);
        }

        public void initialize() {
        }

        public void compute(double x) {
            int i;
            this.setXPowers(this.xPowers, x);
            this.acc = 0.0;
            this.vel = 0.0;
            this.pos = 0.0;
            for (i = 0; i < this.numberOfCoefficients; ++i) {
                this.pos += this.coefficients[i] * this.xPowers[i];
            }
            for (i = 1; i < this.numberOfCoefficients; ++i) {
                this.vel += (double)i * this.coefficients[i] * this.xPowers[i - 1];
            }
            for (i = 2; i < this.numberOfCoefficients; ++i) {
                this.acc += (double)((i - 1) * i) * this.coefficients[i] * this.xPowers[i - 2];
            }
        }

        public void setXPowers(double[] xPowers, double x) {
            xPowers[0] = 1.0;
            for (int i = 1; i < xPowers.length; ++i) {
                xPowers[i] = xPowers[i - 1] * x;
            }
        }

        public int getMaximumNumberOfCoefficients() {
            return this.coefficients.length;
        }

        public double getPosition() {
            return this.pos;
        }

        public double getVelocity() {
            return this.vel;
        }

        public double getAcceleration() {
            return this.acc;
        }

        public double[] getCoefficients() {
            return this.coefficients;
        }

        public int getNumberOfCoefficients() {
            return this.numberOfCoefficients;
        }

        public double getCurrentTime() {
            return this.t;
        }

        public double getCoefficient(int idx) {
            return this.getCoefficients()[idx];
        }

        public TimeIntervalBasics getTimeInterval() {
            return this.timeInterval;
        }

        public double getValue() {
            return this.getPosition();
        }
    }
}

