/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.rdx.visualizers;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Mesh;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g3d.Attribute;
import com.badlogic.gdx.graphics.g3d.Material;
import com.badlogic.gdx.graphics.g3d.Model;
import com.badlogic.gdx.graphics.g3d.Renderable;
import com.badlogic.gdx.graphics.g3d.RenderableProvider;
import com.badlogic.gdx.graphics.g3d.attributes.ColorAttribute;
import com.badlogic.gdx.graphics.g3d.attributes.TextureAttribute;
import com.badlogic.gdx.graphics.g3d.model.MeshPart;
import com.badlogic.gdx.graphics.g3d.utils.ModelBuilder;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Pool;
import java.util.ArrayList;
import java.util.function.Function;
import org.apache.commons.lang3.tuple.ImmutablePair;
import us.ihmc.euclid.geometry.BoundingBox3D;
import us.ihmc.euclid.geometry.ConvexPolygon2D;
import us.ihmc.euclid.geometry.interfaces.BoundingBox3DReadOnly;
import us.ihmc.euclid.geometry.interfaces.ConvexPolygon2DReadOnly;
import us.ihmc.euclid.geometry.interfaces.Line3DReadOnly;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.shape.primitives.Box3D;
import us.ihmc.euclid.shape.primitives.interfaces.Box3DReadOnly;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.rdx.input.ImGui3DViewInput;
import us.ihmc.rdx.mesh.RDXIDMappedColorFunction;
import us.ihmc.rdx.mesh.RDXMeshGraphicTools;
import us.ihmc.rdx.mesh.RDXMultiColorMeshBuilder;
import us.ihmc.rdx.tools.RDXModelInstance;
import us.ihmc.rdx.ui.RDX3DPanel;
import us.ihmc.rdx.ui.RDX3DPanelTooltip;
import us.ihmc.robotics.geometry.GeometryTools;
import us.ihmc.robotics.geometry.PlanarRegion;
import us.ihmc.robotics.geometry.PlanarRegionTools;
import us.ihmc.robotics.geometry.PlanarRegionsList;
import us.ihmc.tools.thread.MissingThreadTools;
import us.ihmc.tools.thread.ResettableExceptionHandlingExecutorService;

public class RDXPlanarRegionsGraphic
implements RenderableProvider {
    private PlanarRegionsList planarRegionsList;
    private final ModelBuilder modelBuilder = new ModelBuilder();
    private Function<Integer, Color> colorFunction = new RDXIDMappedColorFunction();
    private boolean drawAreaText = false;
    private boolean drawBoundingBox = false;
    private boolean drawNormal;
    boolean mouseHovering = false;
    private volatile Runnable buildMeshAndCreateModelInstance = null;
    private String tooltipText = "";
    private RDX3DPanelTooltip tooltip;
    private RDXModelInstance modelInstance;
    private Model lastModel;
    private Texture paletteTexture = null;
    private int selectedRegionId = -1;
    private final ResettableExceptionHandlingExecutorService executorService = MissingThreadTools.newSingleThreadExecutor((String)this.getClass().getSimpleName(), (boolean)true, (int)1);

    public void clear() {
        this.generateMeshes(new PlanarRegionsList());
    }

    public void generateFlatGround() {
        this.generateMeshes(PlanarRegionsList.flatGround((double)20.0));
    }

    public void update() {
        if (this.buildMeshAndCreateModelInstance != null) {
            this.buildMeshAndCreateModelInstance.run();
            this.buildMeshAndCreateModelInstance = null;
        }
    }

    public void generateMeshesAsync(PlanarRegionsList planarRegionsList) {
        this.executorService.clearQueueAndExecute(() -> this.generateMeshes(planarRegionsList));
    }

    public synchronized void generateMeshes(PlanarRegionsList incomingPlanarRegionsList) {
        this.planarRegionsList = incomingPlanarRegionsList;
        if (incomingPlanarRegionsList == null) {
            incomingPlanarRegionsList = new PlanarRegionsList();
        }
        ArrayList<RDXMultiColorMeshBuilder> meshBuilders = new ArrayList<RDXMultiColorMeshBuilder>();
        for (PlanarRegion planarRegion : incomingPlanarRegionsList.getPlanarRegionsAsList()) {
            RDXMultiColorMeshBuilder meshBuilder = new RDXMultiColorMeshBuilder();
            meshBuilders.add(meshBuilder);
            this.singleRegionMeshBuilder(planarRegion, meshBuilder);
        }
        this.buildMeshAndCreateModelInstance = () -> {
            this.modelBuilder.begin();
            Material material = new Material();
            if (this.paletteTexture == null) {
                this.paletteTexture = RDXMultiColorMeshBuilder.loadPaletteTexture();
            }
            material.set((Attribute)TextureAttribute.createDiffuse((Texture)this.paletteTexture));
            material.set((Attribute)ColorAttribute.createDiffuse((Color)new Color(0.7f, 0.7f, 0.7f, 1.0f)));
            for (RDXMultiColorMeshBuilder meshBuilder : meshBuilders) {
                Mesh mesh = meshBuilder.generateMesh();
                MeshPart meshPart = new MeshPart("xyz", mesh, 0, mesh.getNumIndices(), 4);
                this.modelBuilder.part(meshPart, material);
            }
            if (this.lastModel != null) {
                this.lastModel.dispose();
            }
            this.lastModel = this.modelBuilder.end();
            this.modelInstance = new RDXModelInstance(this.lastModel);
        };
    }

    private void singleRegionMeshBuilder(PlanarRegion planarRegion, RDXMultiColorMeshBuilder meshBuilder) {
        RigidBodyTransform transformToWorld = planarRegion.getTransformToWorldCopy();
        Color color = this.colorFunction.apply(planarRegion.getRegionId());
        meshBuilder.addMultiLine((RigidBodyTransformReadOnly)transformToWorld, planarRegion.getConcaveHull(), 0.01, color, true);
        double totalArea = 0.0;
        for (ConvexPolygon2D convexPolygon : planarRegion.getConvexPolygons()) {
            meshBuilder.addPolygon((RigidBodyTransformReadOnly)transformToWorld, (ConvexPolygon2DReadOnly)convexPolygon, color);
            totalArea += convexPolygon.getArea();
        }
        if (this.drawBoundingBox) {
            BoundingBox3D boundingBox3D = planarRegion.getBoundingBox3dInWorld();
            Box3D box = GeometryTools.convertBoundingBox3DToBox3D((BoundingBox3DReadOnly)boundingBox3D);
            RDXMeshGraphicTools.drawBoxEdges(meshBuilder, (Box3DReadOnly)box, 0.005, color);
        }
        if (this.drawNormal) {
            Point3DReadOnly centroid = PlanarRegionTools.getCentroid3DInWorld((PlanarRegion)planarRegion);
            double length = 0.07;
            double radius = 0.004;
            double cylinderToConeLengthRatio = 0.8;
            double coneDiameterMultiplier = 1.8;
            RDXMeshGraphicTools.drawArrow(meshBuilder, (Tuple3DReadOnly)centroid, (Orientation3DReadOnly)transformToWorld.getRotation(), length, radius, cylinderToConeLengthRatio, coneDiameterMultiplier, color);
        }
    }

    public void calculate3DViewPick(ImGui3DViewInput input) {
        ImmutablePair regionsWithRay;
        Line3DReadOnly pickRayInWorld = input.getPickRayInWorld();
        if (pickRayInWorld != null && this.planarRegionsList != null && (regionsWithRay = PlanarRegionTools.intersectRegionsWithRay((PlanarRegionsList)this.planarRegionsList, (Point3DReadOnly)pickRayInWorld.getPoint(), (Vector3D)new Vector3D((Tuple3DReadOnly)pickRayInWorld.getDirection()))) != null) {
            this.mouseHovering = true;
            this.selectedRegionId = ((PlanarRegion)regionsWithRay.getRight()).getRegionId();
            this.tooltipText = ((PlanarRegion)regionsWithRay.getRight()).getDebugString();
            return;
        }
        this.selectedRegionId = -1;
        this.mouseHovering = false;
    }

    public void process3DViewInput(ImGui3DViewInput input) {
        if (this.tooltip != null) {
            this.tooltip.setInput(input);
        }
    }

    public void setupTooltip(RDX3DPanel panel3D, String text) {
        this.tooltip = new RDX3DPanelTooltip(panel3D);
        panel3D.addImGuiOverlayAddition(() -> {
            if (this.mouseHovering) {
                this.tooltip.render(this.tooltipText);
            }
        });
    }

    public void getRenderables(Array<Renderable> renderables, Pool<Renderable> pool) {
        if (this.modelInstance != null) {
            this.modelInstance.getRenderables(renderables, pool);
        }
    }

    public void destroy() {
        this.executorService.destroy();
    }

    public void setDrawAreaText(boolean drawAreaText) {
        this.drawAreaText = drawAreaText;
    }

    public void setDrawBoundingBox(boolean drawBoundingBox) {
        this.drawBoundingBox = drawBoundingBox;
    }

    public void setDrawNormal(boolean drawNormal) {
        this.drawNormal = drawNormal;
    }

    public void setColorFunction(Function<Integer, Color> colorFunction) {
        this.colorFunction = colorFunction;
    }
}

