/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.rdx.ui;

import imgui.ImGui;
import java.util.ArrayList;
import us.ihmc.rdx.imgui.ImGuiUniqueLabelMap;
import us.ihmc.rdx.tools.RDXIconTexture;
import us.ihmc.rdx.ui.RDX3DPanelToolbarButton;

public class RDX3DPanelToolbar {
    private boolean show = true;
    private final ImGuiUniqueLabelMap labels = new ImGuiUniqueLabelMap(this.getClass());
    private final float iconSize = 40.0f;
    private final ArrayList<RDX3DPanelToolbarButton> buttons = new ArrayList();

    public RDX3DPanelToolbarButton addButton() {
        RDX3DPanelToolbarButton toolbarButton = new RDX3DPanelToolbarButton();
        this.buttons.add(toolbarButton);
        return toolbarButton;
    }

    public void render(float mainWindowWidth, float mainWindowPosX, float mainWindowPosY) {
        if (this.buttons.size() > 0 && this.show) {
            float spaceBetweenButtons = 9.0f;
            float toolbarWidth = (float)this.buttons.size() * (40.0f + spaceBetweenButtons);
            float centerX = mainWindowWidth / 2.0f;
            float startX = centerX - toolbarWidth / 2.0f;
            float startY = 40.0f;
            float upGray = 1.0f;
            float hoverGray = 0.4f;
            float downGray = 0.2f;
            ImGui.pushStyleColor((int)21, (float)upGray, (float)upGray, (float)upGray, (float)0.5f);
            ImGui.pushStyleColor((int)22, (float)hoverGray, (float)hoverGray, (float)hoverGray, (float)0.8f);
            ImGui.pushStyleColor((int)23, (float)downGray, (float)downGray, (float)downGray, (float)0.9f);
            for (int i = 0; i < this.buttons.size(); ++i) {
                RDX3DPanelToolbarButton button = this.buttons.get(i);
                RDXIconTexture icon = button.getIconTexture();
                if (icon == null) continue;
                ImGui.setCursorPos((float)(startX + (float)i * (40.0f + spaceBetweenButtons)), (float)startY);
                float sizeX = 40.0f;
                float sizeY = 40.0f;
                float uv0X = 0.0f;
                float uv0Y = 0.0f;
                float uv1X = 1.0f;
                float uv1Y = 1.0f;
                float backgroundColorR = 1.0f;
                float backgroundColorG = 1.0f;
                float backgroundColorB = 1.0f;
                float backgroundColorA = 0.0f;
                float tintR = 1.0f;
                float tintG = 1.0f;
                float tintB = 1.0f;
                float tintA = 1.0f;
                int framePadding = 0;
                if (ImGui.imageButton((int)icon.getTexture().getTextureObjectHandle(), (float)sizeX, (float)sizeY, (float)uv0X, (float)uv0Y, (float)uv1X, (float)uv1Y, (int)framePadding, (float)backgroundColorR, (float)backgroundColorG, (float)backgroundColorB, (float)backgroundColorA, (float)tintR, (float)tintG, (float)tintB, (float)tintA)) {
                    button.onPressed();
                }
                button.setHovered(ImGui.isItemHovered());
                button.setDown(button.getHovered() && ImGui.isMouseDown((int)0));
                if (!ImGui.isItemHovered()) {
                    button.getTooltipTimer().reset();
                }
                if (button.getTooltipText() == null || !button.getTooltipTimer().isExpired(0.7)) continue;
                ImGui.setTooltip((String)button.getTooltipText());
            }
            ImGui.popStyleColor((int)3);
        }
    }

    public boolean isShow() {
        return this.show;
    }

    public void setShow(boolean show) {
        this.show = show;
    }
}

