/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.rdx.tools.assimp;

import com.badlogic.gdx.graphics.VertexAttribute;
import com.badlogic.gdx.graphics.g3d.model.data.ModelMesh;
import com.badlogic.gdx.graphics.g3d.model.data.ModelMeshPart;
import com.badlogic.gdx.utils.Array;
import gnu.trove.list.array.TShortArrayList;
import java.nio.FloatBuffer;
import java.util.HashMap;
import org.lwjgl.assimp.AIColor4D;
import org.lwjgl.assimp.AIFace;
import org.lwjgl.assimp.AIMesh;
import org.lwjgl.assimp.AIVector3D;
import us.ihmc.log.LogTools;

public class RDXAssimpMeshLoader {
    private final AIMesh assimpMesh;
    private boolean hasNormals;
    private boolean hasTangents;
    private boolean hasBitangents;
    private boolean hasColors;
    private boolean hasTextureCoordinates;
    private int numberOfVertices;
    private ModelMesh modelMesh;
    private static final HashMap<String, Integer> sameMeshIds = new HashMap();

    public RDXAssimpMeshLoader(AIMesh assimpMesh) {
        this.assimpMesh = assimpMesh;
    }

    public ModelMesh load() {
        this.modelMesh = new ModelMesh();
        Object meshName = this.assimpMesh.mName().dataString().trim();
        String originalMeshName = meshName;
        int indexOfThisName = sameMeshIds.computeIfAbsent((String)meshName, key -> 0);
        if (indexOfThisName > 0) {
            meshName = (String)meshName + indexOfThisName;
        }
        sameMeshIds.put(originalMeshName, indexOfThisName + 1);
        LogTools.debug((String)"Mesh name: {}", (Object)meshName);
        this.modelMesh.id = !((String)meshName).isEmpty() ? meshName : "";
        this.modelMesh.attributes = this.loadAttributes();
        this.modelMesh.vertices = this.loadVertices();
        Array parts = new Array();
        ModelMeshPart modelMeshPart = new ModelMeshPart();
        modelMeshPart.id = meshName;
        int primitiveTypes = this.assimpMesh.mPrimitiveTypes();
        int gdxPrimitiveType = this.getGdxPrimitiveType(primitiveTypes);
        int numberOfFaces = this.assimpMesh.mNumFaces();
        LogTools.debug((String)"Number of faces: {}", (Object)numberOfFaces);
        modelMeshPart.primitiveType = gdxPrimitiveType;
        TShortArrayList indexArray = new TShortArrayList();
        for (int i = 0; i < numberOfFaces; ++i) {
            AIFace assimpFace = (AIFace)this.assimpMesh.mFaces().get(i);
            for (int j = 0; j < assimpFace.mNumIndices(); ++j) {
                int faceVertexIndex = assimpFace.mIndices().get(j);
                indexArray.add((short)faceVertexIndex);
            }
        }
        modelMeshPart.indices = indexArray.toArray();
        LogTools.debug((String)"Number of indices: {}", (Object)modelMeshPart.indices.length);
        parts.add((Object)modelMeshPart);
        this.modelMesh.parts = (ModelMeshPart[])parts.toArray(ModelMeshPart.class);
        return this.modelMesh;
    }

    private int getGdxPrimitiveType(int primitiveTypes) {
        if (primitiveTypes == 1) {
            boolean gdxPrimitiveType = false;
            String message = "Points not implemented!";
            LogTools.error((String)message);
            throw new RuntimeException(message);
        }
        if (primitiveTypes == 2) {
            boolean gdxPrimitiveType = true;
            String message = "Lines not implemented!";
            LogTools.error((String)message);
            throw new RuntimeException(message);
        }
        if (primitiveTypes != 4) {
            if (primitiveTypes == 8) {
                String message = "Polygons not implemented!";
                LogTools.error((String)message);
                throw new RuntimeException(message);
            }
            String message = "Combined primitive type not implemented!";
            LogTools.error((String)message);
            throw new RuntimeException(message);
        }
        int gdxPrimitiveType = 4;
        return gdxPrimitiveType;
    }

    private VertexAttribute[] loadAttributes() {
        Array vertexAttributes = new Array();
        this.numberOfVertices = this.assimpMesh.mNumVertices();
        LogTools.debug((String)"Number of vertices: {}", (Object)this.numberOfVertices);
        if (this.numberOfVertices > 65536) {
            LogTools.error((String)"Mesh contains too many vertices! {}/{}", (Object)this.numberOfVertices, (Object)65536);
        }
        vertexAttributes.add((Object)VertexAttribute.Position());
        boolean bl = this.hasNormals = this.assimpMesh.mNormals() != null;
        if (this.hasNormals) {
            vertexAttributes.add((Object)VertexAttribute.Normal());
        }
        LogTools.debug((String)"Has normals: {}", (Object)this.hasNormals);
        boolean bl2 = this.hasTangents = this.assimpMesh.mTangents() != null;
        if (this.hasTangents) {
            vertexAttributes.add((Object)VertexAttribute.Tangent());
        }
        LogTools.debug((String)"Has tangents: {}", (Object)this.hasTangents);
        boolean bl3 = this.hasBitangents = this.assimpMesh.mTangents() != null;
        if (this.hasBitangents) {
            vertexAttributes.add((Object)VertexAttribute.Binormal());
        }
        LogTools.debug((String)"Has bitangents: {}", (Object)this.hasBitangents);
        boolean bl4 = this.hasColors = this.assimpMesh.mColors(0) != null;
        if (this.hasColors) {
            vertexAttributes.add((Object)VertexAttribute.ColorUnpacked());
        }
        LogTools.debug((String)"Has colors: {}", (Object)this.hasColors);
        boolean bl5 = this.hasTextureCoordinates = this.assimpMesh.mTextureCoords(0) != null;
        if (this.hasTextureCoordinates) {
            int unit = 0;
            vertexAttributes.add((Object)VertexAttribute.TexCoords((int)unit));
        }
        LogTools.debug((String)"Has texture coordinates: {}", (Object)this.hasTextureCoordinates);
        return (VertexAttribute[])vertexAttributes.toArray(VertexAttribute.class);
    }

    private float[] loadVertices() {
        AIVector3D.Buffer assimpVerticesVector3DS = this.assimpMesh.mVertices();
        int vertexSize = 3;
        if (this.hasNormals) {
            vertexSize += 3;
        }
        if (this.hasTangents) {
            vertexSize += 3;
        }
        if (this.hasBitangents) {
            vertexSize += 3;
        }
        if (this.hasColors) {
            vertexSize += 4;
        }
        if (this.hasTextureCoordinates) {
            vertexSize += 2;
        }
        FloatBuffer vertexHeapBuffer = FloatBuffer.allocate(this.numberOfVertices * vertexSize);
        for (int j = 0; j < this.numberOfVertices; ++j) {
            float x = ((AIVector3D)assimpVerticesVector3DS.get(j)).x();
            float y = ((AIVector3D)assimpVerticesVector3DS.get(j)).y();
            float z = ((AIVector3D)assimpVerticesVector3DS.get(j)).z();
            vertexHeapBuffer.put(x);
            vertexHeapBuffer.put(y);
            vertexHeapBuffer.put(z);
            if (this.hasNormals) {
                float normalX = ((AIVector3D)this.assimpMesh.mNormals().get(j)).x();
                float normalY = ((AIVector3D)this.assimpMesh.mNormals().get(j)).y();
                float normalZ = ((AIVector3D)this.assimpMesh.mNormals().get(j)).z();
                vertexHeapBuffer.put(normalX);
                vertexHeapBuffer.put(normalY);
                vertexHeapBuffer.put(normalZ);
            }
            if (this.hasTangents) {
                float tangentX = ((AIVector3D)this.assimpMesh.mTangents().get(j)).x();
                float tangentY = ((AIVector3D)this.assimpMesh.mTangents().get(j)).y();
                float tangentZ = ((AIVector3D)this.assimpMesh.mTangents().get(j)).z();
                vertexHeapBuffer.put(tangentX);
                vertexHeapBuffer.put(tangentY);
                vertexHeapBuffer.put(tangentZ);
            }
            if (this.hasBitangents) {
                float bitangentX = ((AIVector3D)this.assimpMesh.mBitangents().get(j)).x();
                float bitangentY = ((AIVector3D)this.assimpMesh.mBitangents().get(j)).y();
                float bitangentZ = ((AIVector3D)this.assimpMesh.mBitangents().get(j)).z();
                vertexHeapBuffer.put(bitangentX);
                vertexHeapBuffer.put(bitangentY);
                vertexHeapBuffer.put(bitangentZ);
            }
            if (this.hasColors) {
                float r = ((AIColor4D)this.assimpMesh.mColors(0).get(j)).r();
                float g = ((AIColor4D)this.assimpMesh.mColors(0).get(j)).g();
                float b = ((AIColor4D)this.assimpMesh.mColors(0).get(j)).b();
                float a = ((AIColor4D)this.assimpMesh.mColors(0).get(j)).a();
                vertexHeapBuffer.put(r);
                vertexHeapBuffer.put(g);
                vertexHeapBuffer.put(b);
                vertexHeapBuffer.put(a);
            }
            if (!this.hasTextureCoordinates) continue;
            float textureX = ((AIVector3D)this.assimpMesh.mTextureCoords(0).get(j)).x();
            float textureY = ((AIVector3D)this.assimpMesh.mTextureCoords(0).get(j)).y();
            vertexHeapBuffer.put(textureX);
            vertexHeapBuffer.put(textureY);
        }
        return vertexHeapBuffer.array();
    }

    public AIMesh getAssimpMesh() {
        return this.assimpMesh;
    }

    public ModelMesh getModelMesh() {
        return this.modelMesh;
    }
}

